/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ArrayCollector;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.RemoteValueRetrievedListener;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.distribution.MergingCompletableFuture;
import org.infinispan.interceptors.distribution.RemoteGetSingleKeyCollector;
import org.infinispan.interceptors.impl.ClusteringInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseDistributionInterceptor
extends ClusteringInterceptor {
    private static final Log log = LogFactory.getLog(BaseDistributionInterceptor.class);
    private static final Object LOST_PLACEHOLDER = new Object();
    @Inject
    protected RemoteValueRetrievedListener rvrl;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected TimeService timeService;
    @Inject
    protected InternalExpirationManager<Object, Object> expirationManager;
    protected boolean isL1Enabled;
    protected boolean isReplicated;
    private final ReadOnlyManyHelper readOnlyManyHelper = new ReadOnlyManyHelper();
    private final InvocationSuccessFunction<AbstractDataWriteCommand> primaryReturnHandler = this::primaryReturnHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Start
    public void configure() {
        this.isL1Enabled = this.cacheConfiguration.clustering().l1().enabled();
        this.isReplicated = this.cacheConfiguration.clustering().cacheMode().isReplicated();
    }

    @Override
    public final Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        if (command.isGroupOwner()) {
            return this.invokeNext(ctx, command);
        }
        Address primaryOwner = this.distributionManager.getCacheTopology().getDistribution(command.getGroupName()).primary();
        CompletionStage<ValidResponse> future = this.rpcManager.invokeCommand(primaryOwner, (ReplicableCommand)command, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, future.thenAccept(response -> {
            if (response instanceof SuccessfulResponse) {
                List cacheEntries = (List)response.getResponseValue();
                for (CacheEntry entry : cacheEntries) {
                    this.wrapRemoteEntry(ctx, entry.getKey(), entry, false);
                }
            }
        }));
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            if (this.isSynchronous(command)) {
                RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
                return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), rpcOptions));
            }
            this.rpcManager.sendToAll(command, DeliverOrder.PER_SENDER);
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command);
    }

    protected DistributionInfo retrieveDistributionInfo(LocalizedCacheTopology topology, ReplicableCommand command, Object key) {
        return topology.getSegmentDistribution(SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner));
    }

    protected <C extends FlagAffectedCommand & TopologyAffectedCommand> CompletionStage<Void> remoteGetSingleKey(InvocationContext ctx, C command, Object key, boolean isWrite) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        int topologyId = cacheTopology.getTopologyId();
        DistributionInfo info = this.retrieveDistributionInfo(cacheTopology, command, key);
        if (info.isReadOwner()) {
            if (log.isTraceEnabled()) {
                log.tracef("Key %s became local after wrapping, retrying command. Command topology is %d, current topology is %d", key, ((TopologyAffectedCommand)command).getTopologyId(), topologyId);
            }
            if (((TopologyAffectedCommand)command).getTopologyId() == topologyId) {
                throw new IllegalStateException();
            }
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Perform remote get for key %s. currentTopologyId=%s, owners=%s", key, topologyId, info.readOwners());
        }
        ClusteredGetCommand getCommand = this.cf.buildClusteredGetCommand(key, info.segmentId(), command.getFlagsBitSet());
        getCommand.setTopologyId(topologyId);
        getCommand.setWrite(isWrite);
        return this.rpcManager.invokeCommandStaggered(info.readOwners(), getCommand, new RemoteGetSingleKeyCollector(), this.rpcManager.getSyncRpcOptions()).thenAccept(response -> {
            Object responseValue = response.getResponseValue();
            if (responseValue == null) {
                if (this.rvrl != null) {
                    this.rvrl.remoteValueNotFound(key);
                }
                this.wrapRemoteEntry(ctx, key, NullCacheEntry.getInstance(), isWrite);
                return;
            }
            InternalCacheEntry ice = ((InternalCacheValue)responseValue).toInternalCacheEntry(key);
            if (this.rvrl != null) {
                this.rvrl.remoteValueFound(ice);
            }
            this.wrapRemoteEntry(ctx, key, ice, isWrite);
        });
    }

    protected void wrapRemoteEntry(InvocationContext ctx, Object key, CacheEntry ice, boolean isWrite) {
        this.entryFactory.wrapExternalEntry(ctx, key, ice, true, isWrite);
    }

    protected final Object handleNonTxWriteCommand(InvocationContext ctx, AbstractDataWriteCommand command) {
        Object key = command.getKey();
        CacheEntry entry = ctx.lookupEntry(key);
        if (this.isLocalModeForced(command)) {
            if (entry == null) {
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
            }
            return this.invokeNext(ctx, command);
        }
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        DistributionInfo info = cacheTopology.getSegmentDistribution(SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner));
        if (entry == null) {
            boolean load = this.shouldLoad(ctx, command, info);
            if (info.isPrimary()) {
                throw new IllegalStateException("Primary owner in writeCH should always be an owner in readCH as well.");
            }
            if (ctx.isOriginLocal()) {
                return this.invokeRemotely(ctx, command, info.primary());
            }
            if (load) {
                CompletionStage<Void> remoteGet = this.remoteGetSingleKey(ctx, command, command.getKey(), true);
                return this.asyncInvokeNext(ctx, (VisitableCommand)command, remoteGet);
            }
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
            return this.invokeNext(ctx, command);
        }
        if (info.isPrimary()) {
            return this.invokeNextThenApply(ctx, command, this.primaryReturnHandler);
        }
        if (ctx.isOriginLocal()) {
            return this.invokeRemotely(ctx, command, info.primary());
        }
        return this.invokeNext(ctx, command);
    }

    protected Object primaryReturnHandler(InvocationContext ctx, AbstractDataWriteCommand command, Object localResult) {
        if (!command.isSuccessful()) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", command);
            }
            return localResult;
        }
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        DistributionInfo distributionInfo = cacheTopology.getDistribution(command.getKey());
        List<Address> owners = distributionInfo.writeOwners();
        if (owners.size() == 1) {
            return localResult;
        }
        ValueMatcher originalMatcher = command.getValueMatcher();
        command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        if (!this.isSynchronous(command)) {
            if (this.isReplicated) {
                this.rpcManager.sendToAll(command, DeliverOrder.PER_SENDER);
            } else {
                this.rpcManager.sendToMany(owners, command, DeliverOrder.PER_SENDER);
            }
            command.setValueMatcher(originalMatcher.matcherForRetry());
            return localResult;
        }
        MapResponseCollector collector = MapResponseCollector.ignoreLeavers(this.isReplicated, owners.size());
        RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
        command.addFlags(FlagBitSets.BACKUP_WRITE);
        CompletionStage<Map<Address, Response>> remoteInvocation = this.isReplicated ? this.rpcManager.invokeCommandOnAll(command, collector, rpcOptions) : this.rpcManager.invokeCommand(owners, (ReplicableCommand)command, collector, rpcOptions);
        return BaseDistributionInterceptor.asyncValue(remoteInvocation.handle((responses, t) -> {
            command.setFlagsBitSet(command.getFlagsBitSet() & (FlagBitSets.BACKUP_WRITE ^ 0xFFFFFFFFFFFFFFFFL));
            command.setValueMatcher(originalMatcher.matcherForRetry());
            CompletableFutures.rethrowExceptionIfPresent(t);
            return localResult;
        }));
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            for (Object key : command.getKeys()) {
                if (ctx.lookupEntry(key) != null) continue;
                this.entryFactory.wrapExternalEntry(ctx, key, NullCacheEntry.getInstance(), true, false);
            }
            return this.invokeNext(ctx, command);
        }
        if (!ctx.isOriginLocal()) {
            for (Object key : command.getKeys()) {
                if (ctx.lookupEntry(key) != null) continue;
                return UnsureResponse.INSTANCE;
            }
            return this.invokeNext(ctx, command);
        }
        CompletionStage<Void> remoteGetFuture = this.remoteGetMany(ctx, command, command.getKeys());
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, remoteGetFuture);
    }

    protected <C extends FlagAffectedCommand & TopologyAffectedCommand> CompletionStage<Void> remoteGetMany(InvocationContext ctx, C command, Collection<?> keys) {
        return this.doRemoteGetMany(ctx, command, keys, (Map<Object, Collection<Address>>)null, false);
    }

    private <C extends FlagAffectedCommand & TopologyAffectedCommand> CompletionStage<Void> doRemoteGetMany(InvocationContext ctx, C command, Collection<?> keys, Map<Object, Collection<Address>> unsureOwners, boolean hasSuspectedOwner) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        Map<Address, List<Object>> requestedKeys = this.getKeysByOwner(ctx, keys, cacheTopology, null, unsureOwners);
        if (requestedKeys.isEmpty()) {
            for (Object key : keys) {
                if (ctx.lookupEntry(key) != null) continue;
                if (hasSuspectedOwner) {
                    throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
                }
                throw OutdatedTopologyException.RETRY_SAME_TOPOLOGY;
            }
            return CompletableFutures.completedNull();
        }
        GlobalTransaction gtx = ctx.isInTxScope() ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredReadCommandGenerator commandGenerator = new ClusteredReadCommandGenerator(requestedKeys, command.getFlagsBitSet(), ((TopologyAffectedCommand)command).getTopologyId(), gtx);
        RemoteGetManyKeyCollector collector = new RemoteGetManyKeyCollector(requestedKeys, ctx, command, unsureOwners, hasSuspectedOwner);
        return this.rpcManager.invokeCommands(requestedKeys.keySet(), commandGenerator, collector, this.rpcManager.getSyncRpcOptions()).thenCompose(unsureOwners1 -> {
            Collection<Object> keys1 = unsureOwners1 != null ? unsureOwners1.keySet() : Collections.emptyList();
            return this.doRemoteGetMany(ctx, command, keys1, (Map<Object, Collection<Address>>)unsureOwners1, collector.hasSuspectedOwner());
        });
    }

    protected void handleRemotelyRetrievedKeys(InvocationContext ctx, WriteCommand appliedCommand, List<?> remoteKeys) {
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.handleFunctionalReadManyCommand(ctx, command, this.readOnlyManyHelper);
    }

    protected <C extends TopologyAffectedCommand & FlagAffectedCommand> Object handleFunctionalReadManyCommand(InvocationContext ctx, C command, ReadManyCommandHelper<C> helper) {
        if (((FlagAffectedCommand)command).hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            return this.handleLocalOnlyReadManyCommand(ctx, command, helper.keys(command));
        }
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        Collection<?> keys = helper.keys(command);
        if (!ctx.isOriginLocal()) {
            return this.handleRemoteReadManyCommand(ctx, command, keys, helper);
        }
        if (keys.isEmpty()) {
            return Stream.empty();
        }
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        int estimateForOneNode = 2 * keys.size() / ch.getMembers().size();
        ArrayList<Object> availableKeys = new ArrayList<Object>(estimateForOneNode);
        Map<Address, List<Object>> requestedKeys = this.getKeysByOwner(ctx, keys, cacheTopology, availableKeys, null);
        CompletionStage<Void> requiredKeysFuture = helper.fetchRequiredKeys(cacheTopology, requestedKeys, availableKeys, ctx, command);
        if (requiredKeysFuture == null) {
            return BaseDistributionInterceptor.asyncValue(this.fetchAndApplyValues(ctx, command, helper, keys, (List<Object>)availableKeys, requestedKeys));
        }
        return BaseDistributionInterceptor.asyncValue(requiredKeysFuture.thenCompose(nil -> this.fetchAndApplyValues(ctx, command, helper, keys, (List<Object>)availableKeys, requestedKeys)));
    }

    private <C extends TopologyAffectedCommand & FlagAffectedCommand> MergingCompletableFuture<Object> fetchAndApplyValues(InvocationContext ctx, C command, ReadManyCommandHelper<C> helper, Collection<?> keys, List<Object> availableKeys, Map<Address, List<Object>> requestedKeys) {
        MergingCompletableFuture<Object> allFuture = new MergingCompletableFuture<Object>(requestedKeys.size() + (availableKeys.isEmpty() ? 0 : 1), new Object[keys.size()], helper::transformResult);
        this.handleLocallyAvailableKeys(ctx, command, availableKeys, allFuture, helper);
        int pos = availableKeys.size();
        for (Map.Entry<Address, List<Object>> addressKeys : requestedKeys.entrySet()) {
            List<Object> keysForAddress = addressKeys.getValue();
            ReadOnlyManyCommand remoteCommand = helper.copyForRemote(command, keysForAddress, ctx);
            remoteCommand.setTopologyId(command.getTopologyId());
            Address target = addressKeys.getKey();
            this.rpcManager.invokeCommand(target, (ReplicableCommand)remoteCommand, SingletonMapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions()).whenComplete(new ReadManyHandler(this, target, allFuture, ctx, command, keysForAddress, null, pos, helper));
            pos += keysForAddress.size();
        }
        return allFuture;
    }

    private Object handleLocalOnlyReadManyCommand(InvocationContext ctx, VisitableCommand command, Collection<?> keys) {
        for (Object key : keys) {
            if (ctx.lookupEntry(key) != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, NullCacheEntry.getInstance(), true, false);
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends TopologyAffectedCommand & VisitableCommand> Object handleRemoteReadManyCommand(InvocationContext ctx, C command, Collection<?> keys, InvocationSuccessFunction<C> remoteReturnHandler) {
        for (Object key : keys) {
            if (ctx.lookupEntry(key) != null) continue;
            return UnsureResponse.INSTANCE;
        }
        return this.invokeNextThenApply(ctx, command, remoteReturnHandler);
    }

    private <C extends VisitableCommand> void handleLocallyAvailableKeys(InvocationContext ctx, C command, List<Object> availableKeys, MergingCompletableFuture<Object> allFuture, ReadManyCommandHelper<C> helper) {
        if (availableKeys.isEmpty()) {
            return;
        }
        C localCommand = helper.copyForLocal(command, availableKeys);
        this.invokeNextAndHandle(ctx, localCommand, (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally(throwable);
            } else {
                try {
                    helper.applyLocalResult(allFuture, rv);
                    allFuture.countDown();
                }
                catch (Throwable t) {
                    allFuture.completeExceptionally(t);
                }
            }
            return BaseDistributionInterceptor.asyncValue(allFuture);
        });
    }

    private Map<Address, List<Object>> getKeysByOwner(InvocationContext ctx, Collection<?> keys, LocalizedCacheTopology cacheTopology, List<Object> availableKeys, Map<Object, Collection<Address>> ignoredOwners) {
        int capacity = cacheTopology.getMembers().size();
        HashMap<Address, List<Object>> requestedKeys = new HashMap<Address, List<Object>>(capacity);
        int estimateForOneNode = 2 * keys.size() / capacity;
        for (Object key : keys) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null) {
                DistributionInfo distributionInfo = cacheTopology.getDistribution(key);
                boolean foundExisting = false;
                Collection<Address> ignoreForKey = null;
                for (Address address : distributionInfo.readOwners()) {
                    List list;
                    if (address.equals(this.rpcManager.getAddress())) {
                        throw new IllegalStateException("Entry should be always wrapped!");
                    }
                    if (ignoredOwners != null) {
                        if (ignoreForKey == null) {
                            ignoreForKey = ignoredOwners.get(key);
                        }
                        if (ignoreForKey != null && ignoreForKey.contains(address)) continue;
                    }
                    if ((list = (List)requestedKeys.get(address)) == null) continue;
                    list.add(key);
                    foundExisting = true;
                    break;
                }
                if (foundExisting) continue;
                Address target = null;
                if (ignoredOwners == null) {
                    target = distributionInfo.primary();
                } else {
                    for (Address address2 : distributionInfo.readOwners()) {
                        if (ignoreForKey == null) {
                            ignoreForKey = ignoredOwners.get(key);
                        }
                        if (ignoreForKey != null && ignoreForKey.contains(address2)) continue;
                        target = address2;
                        break;
                    }
                }
                if (target == null) continue;
                ArrayList arrayList = new ArrayList(estimateForOneNode);
                arrayList.add(key);
                requestedKeys.put(target, arrayList);
                continue;
            }
            if (availableKeys == null) continue;
            availableKeys.add(key);
        }
        return requestedKeys;
    }

    protected Object wrapFunctionalManyResultOnNonOrigin(InvocationContext rCtx, Collection<?> keys, Object[] values) {
        return values;
    }

    protected Object[] unwrapFunctionalManyResultOnOrigin(InvocationContext ctx, List<Object> keys, Object responseValue) {
        return responseValue instanceof Object[] ? (Object[])responseValue : null;
    }

    private Object visitGetCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        if (ctx.lookupEntry(command.getKey()) != null) {
            return this.invokeNext(ctx, command);
        }
        if (!ctx.isOriginLocal()) {
            return UnsureResponse.INSTANCE;
        }
        if (!this.readNeedsRemoteValue(command)) {
            return null;
        }
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.remoteGetSingleKey(ctx, command, command.getKey(), false));
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        Object key = command.getKey();
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry != null) {
            if (ctx.isOriginLocal()) {
                return this.invokeNext(ctx, command);
            }
            return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> this.wrapFunctionalResultOnNonOriginOnReturn(rv, entry));
        }
        if (!ctx.isOriginLocal()) {
            return UnsureResponse.INSTANCE;
        }
        if (this.readNeedsRemoteValue(command)) {
            LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
            List<Address> owners = cacheTopology.getDistribution(key).readOwners();
            if (log.isTraceEnabled()) {
                log.tracef("Doing a remote get for key %s in topology %d to %s", key, cacheTopology.getTopologyId(), owners);
            }
            ReadOnlyKeyCommand remoteCommand = this.remoteReadOnlyCommand(ctx, command);
            remoteCommand.setTopologyId(cacheTopology.getTopologyId());
            CompletionStage<SuccessfulResponse> rpc = this.rpcManager.invokeCommandStaggered(owners, remoteCommand, new RemoteGetSingleKeyCollector(), this.rpcManager.getSyncRpcOptions());
            return BaseDistributionInterceptor.asyncValue(rpc).thenApply(ctx, command, (rCtx, rCommand, response) -> {
                Object responseValue = ((SuccessfulResponse)response).getResponseValue();
                return this.unwrapFunctionalResultOnOrigin(rCtx, rCommand.getKey(), responseValue);
            });
        }
        this.entryFactory.wrapExternalEntry(ctx, key, NullCacheEntry.getInstance(), true, false);
        return this.invokeNext(ctx, command);
    }

    protected ReadOnlyKeyCommand remoteReadOnlyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) {
        return command;
    }

    protected Object wrapFunctionalResultOnNonOriginOnReturn(Object rv, CacheEntry entry) {
        return rv;
    }

    protected Object unwrapFunctionalResultOnOrigin(InvocationContext ctx, Object key, Object responseValue) {
        return responseValue;
    }

    protected Object invokeRemotely(InvocationContext ctx, DataWriteCommand command, Address primaryOwner) {
        CompletionStage<ValidResponse> remoteInvocation;
        boolean isSyncForwarding;
        if (log.isTraceEnabled()) {
            this.getLog().tracef("I'm not the primary owner, so sending the command to the primary owner(%s) in order to be forwarded", primaryOwner);
        }
        boolean bl = isSyncForwarding = this.isSynchronous(command) || command.isReturnValueExpected();
        if (!isSyncForwarding) {
            this.rpcManager.sendTo(primaryOwner, command, DeliverOrder.PER_SENDER);
            return null;
        }
        try {
            remoteInvocation = this.rpcManager.invokeCommand(primaryOwner, (ReplicableCommand)command, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
        }
        catch (Throwable t2) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
            throw t2;
        }
        return BaseDistributionInterceptor.asyncValue(remoteInvocation).andHandle(ctx, command, (rCtx, dataWriteCommand, rv, t) -> {
            dataWriteCommand.setValueMatcher(dataWriteCommand.getValueMatcher().matcherForRetry());
            CompletableFutures.rethrowExceptionIfPresent(t);
            Response response = (Response)rv;
            if (!response.isSuccessful()) {
                dataWriteCommand.fail();
            } else if (!(response instanceof ValidResponse)) {
                throw BaseDistributionInterceptor.unexpected(primaryOwner, response);
            }
            return ((ValidResponse)response).getResponseValue();
        });
    }

    protected boolean readNeedsRemoteValue(FlagAffectedCommand command) {
        return !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP);
    }

    private class RemoteGetManyKeyCollector
    implements ResponseCollector<Map<Object, Collection<Address>>> {
        private final Map<Address, List<Object>> requestedKeys;
        private final InvocationContext ctx;
        private final ReplicableCommand command;
        private Map<Object, Collection<Address>> unsureOwners;
        private boolean hasSuspectedOwner;

        public RemoteGetManyKeyCollector(Map<Address, List<Object>> requestedKeys, InvocationContext ctx, ReplicableCommand command, Map<Object, Collection<Address>> unsureOwners, boolean hasSuspectedOwner) {
            this.requestedKeys = requestedKeys;
            this.ctx = ctx;
            this.command = command;
            this.unsureOwners = unsureOwners;
            this.hasSuspectedOwner = hasSuspectedOwner;
        }

        @Override
        public Map<Object, Collection<Address>> addResponse(Address sender, Response response) {
            if (!(response instanceof SuccessfulResponse)) {
                if (response instanceof CacheNotFoundResponse) {
                    this.hasSuspectedOwner = true;
                    this.addUnsureOwner(sender);
                    return null;
                }
                if (response instanceof UnsureResponse) {
                    this.addUnsureOwner(sender);
                    return null;
                }
                if (response instanceof ExceptionResponse) {
                    throw CompletableFutures.asCompletionException(((ExceptionResponse)response).getException());
                }
                throw BaseDistributionInterceptor.unexpected(sender, response);
            }
            SuccessfulResponse successfulResponse = (SuccessfulResponse)response;
            Object responseValue = successfulResponse.getResponseValue();
            if (!(responseValue instanceof InternalCacheValue[])) {
                throw CompletableFutures.asCompletionException(new IllegalStateException("Unexpected response value: " + responseValue));
            }
            List<Object> senderKeys = this.requestedKeys.get(sender);
            InternalCacheValue[] values = (InternalCacheValue[])responseValue;
            for (int i = 0; i < senderKeys.size(); ++i) {
                Object key = senderKeys.get(i);
                InternalCacheValue value = values[i];
                NullCacheEntry entry = value == null ? NullCacheEntry.getInstance() : value.toInternalCacheEntry(key);
                BaseDistributionInterceptor.this.wrapRemoteEntry(this.ctx, key, entry, false);
            }
            BaseDistributionInterceptor.this.handleRemotelyRetrievedKeys(this.ctx, this.command instanceof WriteCommand ? (WriteCommand)this.command : null, senderKeys);
            return null;
        }

        public void addUnsureOwner(Address sender) {
            if (this.unsureOwners == null) {
                this.unsureOwners = new HashMap<Object, Collection<Address>>();
            }
            List<Object> senderKeys = this.requestedKeys.get(sender);
            for (Object key : senderKeys) {
                Collection<Address> keyUnsureOwners = this.unsureOwners.get(key);
                if (keyUnsureOwners == null) {
                    keyUnsureOwners = new ArrayList<Address>();
                    this.unsureOwners.put(key, keyUnsureOwners);
                }
                keyUnsureOwners.add(sender);
            }
        }

        @Override
        public Map<Object, Collection<Address>> finish() {
            return this.unsureOwners;
        }

        public boolean hasSuspectedOwner() {
            return this.hasSuspectedOwner;
        }
    }

    private class ClusteredReadCommandGenerator
    implements Function<Address, ReplicableCommand> {
        private final Map<Address, List<Object>> requestedKeys;
        private final long flags;
        private final int topologyId;
        private final GlobalTransaction gtx;

        public ClusteredReadCommandGenerator(Map<Address, List<Object>> requestedKeys, long flags, int topologyId, GlobalTransaction gtx) {
            this.requestedKeys = requestedKeys;
            this.flags = flags;
            this.topologyId = topologyId;
            this.gtx = gtx;
        }

        @Override
        public ReplicableCommand apply(Address target) {
            List<Object> targetKeys = this.requestedKeys.get(target);
            assert (!targetKeys.isEmpty());
            ClusteredGetAllCommand getCommand = BaseDistributionInterceptor.this.cf.buildClusteredGetAllCommand(targetKeys, this.flags, this.gtx);
            getCommand.setTopologyId(this.topologyId);
            return getCommand;
        }
    }

    protected class ReadOnlyManyHelper
    implements ReadManyCommandHelper<ReadOnlyManyCommand> {
        protected ReadOnlyManyHelper() {
        }

        @Override
        public Object apply(InvocationContext rCtx, ReadOnlyManyCommand rCommand, Object rv) throws Throwable {
            return BaseDistributionInterceptor.this.wrapFunctionalManyResultOnNonOrigin(rCtx, rCommand.getKeys(), ((Stream)rv).toArray());
        }

        @Override
        public Collection<?> keys(ReadOnlyManyCommand command) {
            return command.getKeys();
        }

        @Override
        public ReadOnlyManyCommand copyForLocal(ReadOnlyManyCommand command, List<Object> keys) {
            return new ReadOnlyManyCommand(command).withKeys(keys);
        }

        @Override
        public ReadOnlyManyCommand copyForRemote(ReadOnlyManyCommand command, List<Object> keys, InvocationContext ctx) {
            return new ReadOnlyManyCommand(command).withKeys(keys);
        }

        @Override
        public void applyLocalResult(MergingCompletableFuture allFuture, Object rv) {
            ((Stream)rv).collect(new ArrayCollector((Object[])allFuture.results));
        }

        @Override
        public Object transformResult(Object[] results) {
            return Arrays.stream(results).filter(o -> o != LOST_PLACEHOLDER);
        }

        @Override
        public CompletionStage<Void> fetchRequiredKeys(LocalizedCacheTopology cacheTopology, Map<Address, List<Object>> requestedKeys, List<Object> availableKeys, InvocationContext ctx, ReadOnlyManyCommand command) {
            return null;
        }
    }

    protected static interface ReadManyCommandHelper<C extends VisitableCommand>
    extends InvocationSuccessFunction<C> {
        public Collection<?> keys(C var1);

        public C copyForLocal(C var1, List<Object> var2);

        public ReadOnlyManyCommand copyForRemote(C var1, List<Object> var2, InvocationContext var3);

        public void applyLocalResult(MergingCompletableFuture var1, Object var2);

        public Object transformResult(Object[] var1);

        public CompletionStage<Void> fetchRequiredKeys(LocalizedCacheTopology var1, Map<Address, List<Object>> var2, List<Object> var3, InvocationContext var4, C var5);
    }

    private static class ReadManyHandler<C extends FlagAffectedCommand & TopologyAffectedCommand>
    implements BiConsumer<Map<Address, Response>, Throwable> {
        private final Address target;
        private final MergingCompletableFuture<Object> allFuture;
        private final InvocationContext ctx;
        private final C command;
        private final List<Object> keys;
        private final int destinationIndex;
        private final Map<Object, Collection<Address>> contactedNodes;
        private final ReadManyCommandHelper<C> helper;
        final /* synthetic */ BaseDistributionInterceptor this$0;

        private ReadManyHandler(Address target, MergingCompletableFuture<Object> allFuture, InvocationContext ctx, C command, List<Object> keys, Map<Object, Collection<Address>> contactedNodes, int destinationIndex, ReadManyCommandHelper<C> helper) {
            this.this$0 = var1_1;
            this.target = target;
            this.allFuture = allFuture;
            this.ctx = ctx;
            this.command = command;
            this.keys = keys;
            this.destinationIndex = destinationIndex;
            this.contactedNodes = contactedNodes;
            this.helper = helper;
        }

        @Override
        public void accept(Map<Address, Response> responseMap, Throwable throwable) {
            if (throwable != null) {
                this.allFuture.completeExceptionally(throwable);
                return;
            }
            SuccessfulResponse response = BaseDistributionInterceptor.getSuccessfulResponseOrFail(responseMap, this.allFuture, this::handleMissingResponse);
            if (response == null) {
                return;
            }
            try {
                Object responseValue = response.getResponseValue();
                Object[] values = this.this$0.unwrapFunctionalManyResultOnOrigin(this.ctx, this.keys, responseValue);
                if (values != null) {
                    System.arraycopy(values, 0, this.allFuture.results, this.destinationIndex, values.length);
                    this.allFuture.countDown();
                } else {
                    this.allFuture.completeExceptionally(new IllegalStateException("Unexpected response value " + responseValue));
                }
            }
            catch (Throwable t) {
                this.allFuture.completeExceptionally(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMissingResponse(Response response) {
            Map requestedKeys;
            Map<Object, Object> contactedNodes;
            if (response instanceof UnsureResponse) {
                this.allFuture.hasUnsureResponse = true;
            }
            Map<Object, Object> map = contactedNodes = this.contactedNodes == null ? new HashMap() : this.contactedNodes;
            synchronized (map) {
                for (Object object : this.keys) {
                    contactedNodes.computeIfAbsent(object, k -> new ArrayList(4)).add(this.target);
                }
                requestedKeys = this.this$0.getKeysByOwner(this.ctx, this.keys, this.this$0.checkTopologyId((TopologyAffectedCommand)this.command), null, contactedNodes);
            }
            int pos = this.destinationIndex;
            for (Map.Entry entry : requestedKeys.entrySet()) {
                this.allFuture.increment();
                List keysForAddress = (List)entry.getValue();
                ReadOnlyManyCommand remoteCommand = this.helper.copyForRemote(this.command, keysForAddress, this.ctx);
                remoteCommand.setTopologyId(((TopologyAffectedCommand)this.command).getTopologyId());
                Address target = (Address)entry.getKey();
                this.this$0.rpcManager.invokeCommand(target, (ReplicableCommand)remoteCommand, SingletonMapResponseCollector.ignoreLeavers(), this.this$0.rpcManager.getSyncRpcOptions()).whenComplete(new ReadManyHandler(this.this$0, target, this.allFuture, this.ctx, this.command, keysForAddress, contactedNodes, pos, this.helper));
                pos += keysForAddress.size();
            }
            Arrays.fill(this.allFuture.results, pos, this.destinationIndex + this.keys.size(), LOST_PLACEHOLDER);
            this.allFuture.lostData = true;
            this.allFuture.countDown();
        }
    }
}

