/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.util.function.SerializableFunction;

public final class QueryDefinition {
    private final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider;
    private final String queryString;
    private SearchQueryBuilder searchQuery;
    private int maxResults = 100;
    private int firstResult;
    private long timeout = -1L;
    private Set<String> sortableFields;
    private Class<?> indexedType;
    private final Map<String, Object> namedParameters = new HashMap<String, Object>();

    public QueryDefinition(String queryString, SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString cannot be null");
        }
        if (queryEngineProvider == null) {
            throw new IllegalArgumentException("queryEngineProvider cannot be null");
        }
        this.queryString = queryString;
        this.queryEngineProvider = queryEngineProvider;
    }

    public QueryDefinition(String queryString, SearchQueryBuilder searchQuery) {
        if (searchQuery == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        this.searchQuery = searchQuery;
        this.queryString = queryString;
        this.queryEngineProvider = null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    private QueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        if (this.queryEngineProvider == null) {
            throw new IllegalStateException("No query engine provider specified");
        }
        QueryEngine queryEngine = (QueryEngine)((Object)this.queryEngineProvider.apply(cache));
        if (queryEngine == null) {
            throw new IllegalStateException("The provider could not locate a suitable query engine");
        }
        return queryEngine;
    }

    public void initialize(AdvancedCache<?, ?> cache) {
        if (this.searchQuery == null) {
            QueryEngine queryEngine = this.getQueryEngine(cache);
            this.searchQuery = queryEngine.buildSearchQuery(this.queryString, this.namedParameters);
            if (this.timeout > 0L) {
                this.searchQuery.failAfter(this.timeout, TimeUnit.NANOSECONDS);
            }
        }
    }

    public SearchQueryBuilder getSearchQuery() {
        if (this.searchQuery == null) {
            throw new IllegalStateException("The QueryDefinition has not been initialized, make sure to call initialize(...) first");
        }
        return this.searchQuery;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setNamedParameters(Map<String, Object> params) {
        if (params == null) {
            this.namedParameters.clear();
        } else {
            this.namedParameters.putAll(params);
        }
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public Set<String> getSortableFields() {
        return this.sortableFields;
    }

    public void setSortableField(Set<String> sortableField) {
        this.sortableFields = sortableField;
    }

    public Class<?> getIndexedType() {
        return this.indexedType;
    }

    public void setIndexedType(Class<?> indexedType) {
        this.indexedType = indexedType;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.getSearchQuery().failAfter(timeout, timeUnit);
    }

    public static final class Externalizer
    implements AdvancedExternalizer<QueryDefinition> {
        public Set<Class<? extends QueryDefinition>> getTypeClasses() {
            return Collections.singleton(QueryDefinition.class);
        }

        public Integer getId() {
            return ExternalizerIds.QUERY_DEFINITION;
        }

        public void writeObject(ObjectOutput output, QueryDefinition queryDefinition) throws IOException {
            output.writeUTF(queryDefinition.queryString);
            output.writeObject(queryDefinition.queryEngineProvider);
            output.writeInt(queryDefinition.firstResult);
            output.writeInt(queryDefinition.maxResults);
            output.writeObject(queryDefinition.sortableFields);
            output.writeObject(queryDefinition.indexedType);
            output.writeLong(queryDefinition.timeout);
            Map namedParameters = queryDefinition.namedParameters;
            int paramSize = namedParameters.size();
            output.writeShort(paramSize);
            if (paramSize != 0) {
                for (Map.Entry param : namedParameters.entrySet()) {
                    output.writeUTF((String)param.getKey());
                    output.writeObject(param.getValue());
                }
            }
        }

        public QueryDefinition readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String queryString = input.readUTF();
            SerializableFunction queryEngineProvider = (SerializableFunction)input.readObject();
            QueryDefinition queryDefinition = new QueryDefinition(queryString, queryEngineProvider);
            queryDefinition.setFirstResult(input.readInt());
            queryDefinition.setMaxResults(input.readInt());
            Set sortableField = (Set)input.readObject();
            queryDefinition.setSortableField(sortableField);
            Class indexedType = (Class)input.readObject();
            queryDefinition.setIndexedType(indexedType);
            queryDefinition.timeout = input.readLong();
            int paramSize = input.readShort();
            if (paramSize != 0) {
                HashMap<String, Object> params = new HashMap<String, Object>(paramSize);
                for (int i = 0; i < paramSize; ++i) {
                    String key = input.readUTF();
                    Object value = input.readObject();
                    params.put(key, value);
                }
                queryDefinition.setNamedParameters(params);
            }
            return queryDefinition;
        }
    }
}

