/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.util.UUID;
import org.hibernate.search.engine.cfg.spi.ValidateUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultUUIDValueBridge
implements ValueBridge<UUID, String> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toIndexedValue(UUID value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.toString();
    }

    @Override
    public UUID fromIndexedValue(String value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : UUID.fromString(value);
    }

    @Override
    public String parse(String value) {
        ValidateUtils.validateUUID((String)value);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }
}

