/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractCompositeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundTypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoIndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelType;
import org.hibernate.search.mapper.pojo.model.dependency.PojoTypeIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoTypeIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class TypeBindingContextImpl<T>
extends AbstractCompositeBindingContext
implements TypeBindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    private final PojoTypeModel<T> typeModel;
    private final PojoModelTypeRootElement<T> bridgedElement;
    private final PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext;
    private final IndexFieldTypeFactory indexFieldTypeFactory;
    private final PojoIndexSchemaContributionListener listener;
    private final IndexSchemaElement indexSchemaElement;
    private PartialBinding<T> partialBinding;

    public TypeBindingContextImpl(BeanResolver beanResolver, PojoBootstrapIntrospector introspector, PojoTypeModel<T> typeModel, IndexBindingContext indexBindingContext, PojoModelTypeRootElement<T> bridgedElement, PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext) {
        super(beanResolver);
        this.introspector = introspector;
        this.typeModel = typeModel;
        this.bridgedElement = bridgedElement;
        this.dependencyContext = dependencyContext;
        this.indexFieldTypeFactory = indexBindingContext.createTypeFactory();
        this.listener = new PojoIndexSchemaContributionListener();
        this.indexSchemaElement = indexBindingContext.schemaElement((IndexSchemaContributionListener)this.listener);
    }

    @Override
    public <T2> void bridge(Class<T2> expectedEntityType, TypeBridge<T2> bridge) {
        this.bridge(expectedEntityType, BeanHolder.of(bridge));
    }

    @Override
    public <T2> void bridge(Class<T2> expectedEntityType, BeanHolder<? extends TypeBridge<T2>> bridgeHolder) {
        this.checkAndBind(bridgeHolder, this.introspector.typeModel(expectedEntityType));
    }

    @Override
    public PojoModelType bridgedElement() {
        return this.bridgedElement;
    }

    @Override
    public PojoTypeIndexingDependencyConfigurationContext dependencies() {
        return this.dependencyContext;
    }

    @Override
    public IndexFieldTypeFactory typeFactory() {
        return this.indexFieldTypeFactory;
    }

    @Override
    public IndexSchemaElement indexSchemaElement() {
        return this.indexSchemaElement;
    }

    public Optional<BoundTypeBridge<T>> applyBinder(TypeBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            TypeBindingContextImpl.checkBridgeDependencies(this.bridgedElement, this.dependencyContext);
            if (!this.listener.isAnySchemaContributed()) {
                try (Object closer = new Closer();){
                    this.partialBinding.abort((AbstractCloser<?, ?>)closer);
                }
                closer = Optional.empty();
                return closer;
            }
            Optional<BoundTypeBridge<T>> closer = Optional.of(this.partialBinding.complete(this.bridgedElement, this.dependencyContext));
            return closer;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private <T2> void checkAndBind(BeanHolder<? extends TypeBridge<T2>> bridgeHolder, PojoRawTypeModel<?> expectedPropertyTypeModel) {
        if (!this.typeModel.rawType().isSubTypeOf(expectedPropertyTypeModel)) {
            throw log.invalidInputTypeForBridge(bridgeHolder.get(), this.typeModel, expectedPropertyTypeModel);
        }
        BeanHolder<? extends TypeBridge<T2>> castedBridgeHolder = bridgeHolder;
        this.partialBinding = new PartialBinding(castedBridgeHolder);
    }

    private static class PartialBinding<T> {
        private final BeanHolder<? extends TypeBridge<? super T>> bridgeHolder;

        private PartialBinding(BeanHolder<? extends TypeBridge<? super T>> bridgeHolder) {
            this.bridgeHolder = bridgeHolder;
        }

        void abort(AbstractCloser<?, ?> closer) {
            closer.push(TypeBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }

        BoundTypeBridge<T> complete(PojoModelTypeRootElement<T> bridgedElement, PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext) {
            return new BoundTypeBridge<T>(this.bridgeHolder, bridgedElement, dependencyContext);
        }
    }
}

