/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.Tree;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.JoinType;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.ql.QueryResolverDelegate;
import org.infinispan.objectfilter.impl.syntax.parser.EmbeddedEntityTypeDescriptor;
import org.infinispan.objectfilter.impl.syntax.parser.EntityTypeDescriptor;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.jboss.logging.Logger;

final class QueryResolverDelegateImpl<TypeMetadata>
implements QueryResolverDelegate<TypeDescriptor<TypeMetadata>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)QueryResolverDelegateImpl.class.getName());
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final Map<String, PropertyPath<TypeDescriptor<TypeMetadata>>> aliasToPropertyPath = new HashMap<String, PropertyPath<TypeDescriptor<TypeMetadata>>>();
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    private String targetType;
    private TypeMetadata entityMetadata;
    private String alias;
    private Phase phase;

    QueryResolverDelegateImpl(ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    @Override
    public void registerPersisterSpace(String entityName, Tree aliasTree) {
        String aliasText = aliasTree.getText();
        String prevAlias = this.aliasToEntityType.put(aliasText, entityName);
        if (prevAlias != null && !prevAlias.equalsIgnoreCase(entityName)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: aliasText " + aliasText + " already assigned to type " + prevAlias);
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + entityName);
        }
        this.targetType = entityName;
        this.entityMetadata = this.propertyHelper.getEntityMetadata(entityName);
        if (this.entityMetadata == null) {
            throw log.getUnknownEntity(entityName);
        }
    }

    @Override
    public void registerJoinAlias(Tree alias, PropertyPath<TypeDescriptor<TypeMetadata>> path) {
        if (!path.isEmpty() && !this.aliasToPropertyPath.containsKey(alias.getText())) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }

    @Override
    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizeUnqualifiedPropertyReference(Tree propertyNameTree) {
        String property = propertyNameTree.getText();
        if (this.aliasToEntityType.containsKey(property)) {
            return this.normalizeQualifiedRoot(propertyNameTree);
        }
        EntityTypeDescriptor<TypeMetadata> type = new EntityTypeDescriptor<TypeMetadata>(this.targetType, this.entityMetadata);
        return this.normalizeProperty(type, Collections.emptyList(), property);
    }

    @Override
    public boolean isPersisterReferenceAlias() {
        return this.aliasToEntityType.containsKey(this.alias);
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizeUnqualifiedRoot(Tree aliasTree) {
        String alias = aliasTree.getText();
        if (this.aliasToEntityType.containsKey(alias)) {
            return this.normalizeQualifiedRoot(aliasTree);
        }
        PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath = this.aliasToPropertyPath.get(alias);
        if (propertyPath == null) {
            throw log.getUnknownAliasException(alias);
        }
        List<String> resolvedAlias = this.resolveAlias(propertyPath);
        TypeDescriptor<TypeMetadata> sourceType = propertyPath.getFirst().getTypeDescriptor();
        EmbeddedEntityTypeDescriptor<TypeMetadata> type = new EmbeddedEntityTypeDescriptor<TypeMetadata>(sourceType.getTypeName(), sourceType.getTypeMetadata(), resolvedAlias);
        return new PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>(alias, type, true);
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizeQualifiedRoot(Tree root) {
        String alias = root.getText();
        String entityNameForAlias = this.aliasToEntityType.get(alias);
        if (entityNameForAlias == null) {
            PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath = this.aliasToPropertyPath.get(alias);
            if (propertyPath == null) {
                throw log.getUnknownAliasException(alias);
            }
            return new PropertyPath.PropertyReference<Object>(propertyPath.asStringPathWithoutAlias(), null, false);
        }
        TypeMetadata entityMetadata = this.propertyHelper.getEntityMetadata(entityNameForAlias);
        if (entityMetadata == null) {
            throw log.getUnknownEntity(entityNameForAlias);
        }
        return new PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>(alias, new EntityTypeDescriptor<TypeMetadata>(entityNameForAlias, entityMetadata), true);
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizePropertyPathIntermediary(PropertyPath<TypeDescriptor<TypeMetadata>> path, Tree propertyNameTree) {
        String propertyName = propertyNameTree.getText();
        TypeDescriptor<TypeMetadata> sourceType = path.getLast().getTypeDescriptor();
        if (!this.propertyHelper.hasProperty(sourceType.getTypeMetadata(), sourceType.makePath(propertyName))) {
            throw log.getNoSuchPropertyException(sourceType.getTypeName(), propertyName);
        }
        List<String> newPath = this.resolveAlias(path);
        newPath.add(propertyName);
        EmbeddedEntityTypeDescriptor<TypeMetadata> type = new EmbeddedEntityTypeDescriptor<TypeMetadata>(sourceType.getTypeName(), sourceType.getTypeMetadata(), newPath);
        return new PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>(propertyName, type, false);
    }

    private List<String> resolveAlias(PropertyPath<TypeDescriptor<TypeMetadata>> path) {
        if (path.isAlias()) {
            String alias = path.getFirst().getPropertyName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return path.getNodeNamesWithoutAlias();
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath = this.aliasToPropertyPath.get(alias);
                List<String> resolvedAlias = this.resolveAlias(propertyPath);
                resolvedAlias.addAll(path.getNodeNamesWithoutAlias());
                return resolvedAlias;
            }
            throw log.getUnknownAliasException(alias);
        }
        return path.getNodeNamesWithoutAlias();
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizeIntermediateIndexOperation(PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> propertyReference, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void normalizeTerminalIndexOperation(PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> propertyReference, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizeUnqualifiedPropertyReferenceSource(Tree identifier) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizePropertyPathTerminus(PropertyPath<TypeDescriptor<TypeMetadata>> path, Tree propertyNameTree) {
        return this.normalizeProperty(path.getLast().getTypeDescriptor(), path.getNodeNamesWithoutAlias(), propertyNameTree.getText());
    }

    private PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>> normalizeProperty(TypeDescriptor<TypeMetadata> type, List<String> path, String propertyName) {
        String[] propertyPath = type.makePath(propertyName);
        if (!this.propertyHelper.hasProperty(type.getTypeMetadata(), propertyPath)) {
            throw log.getNoSuchPropertyException(type.getTypeName(), propertyName);
        }
        EmbeddedEntityTypeDescriptor<TypeMetadata> propType = null;
        if (this.propertyHelper.hasEmbeddedProperty(type.getTypeMetadata(), propertyPath)) {
            LinkedList<String> newPath = new LinkedList<String>(path);
            newPath.add(propertyName);
            propType = new EmbeddedEntityTypeDescriptor<TypeMetadata>(type.getTypeName(), type.getTypeMetadata(), newPath);
        }
        return new PropertyPath.PropertyReference<Object>(propertyName, propType, false);
    }

    @Override
    public void activateFromStrategy(JoinType joinType, Tree associationFetchTree, Tree propertyFetchTree, Tree aliasTree) {
        this.phase = Phase.FROM;
        this.alias = aliasTree.getText();
    }

    @Override
    public void activateSelectStrategy() {
        this.phase = Phase.SELECT;
    }

    @Override
    public void deactivateStrategy() {
        this.phase = null;
        this.alias = null;
    }

    @Override
    public void propertyPathCompleted(PropertyPath<TypeDescriptor<TypeMetadata>> path) {
        TypeDescriptor<TypeMetadata> type;
        if (this.phase == Phase.SELECT && (type = path.getLast().getTypeDescriptor()) instanceof EmbeddedEntityTypeDescriptor) {
            throw log.getProjectionOfCompleteEmbeddedEntitiesNotSupportedException(type.getTypeName(), path.asStringPathWithoutAlias());
        }
    }

    private static enum Phase {
        SELECT,
        FROM;

    }
}

