/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.logging.impl;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=900000, max=909999), @ValidIdRange(min=17, max=17), @ValidIdRange(min=18, max=18), @ValidIdRange(min=58, max=58)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_LEGACY_ENGINE = 0;
    public static final int ID_OFFSET = 900000;

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Work discarded, thread was interrupted while waiting for space to schedule: %1$s")
    public void interruptedWorkError(Runnable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=58, value="%1$s")
    public void exceptionOccurred(String var1, @Cause Throwable var2);

    @Message(id=900000, value="'%1$s' must not be null.")
    public IllegalArgumentException mustNotBeNull(String var1);

    @Message(id=900001, value="'%1$s' must not be null or empty.")
    public IllegalArgumentException collectionMustNotBeNullNorEmpty(String var1);

    @Message(id=900002, value="'%1$s' must be positive or zero.")
    public IllegalArgumentException mustBePositiveOrZero(String var1);

    @Message(id=900003, value="'%1$s' must not be null or empty.")
    public IllegalArgumentException stringMustNotBeNullNorEmpty(String var1);

    @Message(id=900004, value="'%1$s' must not be null or empty.")
    public IllegalArgumentException arrayMustNotBeNullNorEmpty(String var1);

    @Message(id=900005, value="Exception while invoking '%1$s' on '%2$s'.")
    public SearchException errorInvokingMember(Member var1, String var2, @Cause Throwable var3);

    @Message(id=900006, value="Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter.")
    public IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3);

    @Message(id=900007, value="Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s).")
    public IllegalArgumentException typeParameterIndexOutOfBound(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3, int var4);

    @Message(id=900008, value="Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater.")
    public IllegalArgumentException invalidTypeParameterIndex(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=900009, value="Unable to access the value of containing annotation '%1$s'. Ignoring annotation.")
    public void cannotAccessRepeateableContainingAnnotationValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Throwable var2);

    @Message(id=900010, value="'%1$s' must be strictly positive.")
    public IllegalArgumentException mustBeStrictlyPositive(String var1);
}

