/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.core.stats.QueryStatisticsSnapshot;
import org.infinispan.query.core.stats.impl.QueryMetrics;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;

@ProtoTypeId(value=4202)
@Scope(value=Scopes.NAMED_CACHE)
public class LocalQueryStatistics
implements QueryStatisticsSnapshot {
    @ProtoField(number=1)
    QueryMetrics localIndexedQueries = new QueryMetrics();
    @ProtoField(number=2)
    QueryMetrics distIndexedQueries = new QueryMetrics();
    @ProtoField(number=3)
    QueryMetrics hybridQueries = new QueryMetrics();
    @ProtoField(number=4)
    QueryMetrics nonIndexedQueries = new QueryMetrics();
    @ProtoField(number=5)
    QueryMetrics loads = new QueryMetrics();
    @Inject
    Configuration configuration;
    @Inject
    AuthorizationHelper authorizationHelper;

    public LocalQueryStatistics() {
    }

    @ProtoFactory
    LocalQueryStatistics(QueryMetrics localIndexedQueries, QueryMetrics distIndexedQueries, QueryMetrics hybridQueries, QueryMetrics nonIndexedQueries, QueryMetrics loads) {
        this.localIndexedQueries = localIndexedQueries;
        this.distIndexedQueries = distIndexedQueries;
        this.hybridQueries = hybridQueries;
        this.nonIndexedQueries = nonIndexedQueries;
        this.loads = loads;
    }

    public void localIndexedQueryExecuted(String q, long timeNanos) {
        this.localIndexedQueries.record(q, timeNanos);
    }

    public void distributedIndexedQueryExecuted(String q, long timeNanos) {
        this.distIndexedQueries.record(q, timeNanos);
    }

    public void hybridQueryExecuted(String q, long timeNanos) {
        this.hybridQueries.record(q, timeNanos);
    }

    public void nonIndexedQueryExecuted(String q, long timeNanos) {
        this.nonIndexedQueries.record(q, timeNanos);
    }

    public void entityLoaded(long timeNanos) {
        this.loads.record(timeNanos);
    }

    @Override
    public long getLocalIndexedQueryCount() {
        return this.localIndexedQueries.count();
    }

    @Override
    public long getDistributedIndexedQueryCount() {
        return this.distIndexedQueries.count();
    }

    @Override
    public long getHybridQueryCount() {
        return this.hybridQueries.count();
    }

    @Override
    public long getNonIndexedQueryCount() {
        return this.nonIndexedQueries.count();
    }

    @Override
    public long getLocalIndexedQueryTotalTime() {
        return this.localIndexedQueries.totalTime();
    }

    @Override
    public long getDistributedIndexedQueryTotalTime() {
        return this.distIndexedQueries.totalTime();
    }

    @Override
    public long getHybridQueryTotalTime() {
        return this.hybridQueries.totalTime();
    }

    @Override
    public long getNonIndexedQueryTotalTime() {
        return this.nonIndexedQueries.totalTime();
    }

    @Override
    public long getLocalIndexedQueryMaxTime() {
        return this.localIndexedQueries.maxTime();
    }

    @Override
    public long getDistributedIndexedQueryMaxTime() {
        return this.distIndexedQueries.maxTime();
    }

    @Override
    public long getHybridQueryMaxTime() {
        return this.hybridQueries.maxTime();
    }

    @Override
    public long getNonIndexedQueryMaxTime() {
        return this.nonIndexedQueries.maxTime();
    }

    @Override
    public double getLocalIndexedQueryAvgTime() {
        return this.localIndexedQueries.avg();
    }

    @Override
    public double getDistributedIndexedQueryAvgTime() {
        return this.distIndexedQueries.avg();
    }

    @Override
    public double getHybridQueryAvgTime() {
        return this.hybridQueries.avg();
    }

    @Override
    public double getNonIndexedQueryAvgTime() {
        return this.nonIndexedQueries.avg();
    }

    @Override
    public String getSlowestLocalIndexedQuery() {
        return this.localIndexedQueries.slowest();
    }

    @Override
    public String getSlowestDistributedIndexedQuery() {
        return this.distIndexedQueries.slowest();
    }

    @Override
    public String getSlowestHybridQuery() {
        return this.hybridQueries.slowest();
    }

    @Override
    public String getSlowestNonIndexedQuery() {
        return this.nonIndexedQueries.slowest();
    }

    @Override
    public long getLoadMaxTime() {
        return this.loads.maxTime();
    }

    @Override
    public double getLoadAvgTime() {
        return this.loads.avg();
    }

    @Override
    public long getLoadCount() {
        return this.loads.count();
    }

    @Override
    public long getLoadTotalTime() {
        return this.loads.totalTime();
    }

    protected QueryMetrics getLocalIndexedQueries() {
        return this.localIndexedQueries;
    }

    protected QueryMetrics getDistIndexedQueries() {
        return this.distIndexedQueries;
    }

    protected QueryMetrics getHybridQueries() {
        return this.hybridQueries;
    }

    protected QueryMetrics getNonIndexedQueries() {
        return this.nonIndexedQueries;
    }

    public QueryMetrics getLoads() {
        return this.loads;
    }

    @Override
    public boolean isEnabled() {
        return this.configuration.statistics().enabled();
    }

    @Override
    public CompletionStage<QueryStatisticsSnapshot> computeSnapshot() {
        return CompletableFuture.completedFuture(new LocalQueryStatistics().merge(this));
    }

    @Override
    public void clear() {
        this.authorizationHelper.checkPermission(AuthorizationPermission.ADMIN);
        this.localIndexedQueries.clear();
        this.distIndexedQueries.clear();
        this.nonIndexedQueries.clear();
        this.hybridQueries.clear();
        this.loads.clear();
    }

    private void mergeMetrics(QueryMetrics metrics, long count, long totalTime, long maxTime, String slowest) {
        metrics.count.add(count);
        metrics.totalTime.add(totalTime);
        if (metrics.maxTime.longValue() < maxTime) {
            metrics.maxTime.set(maxTime);
            metrics.slowest = slowest;
        }
    }

    @Override
    public QueryStatisticsSnapshot merge(QueryStatisticsSnapshot other) {
        this.mergeMetrics(this.localIndexedQueries, other.getLocalIndexedQueryCount(), other.getLocalIndexedQueryTotalTime(), other.getLocalIndexedQueryMaxTime(), other.getSlowestLocalIndexedQuery());
        this.mergeMetrics(this.distIndexedQueries, other.getDistributedIndexedQueryCount(), other.getDistributedIndexedQueryTotalTime(), other.getDistributedIndexedQueryMaxTime(), other.getSlowestDistributedIndexedQuery());
        this.mergeMetrics(this.hybridQueries, other.getHybridQueryCount(), other.getHybridQueryTotalTime(), other.getHybridQueryMaxTime(), other.getSlowestHybridQuery());
        this.mergeMetrics(this.nonIndexedQueries, other.getNonIndexedQueryCount(), other.getNonIndexedQueryMaxTime(), other.getNonIndexedQueryMaxTime(), other.getSlowestNonIndexedQuery());
        this.mergeMetrics(this.loads, other.getLoadCount(), other.getLoadTotalTime(), other.getLoadMaxTime(), null);
        return this;
    }

    public Json toJson() {
        return Json.object().set("indexed_local", Json.make((Object)this.getLocalIndexedQueries())).set("indexed_distributed", Json.make((Object)this.getDistIndexedQueries())).set("hybrid", Json.make((Object)this.getHybridQueries())).set("non_indexed", Json.make((Object)this.getNonIndexedQueries())).set("entity_load", Json.make((Object)this.getLoads()));
    }
}

