/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StreamCache;
import org.apache.camel.Traceable;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTapProcessor
extends AsyncProcessorSupport
implements Traceable,
ShutdownAware,
IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(WireTapProcessor.class);
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final SendDynamicProcessor dynamicProcessor;
    private final String uri;
    private final boolean dynamicUri;
    private final Processor processor;
    private final AsyncProcessor asyncProcessor;
    private final ExchangePattern exchangePattern;
    private final ExecutorService executorService;
    private volatile boolean shutdownExecutorService;
    private final LongAdder taskCount = new LongAdder();
    private Expression newExchangeExpression;
    private List<Processor> newExchangeProcessors;
    private boolean copy;
    private Processor onPrepare;

    public WireTapProcessor(SendDynamicProcessor dynamicProcessor, Processor processor, ExchangePattern exchangePattern, ExecutorService executorService, boolean shutdownExecutorService, boolean dynamicUri) {
        this.dynamicProcessor = dynamicProcessor;
        this.uri = dynamicProcessor.getUri();
        this.processor = processor;
        this.asyncProcessor = AsyncProcessorConverterHelper.convert((Processor)processor);
        this.exchangePattern = exchangePattern;
        ObjectHelper.notNull((Object)executorService, (String)"executorService");
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.dynamicUri = dynamicUri;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "wireTap(" + this.uri + ")";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        return this.taskCount.intValue();
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.dynamicProcessor.getEndpointUtilizationStatistics();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange target;
        if (!this.isStarted()) {
            throw new IllegalStateException("WireTapProcessor has not been started: " + (Object)((Object)this));
        }
        try {
            target = this.configureExchange(exchange, this.exchangePattern);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        Exchange wireTapExchange = target;
        try {
            this.executorService.submit(() -> {
                this.taskCount.increment();
                LOG.debug(">>>> (wiretap) {} {}", (Object)this.uri, (Object)wireTapExchange);
                this.asyncProcessor.process(wireTapExchange, doneSync -> {
                    if (wireTapExchange.getException() != null) {
                        String u = URISupport.sanitizeUri((String)this.uri);
                        LOG.warn("Error occurred during processing " + wireTapExchange + " wiretap to " + u + ". This exception will be ignored.", (Throwable)wireTapExchange.getException());
                    }
                    this.taskCount.decrement();
                });
            });
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) throws IOException {
        StreamCache cache;
        StreamCache copied;
        Message msg;
        Iterator<Processor> body;
        Exchange answer = this.copy ? this.configureCopyExchange(exchange) : this.configureNewExchange(exchange);
        if (this.newExchangeExpression != null && (body = this.newExchangeExpression.evaluate(answer, Object.class)) != null) {
            answer.getIn().setBody(body);
        }
        if (this.newExchangeProcessors != null) {
            for (Processor processor : this.newExchangeProcessors) {
                try {
                    processor.process(answer);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
        if ((msg = answer.getMessage()).getBody() instanceof StreamCache && (copied = (cache = (StreamCache)msg.getBody()).copy(answer)) != null) {
            msg.setBody((Object)copied);
        }
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(answer);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    private Exchange configureCopyExchange(Exchange exchange) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        copy.setPattern(ExchangePattern.InOnly);
        copy.removeProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK);
        return copy;
    }

    private Exchange configureNewExchange(Exchange exchange) {
        return new DefaultExchange(exchange.getFromEndpoint(), ExchangePattern.InOnly);
    }

    public List<Processor> getNewExchangeProcessors() {
        return this.newExchangeProcessors;
    }

    public void setNewExchangeProcessors(List<Processor> newExchangeProcessors) {
        this.newExchangeProcessors = newExchangeProcessors;
    }

    public Expression getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(Expression newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    public void addNewExchangeProcessor(Processor processor) {
        if (this.newExchangeProcessors == null) {
            this.newExchangeProcessors = new ArrayList<Processor>();
        }
        this.newExchangeProcessors.add(processor);
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public String getUri() {
        return this.uri;
    }

    public int getCacheSize() {
        return this.dynamicProcessor.getCacheSize();
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.dynamicProcessor.isIgnoreInvalidEndpoint();
    }

    public boolean isDynamicUri() {
        return this.dynamicUri;
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }
}

