/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.service.GridServiceMethodNotFoundException;
import org.apache.ignite.internal.processors.service.GridServiceMethodReflectKey;
import org.apache.ignite.internal.processors.service.GridServiceNotFoundException;
import org.apache.ignite.internal.processors.service.ServiceContextImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.platform.PlatformServiceMethod;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.services.Service;

public class GridServiceProxy<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Method PLATFORM_SERVICE_INVOKE_METHOD;
    @GridToStringExclude
    private final IgniteLogger log;
    private final T proxy;
    private final ClusterGroup prj;
    @GridToStringExclude
    private final GridKernalContext ctx;
    private final AtomicReference<ClusterNode> rmtNode = new AtomicReference();
    private boolean hasLocNode;
    private final String name;
    private final boolean sticky;
    private final long waitTimeout;

    public GridServiceProxy(ClusterGroup prj, String name, Class<? super T> svc, boolean sticky, long timeout, GridKernalContext ctx) {
        assert (timeout >= 0L) : timeout;
        this.prj = prj;
        this.ctx = ctx;
        this.name = name;
        this.sticky = sticky;
        this.waitTimeout = timeout;
        this.hasLocNode = this.hasLocalNode(prj);
        this.log = ctx.log(this.getClass());
        this.proxy = Proxy.newProxyInstance(svc.getClassLoader(), new Class[]{svc}, (InvocationHandler)new ProxyInvocationHandler());
    }

    private boolean hasLocalNode(ClusterGroup prj) {
        for (ClusterNode n : prj.nodes()) {
            if (!n.isLocal()) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public Object invokeMethod(Method mtd, Object[] args) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object callServiceLocally(Service svc, Method mtd, Object[] args) throws Exception {
        if (svc instanceof PlatformService && !PLATFORM_SERVICE_INVOKE_METHOD.equals(mtd)) {
            return ((PlatformService)svc).invokeMethod(this.methodName(mtd), false, true, args);
        }
        return mtd.invoke((Object)svc, args);
    }

    private ClusterNode nodeForService(String name, boolean sticky) throws IgniteCheckedException {
        while (sticky) {
            ClusterNode curNode = this.rmtNode.get();
            if (curNode != null) {
                return curNode;
            }
            curNode = this.randomNodeForService(name);
            if (curNode == null) {
                return null;
            }
            if (!this.rmtNode.compareAndSet(null, curNode)) continue;
            return curNode;
        }
        return this.randomNodeForService(name);
    }

    private ClusterNode randomNodeForService(String name) throws IgniteCheckedException {
        if (this.hasLocNode && this.ctx.service().service(name) != null) {
            return this.ctx.discovery().localNode();
        }
        Map<UUID, Integer> snapshot = this.ctx.service().serviceTopology(name, this.waitTimeout);
        if (snapshot == null || snapshot.isEmpty()) {
            return null;
        }
        if (snapshot.size() == 1) {
            UUID nodeId = snapshot.keySet().iterator().next();
            return this.prj.node(nodeId);
        }
        Collection<ClusterNode> nodes = this.prj.nodes();
        if (nodes.size() == 1) {
            ClusterNode n = nodes.iterator().next();
            return snapshot.containsKey(n.id()) ? n : null;
        }
        if (this.prj.predicate() == F.alwaysTrue()) {
            int idx = ThreadLocalRandom.current().nextInt(snapshot.size());
            int i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (i++ < idx || e.getValue() <= 0) continue;
                return this.ctx.discovery().node(e.getKey());
            }
            i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (e.getValue() > 0) {
                    return this.ctx.discovery().node(e.getKey());
                }
                if (i++ != idx) continue;
                return null;
            }
        } else {
            ArrayList<ClusterNode> nodeList = new ArrayList<ClusterNode>(nodes.size());
            for (ClusterNode n : nodes) {
                Integer cnt = snapshot.get(n.id());
                if (cnt == null || cnt <= 0) continue;
                nodeList.add(n);
            }
            if (nodeList.isEmpty()) {
                return null;
            }
            int idx = ThreadLocalRandom.current().nextInt(nodeList.size());
            return (ClusterNode)nodeList.get(idx);
        }
        return null;
    }

    T proxy() {
        return this.proxy;
    }

    String methodName(Method mtd) {
        PlatformServiceMethod ann = mtd.getDeclaredAnnotation(PlatformServiceMethod.class);
        return ann == null ? mtd.getName() : ann.value();
    }

    static {
        try {
            PLATFORM_SERVICE_INVOKE_METHOD = PlatformService.class.getMethod("invokeMethod", String.class, Boolean.TYPE, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError("'invokeMethod' is not defined in " + PlatformService.class.getName());
        }
    }

    private static class ServiceProxyException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        ServiceProxyException(Throwable cause) {
            super(cause);
        }
    }

    private static class ServiceProxyCallable
    implements IgniteCallable<Object>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String mtdName;
        private String svcName;
        private Class<?>[] argTypes;
        private Object[] args;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public ServiceProxyCallable() {
        }

        private ServiceProxyCallable(String mtdName, String svcName, Class<?>[] argTypes, Object[] args) {
            this.mtdName = mtdName;
            this.svcName = svcName;
            this.argTypes = argTypes;
            this.args = args;
        }

        @Override
        public Object call() throws Exception {
            ServiceContextImpl ctx = this.ignite.context().service().serviceContext(this.svcName);
            if (ctx == null || ctx.service() == null) {
                throw new GridServiceNotFoundException(this.svcName);
            }
            GridServiceMethodReflectKey key = new GridServiceMethodReflectKey(this.mtdName, this.argTypes);
            Method mtd = ctx.method(key);
            if (ctx.service() instanceof PlatformService && mtd == null) {
                return this.callPlatformService((PlatformService)ctx.service());
            }
            return this.callService(ctx.service(), mtd);
        }

        private Object callPlatformService(PlatformService srv) {
            try {
                return srv.invokeMethod(this.mtdName, false, true, this.args);
            }
            catch (PlatformNativeException ne) {
                throw new ServiceProxyException(U.convertException(ne));
            }
            catch (Exception e) {
                throw new ServiceProxyException(e);
            }
        }

        private Object callService(Service srv, Method mtd) throws Exception {
            if (mtd == null) {
                throw new GridServiceMethodNotFoundException(this.svcName, this.mtdName, this.argTypes);
            }
            try {
                return mtd.invoke((Object)srv, this.args);
            }
            catch (InvocationTargetException e) {
                throw new ServiceProxyException(e.getCause());
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.svcName);
            U.writeString(out, this.mtdName);
            U.writeArray(out, this.argTypes);
            U.writeArray(out, this.args);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.svcName = U.readString(in);
            this.mtdName = U.readString(in);
            this.argTypes = U.readClassArray(in);
            this.args = U.readArray(in);
        }

        public String toString() {
            return S.toString(ServiceProxyCallable.class, this);
        }
    }

    private class ProxyInvocationHandler
    implements InvocationHandler {
        private ProxyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            return GridServiceProxy.this.invokeMethod(mtd, args);
        }
    }
}

