/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.PlatformCacheConfiguration;
import org.apache.ignite.configuration.SerializeSeparately;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.jetbrains.annotations.Nullable;

public class CacheConfiguration<K, V>
extends MutableConfiguration<K, V> {
    private static final long serialVersionUID = 0L;
    public static final int MAX_PARTITIONS_COUNT = 65000;
    @Deprecated
    public static final int DFLT_REBALANCE_THREAD_POOL_SIZE = 4;
    @Deprecated
    public static final long DFLT_REBALANCE_TIMEOUT = 10000L;
    @Deprecated
    public static final long DFLT_REBALANCE_BATCHES_PREFETCH_COUNT = 3L;
    @Deprecated
    public static final long DFLT_REBALANCE_THROTTLE = 0L;
    public static final int DFLT_BACKUPS = 0;
    public static final CacheMode DFLT_CACHE_MODE = CacheMode.PARTITIONED;
    public static final CacheAtomicityMode DFLT_CACHE_ATOMICITY_MODE = CacheAtomicityMode.ATOMIC;
    @Deprecated
    public static final long DFLT_LOCK_TIMEOUT = 0L;
    public static final int DFLT_CACHE_SIZE = 100000;
    public static final int DFLT_SQL_INDEX_MAX_INLINE_SIZE = -1;
    public static final int DFLT_NEAR_START_SIZE = 375000;
    public static final boolean DFLT_INVALIDATE = false;
    public static final CacheRebalanceMode DFLT_REBALANCE_MODE = CacheRebalanceMode.ASYNC;
    @Deprecated
    public static final int DFLT_REBALANCE_BATCH_SIZE = 524288;
    public static final boolean DFLT_EAGER_TTL = true;
    public static final int DFLT_MAX_CONCURRENT_ASYNC_OPS = 500;
    public static final boolean DFLT_WRITE_BEHIND_ENABLED = false;
    public static final int DFLT_WRITE_BEHIND_FLUSH_SIZE = 10240;
    public static final int DFLT_WRITE_BEHIND_CRITICAL_SIZE = 16384;
    public static final long DFLT_WRITE_BEHIND_FLUSH_FREQUENCY = 5000L;
    public static final int DFLT_WRITE_FROM_BEHIND_FLUSH_THREAD_CNT = 1;
    public static final int DFLT_WRITE_BEHIND_BATCH_SIZE = 512;
    public static final boolean DFLT_WRITE_BEHIND_COALESCING = true;
    public static final int DFLT_MAX_QUERY_ITERATOR_CNT = 1024;
    public static final boolean DFLT_LOAD_PREV_VAL = false;
    public static final boolean DFLT_READ_FROM_BACKUP = true;
    public static final IgnitePredicate<ClusterNode> ALL_NODES = new IgniteAllNodesPredicate();
    @Deprecated
    public static final long DFLT_LONG_QRY_WARN_TIMEOUT = 3000L;
    public static final int DFLT_QRY_DETAIL_METRICS_SIZE = 0;
    public static final Boolean DFLT_STORE_KEEP_BINARY = new Boolean(false);
    public static final int DFLT_CONCURRENT_LOAD_ALL_THRESHOLD = 5;
    public static final PartitionLossPolicy DFLT_PARTITION_LOSS_POLICY = PartitionLossPolicy.IGNORE;
    public static final int DFLT_QUERY_PARALLELISM = 1;
    public static final boolean DFLT_EVENTS_DISABLED = false;
    public static final int DFLT_SQL_ONHEAP_CACHE_MAX_SIZE = 0;
    public static final DiskPageCompression DFLT_DISK_PAGE_COMPRESSION = DiskPageCompression.DISABLED;
    private String name;
    private String grpName;
    private String memPlcName;
    private int storeConcurrentLoadAllThreshold = 5;
    @Deprecated
    private int rebalancePoolSize = 4;
    @Deprecated
    private long rebalanceTimeout = 10000L;
    @Deprecated
    private EvictionPolicy evictPlc;
    @SerializeSeparately
    private Factory evictPlcFactory;
    private boolean onheapCache;
    private boolean sqlOnheapCache;
    private int sqlOnheapCacheMaxSize = 0;
    @SerializeSeparately
    private EvictionFilter<?, ?> evictFilter;
    private boolean eagerTtl = true;
    @Deprecated
    private long dfltLockTimeout = 0L;
    private NearCacheConfiguration<K, V> nearCfg;
    private PlatformCacheConfiguration platformCfg;
    public static final boolean DFLT_COPY_ON_READ = true;
    private CacheWriteSynchronizationMode writeSync;
    @SerializeSeparately
    private Factory storeFactory;
    private Boolean storeKeepBinary = DFLT_STORE_KEEP_BINARY;
    private boolean loadPrevVal = false;
    private AffinityFunction aff;
    private CacheMode cacheMode = DFLT_CACHE_MODE;
    private CacheAtomicityMode atomicityMode;
    private int backups = 0;
    private boolean invalidate = false;
    private String tmLookupClsName;
    private CacheRebalanceMode rebalanceMode = DFLT_REBALANCE_MODE;
    private int rebalanceOrder;
    @Deprecated
    private int rebalanceBatchSize = 524288;
    @Deprecated
    private long rebalanceBatchesPrefetchCnt = 3L;
    private int maxConcurrentAsyncOps = 500;
    private int sqlIdxMaxInlineSize = -1;
    private boolean writeBehindEnabled = false;
    private int writeBehindFlushSize = 10240;
    private long writeBehindFlushFreq = 5000L;
    private int writeBehindFlushThreadCnt = 1;
    private int writeBehindBatchSize = 512;
    private boolean writeBehindCoalescing = true;
    private int maxQryIterCnt = 1024;
    private AffinityKeyMapper affMapper;
    private long rebalanceDelay;
    @Deprecated
    private long rebalanceThrottle = 0L;
    @SerializeSeparately
    private CacheInterceptor<K, V> interceptor;
    private Class<?>[] sqlFuncCls;
    @Deprecated
    private long longQryWarnTimeout = 3000L;
    private int qryDetailMetricsSz = 0;
    private boolean readFromBackup = true;
    private IgnitePredicate<ClusterNode> nodeFilter;
    private String sqlSchema;
    private boolean sqlEscapeAll;
    private transient Class<?>[] indexedTypes;
    private boolean cpOnRead = true;
    private CachePluginConfiguration[] pluginCfgs;
    private TopologyValidator topValidator;
    @SerializeSeparately
    private Factory<? extends CacheStoreSessionListener>[] storeSesLsnrs;
    private Collection<QueryEntity> qryEntities;
    private PartitionLossPolicy partLossPlc = DFLT_PARTITION_LOSS_POLICY;
    private int qryParallelism = 1;
    private CacheKeyConfiguration[] keyCfg;
    private boolean evtsDisabled = false;
    private boolean encryptionEnabled;
    private DiskPageCompression diskPageCompression = IgniteSystemProperties.getEnum(DiskPageCompression.class, "IGNITE_DEFAULT_DISK_PAGE_COMPRESSION");
    private Integer diskPageCompressionLevel;

    public CacheConfiguration() {
    }

    public CacheConfiguration(String name) {
        this.name = name;
    }

    public CacheConfiguration(CompleteConfiguration<K, V> cfg) {
        super(cfg);
        if (!(cfg instanceof CacheConfiguration)) {
            return;
        }
        CacheConfiguration cc = (CacheConfiguration)cfg;
        this.aff = cc.getAffinity();
        this.affMapper = cc.getAffinityMapper();
        this.atomicityMode = cc.getAtomicityMode();
        this.backups = cc.getBackups();
        this.cacheLoaderFactory = cc.getCacheLoaderFactory();
        this.cacheMode = cc.getCacheMode();
        this.cacheWriterFactory = cc.getCacheWriterFactory();
        this.cpOnRead = cc.isCopyOnRead();
        this.dfltLockTimeout = cc.getDefaultLockTimeout();
        this.eagerTtl = cc.isEagerTtl();
        this.encryptionEnabled = cc.isEncryptionEnabled();
        this.evictFilter = cc.getEvictionFilter();
        this.evictPlc = cc.getEvictionPolicy();
        this.evictPlcFactory = cc.getEvictionPolicyFactory();
        this.expiryPolicyFactory = cc.getExpiryPolicyFactory();
        this.grpName = cc.getGroupName();
        this.indexedTypes = cc.getIndexedTypes();
        this.interceptor = cc.getInterceptor();
        this.invalidate = cc.isInvalidate();
        this.isReadThrough = cc.isReadThrough();
        this.isWriteThrough = cc.isWriteThrough();
        this.keyCfg = cc.getKeyConfiguration();
        this.listenerConfigurations = cc.listenerConfigurations;
        this.loadPrevVal = cc.isLoadPreviousValue();
        this.longQryWarnTimeout = cc.getLongQueryWarningTimeout();
        this.maxConcurrentAsyncOps = cc.getMaxConcurrentAsyncOperations();
        this.memPlcName = cc.getDataRegionName();
        this.name = cc.getName();
        this.nearCfg = cc.getNearConfiguration();
        this.platformCfg = cc.getPlatformCacheConfiguration();
        this.nodeFilter = cc.getNodeFilter();
        this.onheapCache = cc.isOnheapCacheEnabled();
        this.diskPageCompression = cc.getDiskPageCompression();
        this.diskPageCompressionLevel = cc.getDiskPageCompressionLevel();
        this.partLossPlc = cc.getPartitionLossPolicy();
        this.pluginCfgs = cc.getPluginConfigurations();
        this.qryDetailMetricsSz = cc.getQueryDetailMetricsSize();
        this.qryEntities = cc.getQueryEntities() == Collections.emptyList() ? null : cc.getQueryEntities();
        this.qryParallelism = cc.getQueryParallelism();
        this.readFromBackup = cc.isReadFromBackup();
        this.rebalanceBatchSize = cc.getRebalanceBatchSize();
        this.rebalanceBatchesPrefetchCnt = cc.getRebalanceBatchesPrefetchCount();
        this.rebalanceDelay = cc.getRebalanceDelay();
        this.rebalanceMode = cc.getRebalanceMode();
        this.rebalanceOrder = cc.getRebalanceOrder();
        this.rebalancePoolSize = cc.getRebalanceThreadPoolSize();
        this.rebalanceTimeout = cc.getRebalanceTimeout();
        this.rebalanceThrottle = cc.getRebalanceThrottle();
        this.sqlSchema = cc.getSqlSchema();
        this.sqlEscapeAll = cc.isSqlEscapeAll();
        this.sqlFuncCls = cc.getSqlFunctionClasses();
        this.sqlIdxMaxInlineSize = cc.getSqlIndexMaxInlineSize();
        this.storeFactory = cc.getCacheStoreFactory();
        this.storeKeepBinary = cc.isStoreKeepBinary() != null ? cc.isStoreKeepBinary() : DFLT_STORE_KEEP_BINARY;
        this.storeSesLsnrs = cc.getCacheStoreSessionListenerFactories();
        this.tmLookupClsName = cc.getTransactionManagerLookupClassName();
        this.topValidator = cc.getTopologyValidator();
        this.writeBehindBatchSize = cc.getWriteBehindBatchSize();
        this.writeBehindCoalescing = cc.getWriteBehindCoalescing();
        this.writeBehindEnabled = cc.isWriteBehindEnabled();
        this.writeBehindFlushFreq = cc.getWriteBehindFlushFrequency();
        this.writeBehindFlushSize = cc.getWriteBehindFlushSize();
        this.writeBehindFlushThreadCnt = cc.getWriteBehindFlushThreadCount();
        this.writeSync = cc.getWriteSynchronizationMode();
        this.storeConcurrentLoadAllThreshold = cc.getStoreConcurrentLoadAllThreshold();
        this.maxQryIterCnt = cc.getMaxQueryIteratorsCount();
        this.sqlOnheapCache = cc.isSqlOnheapCacheEnabled();
        this.sqlOnheapCacheMaxSize = cc.getSqlOnheapCacheMaxSize();
        this.evtsDisabled = cc.isEventsDisabled();
    }

    public String getGroupName() {
        return this.grpName;
    }

    public CacheConfiguration<K, V> setGroupName(String grpName) {
        this.grpName = grpName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CacheConfiguration<K, V> setName(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getDataRegionName() {
        return this.memPlcName;
    }

    @Deprecated
    public String getMemoryPolicyName() {
        return this.memPlcName;
    }

    public CacheConfiguration<K, V> setDataRegionName(@Nullable String dataRegionName) {
        A.ensure(dataRegionName == null || !dataRegionName.isEmpty(), "Name cannot be empty.");
        this.memPlcName = dataRegionName;
        return this;
    }

    @Deprecated
    public CacheConfiguration<K, V> setMemoryPolicyName(String memPlcName) {
        return this.setDataRegionName(memPlcName);
    }

    @Deprecated
    @Nullable
    public EvictionPolicy<K, V> getEvictionPolicy() {
        return this.evictPlc;
    }

    @Deprecated
    public CacheConfiguration<K, V> setEvictionPolicy(@Nullable EvictionPolicy evictPlc) {
        this.evictPlc = evictPlc;
        return this;
    }

    @Nullable
    public Factory<EvictionPolicy<? super K, ? super V>> getEvictionPolicyFactory() {
        return this.evictPlcFactory;
    }

    public CacheConfiguration<K, V> setEvictionPolicyFactory(@Nullable Factory<? extends EvictionPolicy<? super K, ? super V>> evictPlcFactory) {
        this.evictPlcFactory = evictPlcFactory;
        return this;
    }

    public boolean isOnheapCacheEnabled() {
        return this.onheapCache;
    }

    public CacheConfiguration<K, V> setOnheapCacheEnabled(boolean onheapCache) {
        this.onheapCache = onheapCache;
        return this;
    }

    public boolean isSqlOnheapCacheEnabled() {
        return this.sqlOnheapCache;
    }

    public CacheConfiguration<K, V> setSqlOnheapCacheEnabled(boolean sqlOnheapCache) {
        this.sqlOnheapCache = sqlOnheapCache;
        return this;
    }

    public int getSqlOnheapCacheMaxSize() {
        return this.sqlOnheapCacheMaxSize;
    }

    public CacheConfiguration<K, V> setSqlOnheapCacheMaxSize(int sqlOnheapCacheMaxSize) {
        this.sqlOnheapCacheMaxSize = sqlOnheapCacheMaxSize;
        return this;
    }

    public NearCacheConfiguration<K, V> getNearConfiguration() {
        return this.nearCfg;
    }

    public CacheConfiguration<K, V> setNearConfiguration(NearCacheConfiguration<K, V> nearCfg) {
        this.nearCfg = nearCfg;
        return this;
    }

    @IgniteExperimental
    public PlatformCacheConfiguration getPlatformCacheConfiguration() {
        return this.platformCfg;
    }

    @IgniteExperimental
    public CacheConfiguration<K, V> setPlatformCacheConfiguration(PlatformCacheConfiguration platformCfg) {
        this.platformCfg = platformCfg;
        return this;
    }

    public CacheWriteSynchronizationMode getWriteSynchronizationMode() {
        return this.writeSync;
    }

    public CacheConfiguration<K, V> setWriteSynchronizationMode(CacheWriteSynchronizationMode writeSync) {
        this.writeSync = writeSync;
        return this;
    }

    public IgnitePredicate<ClusterNode> getNodeFilter() {
        return this.nodeFilter;
    }

    public CacheConfiguration<K, V> setNodeFilter(IgnitePredicate<ClusterNode> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return this;
    }

    public EvictionFilter<K, V> getEvictionFilter() {
        return this.evictFilter;
    }

    public CacheConfiguration<K, V> setEvictionFilter(EvictionFilter<K, V> evictFilter) {
        this.evictFilter = evictFilter;
        return this;
    }

    public boolean isEagerTtl() {
        return this.eagerTtl;
    }

    public CacheConfiguration<K, V> setEagerTtl(boolean eagerTtl) {
        this.eagerTtl = eagerTtl;
        return this;
    }

    public boolean isLoadPreviousValue() {
        return this.loadPrevVal;
    }

    public CacheConfiguration<K, V> setLoadPreviousValue(boolean loadPrevVal) {
        this.loadPrevVal = loadPrevVal;
        return this;
    }

    public Factory<CacheStore<? super K, ? super V>> getCacheStoreFactory() {
        return this.storeFactory;
    }

    public CacheConfiguration<K, V> setCacheStoreFactory(Factory<? extends CacheStore<? super K, ? super V>> storeFactory) {
        this.storeFactory = storeFactory;
        return this;
    }

    public Boolean isStoreKeepBinary() {
        return this.storeKeepBinary;
    }

    public CacheConfiguration<K, V> setStoreKeepBinary(boolean storeKeepBinary) {
        this.storeKeepBinary = storeKeepBinary;
        return this;
    }

    public int getStoreConcurrentLoadAllThreshold() {
        return this.storeConcurrentLoadAllThreshold;
    }

    public CacheConfiguration<K, V> setStoreConcurrentLoadAllThreshold(int storeConcurrentLoadAllThreshold) {
        this.storeConcurrentLoadAllThreshold = storeConcurrentLoadAllThreshold;
        return this;
    }

    public AffinityFunction getAffinity() {
        return this.aff;
    }

    public CacheConfiguration<K, V> setAffinity(AffinityFunction aff) {
        this.aff = aff;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public CacheConfiguration<K, V> setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public CacheAtomicityMode getAtomicityMode() {
        return this.atomicityMode;
    }

    public CacheConfiguration<K, V> setAtomicityMode(CacheAtomicityMode atomicityMode) {
        this.atomicityMode = atomicityMode;
        return this;
    }

    public int getBackups() {
        return this.backups;
    }

    public CacheConfiguration<K, V> setBackups(int backups) {
        this.backups = backups;
        return this;
    }

    @Deprecated
    public long getDefaultLockTimeout() {
        return this.dfltLockTimeout;
    }

    @Deprecated
    public CacheConfiguration<K, V> setDefaultLockTimeout(long dfltLockTimeout) {
        this.dfltLockTimeout = dfltLockTimeout;
        return this;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public CacheConfiguration<K, V> setInvalidate(boolean invalidate) {
        this.invalidate = invalidate;
        return this;
    }

    @Deprecated
    public String getTransactionManagerLookupClassName() {
        return this.tmLookupClsName;
    }

    @Deprecated
    public CacheConfiguration<K, V> setTransactionManagerLookupClassName(String tmLookupClsName) {
        this.tmLookupClsName = tmLookupClsName;
        return this;
    }

    public CacheConfiguration<K, V> setRebalanceMode(CacheRebalanceMode rebalanceMode) {
        this.rebalanceMode = rebalanceMode;
        return this;
    }

    public CacheRebalanceMode getRebalanceMode() {
        return this.rebalanceMode;
    }

    public int getRebalanceOrder() {
        return this.rebalanceOrder;
    }

    public CacheConfiguration<K, V> setRebalanceOrder(int rebalanceOrder) {
        this.rebalanceOrder = rebalanceOrder;
        return this;
    }

    @Deprecated
    public int getRebalanceBatchSize() {
        return this.rebalanceBatchSize;
    }

    @Deprecated
    public CacheConfiguration<K, V> setRebalanceBatchSize(int rebalanceBatchSize) {
        this.rebalanceBatchSize = rebalanceBatchSize;
        return this;
    }

    @Deprecated
    public long getRebalanceBatchesPrefetchCount() {
        return this.rebalanceBatchesPrefetchCnt;
    }

    @Deprecated
    public CacheConfiguration<K, V> setRebalanceBatchesPrefetchCount(long rebalanceBatchesCnt) {
        this.rebalanceBatchesPrefetchCnt = rebalanceBatchesCnt;
        return this;
    }

    public int getMaxConcurrentAsyncOperations() {
        return this.maxConcurrentAsyncOps;
    }

    public CacheConfiguration<K, V> setMaxConcurrentAsyncOperations(int maxConcurrentAsyncOps) {
        this.maxConcurrentAsyncOps = maxConcurrentAsyncOps;
        return this;
    }

    public int getSqlIndexMaxInlineSize() {
        return this.sqlIdxMaxInlineSize;
    }

    public CacheConfiguration<K, V> setSqlIndexMaxInlineSize(int sqlIdxMaxInlineSize) {
        this.sqlIdxMaxInlineSize = sqlIdxMaxInlineSize;
        return this;
    }

    public boolean isWriteBehindEnabled() {
        return this.writeBehindEnabled;
    }

    public CacheConfiguration<K, V> setWriteBehindEnabled(boolean writeBehindEnabled) {
        this.writeBehindEnabled = writeBehindEnabled;
        return this;
    }

    public int getWriteBehindFlushSize() {
        return this.writeBehindFlushSize;
    }

    public CacheConfiguration<K, V> setWriteBehindFlushSize(int writeBehindFlushSize) {
        this.writeBehindFlushSize = writeBehindFlushSize;
        return this;
    }

    public long getWriteBehindFlushFrequency() {
        return this.writeBehindFlushFreq;
    }

    public CacheConfiguration<K, V> setWriteBehindFlushFrequency(long writeBehindFlushFreq) {
        this.writeBehindFlushFreq = writeBehindFlushFreq;
        return this;
    }

    public int getWriteBehindFlushThreadCount() {
        return this.writeBehindFlushThreadCnt;
    }

    public CacheConfiguration<K, V> setWriteBehindFlushThreadCount(int writeBehindFlushThreadCnt) {
        this.writeBehindFlushThreadCnt = writeBehindFlushThreadCnt;
        return this;
    }

    public int getWriteBehindBatchSize() {
        return this.writeBehindBatchSize;
    }

    public CacheConfiguration<K, V> setWriteBehindBatchSize(int writeBehindBatchSize) {
        this.writeBehindBatchSize = writeBehindBatchSize;
        return this;
    }

    public boolean getWriteBehindCoalescing() {
        return this.writeBehindCoalescing;
    }

    public CacheConfiguration<K, V> setWriteBehindCoalescing(boolean writeBehindCoalescing) {
        this.writeBehindCoalescing = writeBehindCoalescing;
        return this;
    }

    @Deprecated
    public int getRebalanceThreadPoolSize() {
        return this.rebalancePoolSize;
    }

    @Deprecated
    public CacheConfiguration<K, V> setRebalanceThreadPoolSize(int rebalancePoolSize) {
        this.rebalancePoolSize = rebalancePoolSize;
        return this;
    }

    @Deprecated
    public long getRebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    @Deprecated
    public CacheConfiguration<K, V> setRebalanceTimeout(long rebalanceTimeout) {
        this.rebalanceTimeout = rebalanceTimeout;
        return this;
    }

    public long getRebalanceDelay() {
        return this.rebalanceDelay;
    }

    public CacheConfiguration<K, V> setRebalanceDelay(long rebalanceDelay) {
        this.rebalanceDelay = rebalanceDelay;
        return this;
    }

    @Deprecated
    public long getRebalanceThrottle() {
        return this.rebalanceThrottle;
    }

    @Deprecated
    public CacheConfiguration<K, V> setRebalanceThrottle(long rebalanceThrottle) {
        this.rebalanceThrottle = rebalanceThrottle;
        return this;
    }

    public AffinityKeyMapper getAffinityMapper() {
        return this.affMapper;
    }

    public CacheConfiguration<K, V> setAffinityMapper(AffinityKeyMapper affMapper) {
        this.affMapper = affMapper;
        return this;
    }

    public int getMaxQueryIteratorsCount() {
        return this.maxQryIterCnt;
    }

    public CacheConfiguration<K, V> setMaxQueryIteratorsCount(int maxQryIterCnt) {
        this.maxQryIterCnt = maxQryIterCnt;
        return this;
    }

    @Nullable
    public CacheInterceptor<K, V> getInterceptor() {
        return this.interceptor;
    }

    public CacheConfiguration<K, V> setInterceptor(CacheInterceptor<K, V> interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public boolean isReadFromBackup() {
        return this.readFromBackup;
    }

    public CacheConfiguration<K, V> setReadFromBackup(boolean readFromBackup) {
        this.readFromBackup = readFromBackup;
        return this;
    }

    public boolean isCopyOnRead() {
        return this.cpOnRead;
    }

    public CacheConfiguration<K, V> setCopyOnRead(boolean cpOnRead) {
        this.cpOnRead = cpOnRead;
        return this;
    }

    public CacheConfiguration<K, V> setSqlFunctionClasses(Class<?> ... cls) {
        this.sqlFuncCls = cls;
        return this;
    }

    @Nullable
    public Class<?>[] getSqlFunctionClasses() {
        return this.sqlFuncCls;
    }

    @Deprecated
    public long getLongQueryWarningTimeout() {
        return this.longQryWarnTimeout;
    }

    @Deprecated
    public CacheConfiguration<K, V> setLongQueryWarningTimeout(long longQryWarnTimeout) {
        this.longQryWarnTimeout = longQryWarnTimeout;
        return this;
    }

    public int getQueryDetailMetricsSize() {
        return this.qryDetailMetricsSz;
    }

    public CacheConfiguration<K, V> setQueryDetailMetricsSize(int qryDetailMetricsSz) {
        this.qryDetailMetricsSz = qryDetailMetricsSz;
        return this;
    }

    @Nullable
    public String getSqlSchema() {
        return this.sqlSchema;
    }

    public CacheConfiguration<K, V> setSqlSchema(String sqlSchema) {
        if (sqlSchema != null) {
            A.ensure(!sqlSchema.isEmpty(), "Schema could not be empty.");
        }
        this.sqlSchema = sqlSchema;
        return this;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public CacheConfiguration<K, V> setSqlEscapeAll(boolean sqlEscapeAll) {
        this.sqlEscapeAll = sqlEscapeAll;
        return this;
    }

    public Class<?>[] getIndexedTypes() {
        return this.indexedTypes;
    }

    public CacheConfiguration<K, V> setIndexedTypes(Class<?> ... indexedTypes) {
        int i;
        if (F.isEmpty(indexedTypes)) {
            return this;
        }
        int len = indexedTypes.length;
        if (len == 0) {
            return this;
        }
        A.ensure((len & 1) == 0, "Number of indexed types is expected to be even. Refer to method javadoc for details.");
        if (this.indexedTypes != null) {
            throw new CacheException("Indexed types can be set only once.");
        }
        Class[] newIndexedTypes = new Class[len];
        for (i = 0; i < len; ++i) {
            if (indexedTypes[i] == null) {
                throw new NullPointerException("Indexed types array contains null at index: " + i);
            }
            newIndexedTypes[i] = U.box(indexedTypes[i]);
        }
        if (this.qryEntities == null) {
            this.qryEntities = new ArrayList<QueryEntity>();
        }
        for (i = 0; i < len; i += 2) {
            String affFieldName;
            Class keyCls = newIndexedTypes[i];
            Class valCls = newIndexedTypes[i + 1];
            QueryEntity newEntity = new QueryEntity(keyCls, valCls);
            boolean dup = false;
            for (QueryEntity entity : this.qryEntities) {
                if (!F.eq(entity.findValueType(), newEntity.findValueType())) continue;
                dup = true;
                break;
            }
            if (!dup) {
                this.qryEntities.add(newEntity);
            }
            if ((affFieldName = BinaryContext.affinityFieldName(keyCls)) == null) continue;
            CacheKeyConfiguration newKeyCfg = new CacheKeyConfiguration(newEntity.getKeyType(), affFieldName);
            if (F.isEmpty(this.keyCfg)) {
                this.keyCfg = new CacheKeyConfiguration[]{newKeyCfg};
                continue;
            }
            boolean keyCfgDup = false;
            for (CacheKeyConfiguration oldKeyCfg : this.keyCfg) {
                if (!F.eq(oldKeyCfg.getTypeName(), newKeyCfg.getTypeName())) continue;
                keyCfgDup = true;
                break;
            }
            if (keyCfgDup) continue;
            CacheKeyConfiguration[] keyCfg0 = new CacheKeyConfiguration[this.keyCfg.length + 1];
            System.arraycopy(this.keyCfg, 0, keyCfg0, 0, this.keyCfg.length);
            keyCfg0[keyCfg0.length - 1] = newKeyCfg;
            this.keyCfg = keyCfg0;
        }
        return this;
    }

    public CachePluginConfiguration[] getPluginConfigurations() {
        return this.pluginCfgs != null ? this.pluginCfgs : new CachePluginConfiguration[]{};
    }

    public CacheConfiguration<K, V> setPluginConfigurations(CachePluginConfiguration ... pluginCfgs) {
        this.pluginCfgs = pluginCfgs;
        return this;
    }

    public Collection<QueryEntity> getQueryEntities() {
        return this.qryEntities != null ? this.qryEntities : Collections.emptyList();
    }

    public PartitionLossPolicy getPartitionLossPolicy() {
        return this.partLossPlc == null ? DFLT_PARTITION_LOSS_POLICY : this.partLossPlc;
    }

    public CacheConfiguration<K, V> setPartitionLossPolicy(PartitionLossPolicy partLossPlc) {
        this.partLossPlc = partLossPlc;
        return this;
    }

    public CacheConfiguration<K, V> setQueryEntities(Collection<QueryEntity> qryEntities) {
        if (this.qryEntities == null) {
            this.qryEntities = new ArrayList<QueryEntity>(qryEntities);
            return this;
        }
        for (QueryEntity entity : qryEntities) {
            boolean found = false;
            for (QueryEntity existing : this.qryEntities) {
                if (!F.eq(entity.findValueType(), existing.findValueType())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.qryEntities.add(entity);
        }
        return this;
    }

    public CacheConfiguration<K, V> clearQueryEntities() {
        this.qryEntities = null;
        return this;
    }

    public int getQueryParallelism() {
        return this.qryParallelism;
    }

    public CacheConfiguration<K, V> setQueryParallelism(int qryParallelism) {
        A.ensure(qryParallelism > 0, "Query parallelism must be positive.");
        this.qryParallelism = qryParallelism;
        return this;
    }

    public TopologyValidator getTopologyValidator() {
        return this.topValidator;
    }

    public CacheConfiguration<K, V> setTopologyValidator(TopologyValidator topValidator) {
        this.topValidator = topValidator;
        return this;
    }

    public Factory<? extends CacheStoreSessionListener>[] getCacheStoreSessionListenerFactories() {
        return this.storeSesLsnrs;
    }

    public CacheConfiguration<K, V> setCacheStoreSessionListenerFactories(Factory<? extends CacheStoreSessionListener> ... storeSesLsnrs) {
        this.storeSesLsnrs = storeSesLsnrs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        CacheConfiguration cacheConfiguration = this;
        synchronized (cacheConfiguration) {
            return new HashSet<CacheEntryListenerConfiguration<K, V>>(this.listenerConfigurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConfiguration<K, V> addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryLsnrCfg) {
        CacheConfiguration cacheConfiguration = this;
        synchronized (cacheConfiguration) {
            return super.addCacheEntryListenerConfiguration(cacheEntryLsnrCfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConfiguration<K, V> removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryLsnrCfg) {
        CacheConfiguration cacheConfiguration = this;
        synchronized (cacheConfiguration) {
            return super.removeCacheEntryListenerConfiguration(cacheEntryLsnrCfg);
        }
    }

    protected Object writeReplace() {
        CacheConfiguration<K, V> cfg = new CacheConfiguration<K, V>(this);
        cfg.listenerConfigurations = new HashSet();
        return cfg;
    }

    private static Class<?> mask(Class<?> cls) {
        assert (cls != null);
        return QueryUtils.isSqlType(cls) ? cls : Object.class;
    }

    public CacheConfiguration<K, V> setStatisticsEnabled(boolean enabled) {
        super.setStatisticsEnabled(enabled);
        return this;
    }

    public CacheConfiguration<K, V> setManagementEnabled(boolean enabled) {
        super.setManagementEnabled(enabled);
        return this;
    }

    public CacheConfiguration<K, V> setCacheLoaderFactory(Factory<? extends CacheLoader<K, V>> factory) {
        super.setCacheLoaderFactory(factory);
        return this;
    }

    public CacheConfiguration<K, V> setCacheWriterFactory(Factory<? extends CacheWriter<? super K, ? super V>> factory) {
        super.setCacheWriterFactory(factory);
        return this;
    }

    public CacheConfiguration<K, V> setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
        super.setExpiryPolicyFactory(factory);
        return this;
    }

    public CacheConfiguration<K, V> setTypes(Class<K> keyType, Class<V> valType) {
        super.setTypes(keyType, valType);
        return this;
    }

    public CacheConfiguration<K, V> setReadThrough(boolean isReadThrough) {
        super.setReadThrough(isReadThrough);
        return this;
    }

    public CacheConfiguration<K, V> setWriteThrough(boolean isWriteThrough) {
        super.setWriteThrough(isWriteThrough);
        return this;
    }

    public CacheConfiguration<K, V> setStoreByValue(boolean isStoreByVal) {
        super.setStoreByValue(isStoreByVal);
        return this;
    }

    public Boolean isEventsDisabled() {
        return this.evtsDisabled;
    }

    public CacheConfiguration<K, V> setEventsDisabled(boolean evtsDisabled) {
        this.evtsDisabled = evtsDisabled;
        return this;
    }

    public CacheKeyConfiguration[] getKeyConfiguration() {
        return this.keyCfg;
    }

    public CacheConfiguration<K, V> setKeyConfiguration(CacheKeyConfiguration ... cacheKeyCfg) {
        this.keyCfg = cacheKeyCfg;
        return this;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public CacheConfiguration<K, V> setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
        return this;
    }

    public DiskPageCompression getDiskPageCompression() {
        return this.diskPageCompression == null ? DFLT_DISK_PAGE_COMPRESSION : this.diskPageCompression;
    }

    public CacheConfiguration<K, V> setDiskPageCompression(DiskPageCompression diskPageCompression) {
        this.diskPageCompression = diskPageCompression;
        return this;
    }

    public Integer getDiskPageCompressionLevel() {
        return this.diskPageCompressionLevel;
    }

    public CacheConfiguration<K, V> setDiskPageCompressionLevel(Integer diskPageCompressionLevel) {
        this.diskPageCompressionLevel = diskPageCompressionLevel;
        return this;
    }

    public String toString() {
        return S.toString(CacheConfiguration.class, this);
    }

    public static class IgniteAllNodesPredicate
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;

        @Override
        public boolean apply(ClusterNode node) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(this.getClass());
        }

        public String toString() {
            return "IgniteAllNodesPredicate []";
        }
    }
}

