/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.jmx;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.metric.jmx.ReadOnlyDynamicMBean;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class SystemViewMBean<R>
extends ReadOnlyDynamicMBean {
    public static final String VIEWS = "views";
    public static final String FILTER_OPERATION = "filter";
    public static final String ID = "systemViewRowId";
    private final SystemView<R> sysView;
    private final MBeanInfo info;
    private final CompositeType rowType;
    private final TabularType sysViewType;
    private final String[] filterFields;

    public SystemViewMBean(final SystemView<R> sysView) {
        this.sysView = sysView;
        int cnt = sysView.walker().count();
        final String[] fields = new String[cnt + 1];
        final OpenType[] types = new OpenType[cnt + 1];
        final ArrayList filterFieldIdxs = new ArrayList(cnt);
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            @Override
            public <T> void accept(int idx, String name, Class<T> clazz) {
                fields[idx] = name;
                types[idx] = clazz.isAssignableFrom(String.class) || clazz.isEnum() || clazz.isAssignableFrom(IgniteUuid.class) || clazz.isAssignableFrom(UUID.class) || clazz.isAssignableFrom(Class.class) || clazz.isAssignableFrom(InetSocketAddress.class) ? SimpleType.STRING : (clazz.isAssignableFrom(BigDecimal.class) ? SimpleType.BIGDECIMAL : (clazz.isAssignableFrom(BigInteger.class) ? SimpleType.BIGINTEGER : (clazz.isAssignableFrom(Date.class) ? SimpleType.DATE : (clazz.isAssignableFrom(ObjectName.class) ? SimpleType.OBJECTNAME : (clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class) ? SimpleType.BOOLEAN : (clazz == Byte.TYPE || clazz.isAssignableFrom(Byte.class) ? SimpleType.BYTE : (clazz == Character.TYPE || clazz.isAssignableFrom(Character.class) ? SimpleType.CHARACTER : (clazz == Short.TYPE || clazz.isAssignableFrom(Short.class) ? SimpleType.SHORT : (clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class) ? SimpleType.INTEGER : (clazz == Long.TYPE || clazz.isAssignableFrom(Long.class) ? SimpleType.LONG : (clazz == Float.TYPE || clazz.isAssignableFrom(Float.class) ? SimpleType.FLOAT : (clazz == Double.TYPE || clazz.isAssignableFrom(Double.class) ? SimpleType.DOUBLE : SimpleType.STRING))))))))))));
                if (sysView.walker().filtrableAttributes().contains(name)) {
                    filterFieldIdxs.add(idx);
                }
            }
        });
        fields[cnt] = ID;
        types[cnt] = SimpleType.INTEGER;
        try {
            this.rowType = new CompositeType(sysView.name(), sysView.description(), fields, fields, types);
            OpenMBeanOperationInfo[] operations = null;
            if (!filterFieldIdxs.isEmpty() && sysView instanceof FiltrableSystemView) {
                OpenMBeanParameterInfo[] params = new OpenMBeanParameterInfo[filterFieldIdxs.size()];
                this.filterFields = new String[filterFieldIdxs.size()];
                for (int i = 0; i < filterFieldIdxs.size(); ++i) {
                    String fieldName;
                    this.filterFields[i] = fieldName = fields[(Integer)filterFieldIdxs.get(i)];
                    params[i] = new OpenMBeanParameterInfoSupport(fieldName, fieldName, types[(Integer)filterFieldIdxs.get(i)]);
                }
                OpenMBeanOperationInfoSupport operation = new OpenMBeanOperationInfoSupport(FILTER_OPERATION, "Filter view content", params, this.rowType, 0);
                operations = new OpenMBeanOperationInfo[]{operation};
            } else {
                this.filterFields = null;
            }
            this.info = new OpenMBeanInfoSupport(sysView.name(), sysView.description(), new OpenMBeanAttributeInfo[]{new OpenMBeanAttributeInfoSupport(VIEWS, VIEWS, this.rowType, true, false, false)}, null, operations, null);
            this.sysViewType = new TabularType(sysView.name(), sysView.description(), this.rowType, new String[]{ID});
        }
        catch (OpenDataException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) {
        if ("MBeanInfo".equals(attribute)) {
            return this.getMBeanInfo();
        }
        if (attribute.equals(VIEWS)) {
            return this.viewContent(null);
        }
        throw new IllegalArgumentException("Unknown attribute " + attribute);
    }

    @Override
    public Object invoke(String actName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (FILTER_OPERATION.equals(actName)) {
            assert (this.filterFields != null);
            assert (this.filterFields.length >= params.length);
            HashMap<String, Object> filter = U.newHashMap(params.length);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                filter.put(this.filterFields[i], params[i]);
            }
            return this.viewContent(filter);
        }
        return super.invoke(actName, params, signature);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    private TabularDataSupport viewContent(Map<String, Object> filter) {
        TabularDataSupport rows = new TabularDataSupport(this.sysViewType);
        AttributeToMapVisitor visitor = new AttributeToMapVisitor();
        try {
            int idx = 0;
            SystemView<R> iter = filter != null && this.sysView instanceof FiltrableSystemView ? () -> ((FiltrableSystemView)this.sysView).iterator(filter) : this.sysView;
            for (Object row : iter) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                visitor.data(data);
                this.sysView.walker().visitAll(row, visitor);
                data.put(ID, idx++);
                rows.put(new CompositeDataSupport(this.rowType, data));
            }
        }
        catch (OpenDataException e) {
            throw new IgniteException(e);
        }
        return rows;
    }

    private static class AttributeToMapVisitor
    implements SystemViewRowAttributeWalker.AttributeWithValueVisitor {
        private Map<String, Object> data;

        private AttributeToMapVisitor() {
        }

        public void data(Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public <T> void accept(int idx, String name, Class<T> clazz, T val) {
            if (clazz.isEnum()) {
                this.data.put(name, ((Enum)val).name());
            } else if (clazz.isAssignableFrom(Class.class)) {
                this.data.put(name, ((Class)val).getName());
            } else if (clazz.isAssignableFrom(IgniteUuid.class) || clazz.isAssignableFrom(UUID.class) || clazz.isAssignableFrom(InetSocketAddress.class)) {
                this.data.put(name, String.valueOf(val));
            } else {
                this.data.put(name, val);
            }
        }

        @Override
        public void acceptBoolean(int idx, String name, boolean val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptChar(int idx, String name, char val) {
            this.data.put(name, Character.valueOf(val));
        }

        @Override
        public void acceptByte(int idx, String name, byte val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptShort(int idx, String name, short val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptInt(int idx, String name, int val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptLong(int idx, String name, long val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptFloat(int idx, String name, float val) {
            this.data.put(name, Float.valueOf(val));
        }

        @Override
        public void acceptDouble(int idx, String name, double val) {
            this.data.put(name, val);
        }
    }
}

