/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.InputStream;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridByteArrayInputStream
extends InputStream {
    private byte[] buf;
    private int pos;
    private int mark;
    private int cnt;

    public GridByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.cnt = buf.length;
    }

    public GridByteArrayInputStream(byte[] buf, int off, int len) {
        this.buf = buf;
        this.pos = off;
        this.cnt = Math.min(off + len, buf.length);
        this.mark = off;
    }

    @Override
    public int read() {
        return this.pos < this.cnt ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.cnt) {
            return -1;
        }
        if (this.pos + len > this.cnt) {
            len = this.cnt - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        U.arrayCopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.cnt) {
            n = this.cnt - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.cnt - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return S.toString(GridByteArrayInputStream.class, this);
    }
}

