/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridInvokeValue
implements Message {
    private static final long serialVersionUID = 1L;
    @GridDirectTransient
    private Object[] invokeArgs;
    private byte[][] invokeArgsBytes;
    @GridDirectTransient
    private EntryProcessor<Object, Object, Object> entryProcessor;
    private byte[] entryProcessorBytes;

    public GridInvokeValue() {
    }

    public GridInvokeValue(EntryProcessor<Object, Object, Object> entryProcessor, Object[] invokeArgs) {
        this.invokeArgs = invokeArgs;
        this.entryProcessor = entryProcessor;
    }

    public Object[] invokeArgs() {
        return this.invokeArgs;
    }

    public EntryProcessor<Object, Object, Object> entryProcessor() {
        return this.entryProcessor;
    }

    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        if (this.entryProcessor != null && this.entryProcessorBytes == null) {
            this.entryProcessorBytes = CU.marshal(ctx, this.entryProcessor);
        }
        if (this.invokeArgsBytes == null) {
            this.invokeArgsBytes = this.marshalInvokeArguments(this.invokeArgs, ctx);
        }
    }

    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.entryProcessorBytes != null && this.entryProcessor == null) {
            this.entryProcessor = (EntryProcessor)U.unmarshal(ctx.marshaller(), this.entryProcessorBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.invokeArgs == null) {
            this.invokeArgs = this.unmarshalInvokeArguments(this.invokeArgsBytes, ctx, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Nullable
    protected final Object[] unmarshalInvokeArguments(@Nullable byte[][] byteCol, GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (byteCol == null) {
            return null;
        }
        Object[] args = new Object[byteCol.length];
        Marshaller marsh = ctx.marshaller();
        for (int i = 0; i < byteCol.length; ++i) {
            args[i] = byteCol[i] == null ? null : U.unmarshal(marsh, byteCol[i], ldr);
        }
        return args;
    }

    @Nullable
    protected final byte[][] marshalInvokeArguments(@Nullable Object[] args, GridCacheContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        if (args == null || args.length == 0) {
            return null;
        }
        byte[][] argsBytes = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            argsBytes[i] = arg == null ? null : CU.marshal(ctx, arg);
        }
        return argsBytes;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("entryProcessorBytes", this.entryProcessorBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeObjectArray("invokeArgsBytes", (T[])this.invokeArgsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.entryProcessorBytes = reader.readByteArray("entryProcessorBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.invokeArgsBytes = reader.readObjectArray("invokeArgsBytes", MessageCollectionItemType.BYTE_ARR, byte[].class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridInvokeValue.class);
    }

    @Override
    public short directType() {
        return 161;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }
}

