/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorRunningQuery
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long id;
    private String qry;
    private GridCacheQueryType qryType;
    private String schemaName;
    private long startTime;
    private long duration;
    private boolean cancellable;
    private boolean loc;

    public VisorRunningQuery() {
    }

    public VisorRunningQuery(long id, String qry, GridCacheQueryType qryType, String schemaName, long startTime, long duration, boolean cancellable, boolean loc) {
        this.id = id;
        this.qry = qry;
        this.qryType = qryType;
        this.schemaName = schemaName;
        this.startTime = startTime;
        this.duration = duration;
        this.cancellable = cancellable;
        this.loc = loc;
    }

    public long getId() {
        return this.id;
    }

    public String getQuery() {
        return this.qry;
    }

    public GridCacheQueryType getQueryType() {
        return this.qryType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isCancelable() {
        return this.cancellable;
    }

    public boolean isLocal() {
        return this.loc;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        U.writeString(out, this.qry);
        U.writeEnum(out, this.qryType);
        U.writeString(out, this.schemaName);
        out.writeLong(this.startTime);
        out.writeLong(this.duration);
        out.writeBoolean(this.cancellable);
        out.writeBoolean(this.loc);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.qry = U.readString(in);
        this.qryType = GridCacheQueryType.fromOrdinal(in.readByte());
        this.schemaName = U.readString(in);
        this.startTime = in.readLong();
        this.duration = in.readLong();
        this.cancellable = in.readBoolean();
        this.loc = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorRunningQuery.class, this);
    }
}

