/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.CommandList;

public class StateCommand
implements Command<Void> {
    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Print current cluster state:", CommandList.STATE, new String[0]);
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            GridClientClusterState state = client.state();
            logger.info("Cluster is " + (state.active() ? "active" : "inactive"));
        }
        catch (Throwable e) {
            if (!CommandHandler.isAuthError(e)) {
                logger.severe("Failed to get cluster state.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public String name() {
        return CommandList.STATE.toCommandName();
    }
}

