/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final SSLParameters parameters;

    SSLSocketFactoryWrapper(SSLSocketFactory delegate, SSLParameters parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sock = (SSLSocket)this.delegate.createSocket();
        if (this.parameters != null) {
            sock.setSSLParameters(this.parameters);
        }
        return sock;
    }

    @Override
    public Socket createSocket(Socket sock, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sslSock = (SSLSocket)this.delegate.createSocket(sock, host, port, autoClose);
        if (this.parameters != null) {
            sslSock.setSSLParameters(this.parameters);
        }
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.delegate.createSocket(host, port);
        if (this.parameters != null) {
            sock.setSSLParameters(this.parameters);
        }
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress locAddr, int locPort) throws IOException {
        SSLSocket sock = (SSLSocket)this.delegate.createSocket(host, port, locAddr, locPort);
        if (this.parameters != null) {
            sock.setSSLParameters(this.parameters);
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.delegate.createSocket(addr, port);
        if (this.parameters != null) {
            sock.setSSLParameters(this.parameters);
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress locAddr, int locPort) throws IOException {
        SSLSocket sock = (SSLSocket)this.delegate.createSocket(addr, port, locAddr, locPort);
        if (this.parameters != null) {
            sock.setSSLParameters(this.parameters);
        }
        return sock;
    }
}

