/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.Nullable;

public class GridCompoundFuture<T, R>
extends GridFutureAdapter<R>
implements IgniteInClosure<IgniteInternalFuture<T>> {
    private static final long serialVersionUID = 0L;
    private static final int INIT_FLAG = 1;
    private static final AtomicIntegerFieldUpdater<GridCompoundFuture> FLAGS_UPD = AtomicIntegerFieldUpdater.newUpdater(GridCompoundFuture.class, "initFlag");
    private static final AtomicIntegerFieldUpdater<GridCompoundFuture> LSNR_CALLS_UPD = AtomicIntegerFieldUpdater.newUpdater(GridCompoundFuture.class, "lsnrCalls");
    private volatile Object futs;
    @GridToStringInclude
    private final IgniteReducer<T, R> rdc;
    private volatile int initFlag;
    private volatile int lsnrCalls;

    public GridCompoundFuture() {
        this(null);
    }

    public GridCompoundFuture(@Nullable IgniteReducer<T, R> rdc) {
        this.rdc = rdc;
    }

    @Override
    public final void apply(IgniteInternalFuture<T> fut) {
        try {
            T t = fut.get();
            try {
                if (this.rdc != null && !this.rdc.collect(t)) {
                    this.onDone(this.rdc.reduce());
                }
            }
            catch (RuntimeException e) {
                this.logError(null, "Failed to execute compound future reducer: " + this, e);
                this.onDone(e);
            }
            catch (AssertionError e) {
                this.logError(null, "Failed to execute compound future reducer: " + this, (Throwable)((Object)e));
                this.onDone((Throwable)((Object)e));
                throw e;
            }
        }
        catch (IgniteFutureCancelledCheckedException | ClusterTopologyCheckedException | IgniteTxOptimisticCheckedException e) {
            if (!this.processFailure(e, fut)) {
                this.onDone(e);
            }
        }
        catch (IgniteCheckedException e) {
            if (!this.processFailure(e, fut)) {
                if (e instanceof NodeStoppingException) {
                    this.logDebug(this.logger(), "Failed to execute compound future reducer, node stopped.");
                } else {
                    this.logError(null, "Failed to execute compound future reducer: " + this, e);
                }
                this.onDone(e);
            }
        }
        catch (RuntimeException e) {
            this.logError(null, "Failed to execute compound future reducer: " + this, e);
            this.onDone(e);
        }
        catch (AssertionError e) {
            this.logError(null, "Failed to execute compound future reducer: " + this, (Throwable)((Object)e));
            this.onDone((Throwable)((Object)e));
            throw e;
        }
        LSNR_CALLS_UPD.incrementAndGet(this);
        this.checkComplete();
    }

    @Override
    public boolean cancel() throws IgniteCheckedException {
        if (this.onCancelled()) {
            for (IgniteInternalFuture<T> fut : this.futures()) {
                fut.cancel();
            }
            return true;
        }
        return false;
    }

    public final synchronized Collection<IgniteInternalFuture<T>> futures() {
        if (this.futs == null) {
            return Collections.emptyList();
        }
        if (this.futs instanceof IgniteInternalFuture) {
            return Collections.singletonList((IgniteInternalFuture)this.futs);
        }
        return new ArrayList<IgniteInternalFuture<T>>((Collection)this.futs);
    }

    protected boolean ignoreFailure(Throwable err) {
        return false;
    }

    protected boolean processFailure(Throwable err, IgniteInternalFuture<T> fut) {
        return this.ignoreFailure(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasPending() {
        GridCompoundFuture gridCompoundFuture = this;
        synchronized (gridCompoundFuture) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                IgniteInternalFuture<T> fut = this.future(i);
                if (fut.isDone()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(IgniteInternalFuture<T> fut) {
        assert (fut != null);
        GridCompoundFuture gridCompoundFuture = this;
        synchronized (gridCompoundFuture) {
            if (this.futs == null) {
                this.futs = fut;
            } else if (this.futs instanceof IgniteInternalFuture) {
                ArrayList<IgniteInternalFuture<T>> futs0 = new ArrayList<IgniteInternalFuture<T>>(4);
                futs0.add((IgniteInternalFuture)this.futs);
                futs0.add(fut);
                this.futs = futs0;
            } else {
                ((Collection)this.futs).add(fut);
            }
        }
        fut.listen(this);
        if (this.isCancelled()) {
            try {
                fut.cancel();
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
        }
    }

    protected final synchronized void clear() {
        this.futs = null;
    }

    public final boolean initialized() {
        return this.initFlag == 1;
    }

    public final void markInitialized() {
        if (FLAGS_UPD.compareAndSet(this, 0, 1)) {
            this.checkComplete();
        }
    }

    private void checkComplete() {
        if (this.initialized() && !this.isDone() && this.lsnrCalls == this.futuresCount()) {
            try {
                this.onDone(this.rdc != null ? (Object)this.rdc.reduce() : null);
            }
            catch (RuntimeException e) {
                this.logError(this.logger(), "Failed to execute compound future reducer: " + this, e);
                this.onDone(e);
            }
            catch (AssertionError e) {
                this.logError(this.logger(), "Failed to execute compound future reducer: " + this, (Throwable)((Object)e));
                this.onDone((Throwable)((Object)e));
                throw e;
            }
        }
    }

    protected void logError(IgniteLogger log, String msg, Throwable e) {
        U.error(log, msg, e);
    }

    protected void logDebug(IgniteLogger log, String msg) {
        if (log != null && log.isDebugEnabled()) {
            log.debug(msg);
        }
    }

    protected final IgniteInternalFuture<T> future(int idx) {
        assert (Thread.holdsLock(this));
        assert (this.futs != null && idx >= 0 && idx < this.futuresCountNoLock());
        if (this.futs instanceof IgniteInternalFuture) {
            assert (idx == 0);
            return (IgniteInternalFuture)this.futs;
        }
        return (IgniteInternalFuture)((List)this.futs).get(idx);
    }

    protected final int futuresCountNoLock() {
        assert (Thread.holdsLock(this));
        if (this.futs == null) {
            return 0;
        }
        if (this.futs instanceof IgniteInternalFuture) {
            return 1;
        }
        return ((Collection)this.futs).size();
    }

    private synchronized int futuresCount() {
        return this.futuresCountNoLock();
    }

    protected final synchronized boolean hasFutures() {
        return this.futs != null;
    }

    @Override
    public String toString() {
        return S.toString(GridCompoundFuture.class, this, "done", (Object)this.isDone(), "cancelled", (Object)this.isCancelled(), "err", this.error(), "futs", F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<T>, String>(){

            @Override
            public String apply(IgniteInternalFuture<T> f) {
                return Boolean.toString(f.isDone());
            }
        }, new IgnitePredicate[0]));
    }
}

