/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.security.SecurityContextHolder;

public class ClientRequestHandler
implements ClientListenerRequestHandler {
    private final ClientConnectionContext ctx;
    private final AuthorizationContext authCtx;

    ClientRequestHandler(ClientConnectionContext ctx, AuthorizationContext authCtx) {
        assert (ctx != null);
        this.ctx = ctx;
        this.authCtx = authCtx;
    }

    @Override
    public ClientListenerResponse handle(ClientListenerRequest req) {
        if (this.authCtx != null) {
            AuthorizationContext.context(this.authCtx);
            SecurityContextHolder.set(this.ctx.securityContext());
        }
        try {
            ClientResponse clientResponse = ((ClientRequest)req).process(this.ctx);
            return clientResponse;
        }
        finally {
            if (this.authCtx != null) {
                AuthorizationContext.clear();
            }
            SecurityContextHolder.clear();
        }
    }

    @Override
    public ClientListenerResponse handleException(Exception e, ClientListenerRequest req) {
        assert (req != null);
        assert (e != null);
        int status = e instanceof IgniteClientException ? ((IgniteClientException)e).statusCode() : 1;
        return new ClientResponse(req.requestId(), status, e.getMessage());
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
    }
}

