/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class CheckpointMetricsTracker {
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> DATA_PAGES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "dataPages");
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> COW_PAGES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "cowPages");
    private volatile int dataPages;
    private volatile int cowPages;
    private long cpStart = System.currentTimeMillis();
    private long cpLockWaitStart;
    private long cpMarkStart;
    private long cpLockRelease;
    private long cpPagesWriteStart;
    private long cpFsyncStart;
    private long cpEnd;
    private long walCpRecordFsyncStart;
    private long walCpRecordFsyncEnd;

    public void onCowPageWritten() {
        COW_PAGES_UPDATER.incrementAndGet(this);
    }

    public void onDataPageWritten() {
        DATA_PAGES_UPDATER.incrementAndGet(this);
    }

    public int cowPagesWritten() {
        return this.cowPages;
    }

    public int dataPagesWritten() {
        return this.dataPages;
    }

    public void onLockWaitStart() {
        this.cpLockWaitStart = System.currentTimeMillis();
    }

    public void onMarkStart() {
        this.cpMarkStart = System.currentTimeMillis();
    }

    public void onLockRelease() {
        this.cpLockRelease = System.currentTimeMillis();
    }

    public void onPagesWriteStart() {
        this.cpPagesWriteStart = System.currentTimeMillis();
    }

    public void onFsyncStart() {
        this.cpFsyncStart = System.currentTimeMillis();
    }

    public void onEnd() {
        this.cpEnd = System.currentTimeMillis();
    }

    public void onWalCpRecordFsyncStart() {
        this.walCpRecordFsyncStart = System.currentTimeMillis();
    }

    public void onWalCpRecordFsyncEnd() {
        this.walCpRecordFsyncEnd = System.currentTimeMillis();
    }

    public long totalDuration() {
        return this.cpEnd - this.cpStart;
    }

    public long lockWaitDuration() {
        return this.cpMarkStart - this.cpLockWaitStart;
    }

    public long markDuration() {
        return this.cpPagesWriteStart - this.cpMarkStart;
    }

    public long lockHoldDuration() {
        return this.cpLockRelease - this.cpMarkStart;
    }

    public long pagesWriteDuration() {
        return this.cpFsyncStart - this.cpPagesWriteStart;
    }

    public long fsyncDuration() {
        return this.cpEnd - this.cpFsyncStart;
    }

    public long walCpRecordFsyncDuration() {
        return this.walCpRecordFsyncEnd - this.walCpRecordFsyncStart;
    }
}

