/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorage;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IndexStorageImpl
implements IndexStorage {
    public static final int MAX_IDX_NAME_LEN = 255;
    public static final int RESERVED_IDX_NAME_LEN = 768;
    private static final int BYTE_LEN = 1;
    private final PageMemory pageMem;
    private final MetaTree metaTree;
    private final ReuseList reuseList;
    private final int grpId;
    private final int allocPartId;
    private final byte allocSpace;

    public IndexStorageImpl(PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, int grpId, int allocPartId, byte allocSpace, ReuseList reuseList, long rootPageId, boolean initNew, FailureProcessor failureProcessor) {
        try {
            this.pageMem = pageMem;
            this.grpId = grpId;
            this.allocPartId = allocPartId;
            this.allocSpace = allocSpace;
            this.reuseList = reuseList;
            this.metaTree = new MetaTree(grpId, allocPartId, allocSpace, pageMem, wal, globalRmvId, rootPageId, reuseList, MetaStoreInnerIO.VERSIONS, MetaStoreLeafIO.VERSIONS, initNew, failureProcessor);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RootPage getOrAllocateForTree(String idxName) throws IgniteCheckedException {
        MetaTree tree = this.metaTree;
        IndexStorageImpl indexStorageImpl = this;
        synchronized (indexStorageImpl) {
            byte[] idxNameBytes = idxName.getBytes(StandardCharsets.UTF_8);
            if (idxNameBytes.length > 255) {
                throw new IllegalArgumentException("Too long encoded indexName [maxAllowed=255, currentLength=" + idxNameBytes.length + ", name=" + idxName + "]");
            }
            IndexItem row = (IndexItem)tree.findOne(new IndexItem(idxNameBytes, 0L));
            if (row == null) {
                long pageId = 0L;
                if (this.reuseList != null) {
                    pageId = this.reuseList.takeRecycledPage();
                }
                pageId = pageId == 0L ? this.pageMem.allocatePage(this.grpId, this.allocPartId, this.allocSpace) : pageId;
                tree.put(new IndexItem(idxNameBytes, pageId));
                return new RootPage(new FullPageId(pageId, this.grpId), true);
            }
            FullPageId pageId = new FullPageId(row.pageId, this.grpId);
            return new RootPage(pageId, false);
        }
    }

    @Override
    public RootPage dropRootPage(String idxName) throws IgniteCheckedException {
        byte[] idxNameBytes = idxName.getBytes(StandardCharsets.UTF_8);
        IndexItem row = (IndexItem)this.metaTree.remove(new IndexItem(idxNameBytes, 0L));
        if (row != null && this.reuseList == null) {
            this.pageMem.freePage(this.grpId, row.pageId);
        }
        return row != null ? new RootPage(new FullPageId(row.pageId, this.grpId), false) : null;
    }

    @Override
    public void destroy() throws IgniteCheckedException {
        this.metaTree.destroy();
    }

    private static void storeRow(long pageAddr, int off, IndexItem row) {
        PageUtils.putUnsignedByte(pageAddr, off, row.idxName.length);
        PageUtils.putBytes(pageAddr, ++off, row.idxName);
        PageUtils.putLong(pageAddr, off += row.idxName.length, row.pageId);
    }

    private static void storeRow(long dstPageAddr, int dstOff, long srcPageAddr, int srcOff) {
        int len = PageUtils.getUnsignedByte(srcPageAddr, srcOff);
        PageUtils.putUnsignedByte(dstPageAddr, dstOff, len);
        PageHandler.copyMemory(srcPageAddr, (long)(++srcOff), dstPageAddr, (long)(++dstOff), (long)len);
        PageUtils.putLong(dstPageAddr, dstOff += len, PageUtils.getLong(srcPageAddr, srcOff += len));
    }

    private static IndexItem readRow(long pageAddr, int off) {
        int len = PageUtils.getUnsignedByte(pageAddr, off) & 0xFF;
        byte[] idxName = PageUtils.getBytes(pageAddr, ++off, len);
        long pageId = PageUtils.getLong(pageAddr, off += len);
        return new IndexItem(idxName, pageId);
    }

    public static final class MetaStoreLeafIO
    extends BPlusLeafIO<IndexItem>
    implements IndexIO {
        public static final IOVersions<MetaStoreLeafIO> VERSIONS = new IOVersions((PageIO[])new MetaStoreLeafIO[]{new MetaStoreLeafIO(1)});

        private MetaStoreLeafIO(int ver) {
            super(8, ver, 777);
        }

        @Override
        public void storeByOffset(long buf, int off, IndexItem row) throws IgniteCheckedException {
            IndexStorageImpl.storeRow(buf, off, row);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<IndexItem> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
            IndexStorageImpl.storeRow(dstPageAddr, this.offset(dstIdx), srcPageAddr, ((IndexIO)((Object)srcIo)).getOffset(srcPageAddr, srcIdx));
        }

        @Override
        public IndexItem getLookupRow(BPlusTree<IndexItem, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
            return IndexStorageImpl.readRow(pageAddr, this.offset(idx));
        }

        @Override
        public int getOffset(long pageAddr, int idx) {
            return this.offset(idx);
        }
    }

    public static final class MetaStoreInnerIO
    extends BPlusInnerIO<IndexItem>
    implements IndexIO {
        public static final IOVersions<MetaStoreInnerIO> VERSIONS = new IOVersions((PageIO[])new MetaStoreInnerIO[]{new MetaStoreInnerIO(1)});

        private MetaStoreInnerIO(int ver) {
            super(7, ver, false, 777);
        }

        @Override
        public void storeByOffset(long pageAddr, int off, IndexItem row) throws IgniteCheckedException {
            IndexStorageImpl.storeRow(pageAddr, off, row);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<IndexItem> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
            IndexStorageImpl.storeRow(dstPageAddr, this.offset(dstIdx), srcPageAddr, ((IndexIO)((Object)srcIo)).getOffset(srcPageAddr, srcIdx));
        }

        @Override
        public IndexItem getLookupRow(BPlusTree<IndexItem, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
            return IndexStorageImpl.readRow(pageAddr, this.offset(idx));
        }

        @Override
        public int getOffset(long pageAddr, int idx) {
            return this.offset(idx);
        }
    }

    private static interface IndexIO {
        public int getOffset(long var1, int var3);
    }

    private static class IndexItem {
        private byte[] idxName;
        private long pageId;

        private IndexItem(byte[] idxName, long pageId) {
            this.idxName = idxName;
            this.pageId = pageId;
        }

        public String toString() {
            return "I [idxName=" + new String(this.idxName) + ", pageId=" + U.hexLong(this.pageId) + ']';
        }
    }

    private static class MetaTree
    extends BPlusTree<IndexItem, IndexItem> {
        private final int allocPartId;
        private final byte allocSpace;

        private MetaTree(int cacheId, int allocPartId, byte allocSpace, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, long metaPageId, ReuseList reuseList, IOVersions<? extends BPlusInnerIO<IndexItem>> innerIos, IOVersions<? extends BPlusLeafIO<IndexItem>> leafIos, boolean initNew, @Nullable FailureProcessor failureProcessor) throws IgniteCheckedException {
            super(MetaTree.treeName("meta", "Meta"), cacheId, pageMem, wal, globalRmvId, metaPageId, reuseList, innerIos, leafIos, failureProcessor);
            this.allocPartId = allocPartId;
            this.allocSpace = allocSpace;
            this.initTree(initNew);
        }

        @Override
        protected long allocatePageNoReuse() throws IgniteCheckedException {
            return this.pageMem.allocatePage(this.groupId(), this.allocPartId, this.allocSpace);
        }

        @Override
        protected int compare(BPlusIO<IndexItem> io, long pageAddr, int idx, IndexItem row) throws IgniteCheckedException {
            int off = ((IndexIO)((Object)io)).getOffset(pageAddr, idx);
            int shift = 0;
            int len = PageUtils.getUnsignedByte(pageAddr, off + shift);
            ++shift;
            for (int i = 0; i < len && i < row.idxName.length; ++i) {
                int cmp = Byte.compare(PageUtils.getByte(pageAddr, off + i + shift), row.idxName[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(len, row.idxName.length);
        }

        @Override
        public IndexItem getRow(BPlusIO<IndexItem> io, long pageAddr, int idx, Object ignore) throws IgniteCheckedException {
            return IndexStorageImpl.readRow(pageAddr, ((IndexIO)((Object)io)).getOffset(pageAddr, idx));
        }
    }
}

