/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessor;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.NotNull;

public class MvccQueryTrackerImpl
implements MvccQueryTracker {
    @GridToStringExclude
    private final GridCacheContext cctx;
    @GridToStringExclude
    private final IgniteLogger log;
    private long crdVer;
    private final long id;
    private MvccSnapshot snapshot;
    private volatile AffinityTopologyVersion topVer;
    private final boolean canRemap;
    private boolean done;

    public MvccQueryTrackerImpl(GridCacheContext cctx) {
        this(cctx, true);
    }

    public MvccQueryTrackerImpl(GridCacheContext cctx, boolean canRemap) {
        this.cctx = cctx;
        this.id = ID_CNTR.incrementAndGet();
        this.canRemap = canRemap;
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public synchronized MvccSnapshot snapshot() {
        return this.snapshot;
    }

    @Override
    public GridCacheContext context() {
        return this.cctx;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot() {
        MvccSnapshot snapshot = this.snapshot();
        if (snapshot != null) {
            return new GridFinishedFuture<MvccSnapshot>(snapshot);
        }
        MvccSnapshotFuture fut = new MvccSnapshotFuture();
        this.requestSnapshot0(this.cctx.shared().exchange().readyAffinityVersion(), fut);
        return fut;
    }

    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot(@NotNull AffinityTopologyVersion topVer) {
        MvccSnapshot snapshot = this.snapshot();
        if (snapshot != null) {
            return new GridFinishedFuture<MvccSnapshot>(snapshot);
        }
        MvccSnapshotFuture fut = new MvccSnapshotFuture();
        this.requestSnapshot0(topVer, fut);
        return fut;
    }

    @Override
    public void requestSnapshot(@NotNull AffinityTopologyVersion topVer, @NotNull MvccSnapshotResponseListener lsnr) {
        MvccSnapshot snapshot = this.snapshot();
        if (snapshot != null) {
            lsnr.onResponse(snapshot);
        } else {
            this.requestSnapshot0(topVer, lsnr);
        }
    }

    @Override
    public void onDone() {
        if (!this.checkDone()) {
            return;
        }
        MvccProcessor prc = this.cctx.shared().coordinators();
        MvccSnapshot snapshot = this.snapshot();
        if (snapshot != null) {
            prc.removeQueryTracker(this.id);
            prc.ackQueryDone(snapshot, this.id);
        }
    }

    @Override
    public IgniteInternalFuture<Void> onDone(@NotNull GridNearTxLocal tx, boolean commit) {
        MvccSnapshot snapshot = this.snapshot();
        MvccSnapshot txSnapshot = tx.mvccSnapshot();
        if (!this.checkDone() || snapshot == null && txSnapshot == null) {
            return commit ? new GridFinishedFuture() : null;
        }
        MvccProcessor prc = this.cctx.shared().coordinators();
        if (snapshot != null) {
            prc.removeQueryTracker(this.id);
        }
        if (txSnapshot == null) {
            prc.ackQueryDone(snapshot, this.id);
        } else {
            if (commit) {
                return prc.ackTxCommit(txSnapshot, snapshot, this.id);
            }
            prc.ackTxRollback(txSnapshot, snapshot, this.id);
        }
        return null;
    }

    @Override
    public synchronized long onMvccCoordinatorChange(MvccCoordinator newCrd) {
        if (this.snapshot != null) {
            assert (this.crdVer != 0L) : this;
            if (this.crdVer != newCrd.coordinatorVersion()) {
                this.crdVer = newCrd.coordinatorVersion();
                return this.id;
            }
            return -1L;
        }
        if (this.crdVer != 0L) {
            this.crdVer = 0L;
        }
        return -1L;
    }

    private void requestSnapshot0(AffinityTopologyVersion topVer, MvccSnapshotResponseListener lsnr) {
        if (this.checkTopology(topVer, lsnr = this.decorate(lsnr))) {
            try {
                MvccSnapshot snapshot = this.cctx.shared().coordinators().tryRequestSnapshotLocal();
                if (snapshot == null) {
                    this.cctx.shared().coordinators().requestSnapshotAsync(lsnr);
                } else {
                    lsnr.onResponse(snapshot);
                }
            }
            catch (ClusterTopologyCheckedException e) {
                lsnr.onError(e);
            }
        }
    }

    private MvccSnapshotResponseListener decorate(MvccSnapshotResponseListener lsnr) {
        assert (lsnr != null);
        if (lsnr.getClass() == ListenerDecorator.class) {
            return lsnr;
        }
        return new ListenerDecorator(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTopology(AffinityTopologyVersion topVer, MvccSnapshotResponseListener lsnr) {
        MvccCoordinator crd = this.cctx.affinity().mvccCoordinator(topVer);
        if (crd == null) {
            lsnr.onError(MvccUtils.noCoordinatorError(topVer));
            return false;
        }
        this.topVer = topVer;
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            this.crdVer = crd.coordinatorVersion();
        }
        MvccCoordinator curCrd = this.cctx.topology().mvccCoordinator();
        if (!crd.equals(curCrd)) {
            assert (this.cctx.topology().topologyVersionFuture().initialVersion().compareTo(topVer) > 0);
            this.tryRemap(lsnr);
            return false;
        }
        return true;
    }

    private void tryRemap(final MvccSnapshotResponseListener lsnr) {
        if (!this.canRemap) {
            lsnr.onError(new ClusterTopologyCheckedException("Failed to request mvcc version, coordinator failed."));
            return;
        }
        IgniteInternalFuture<AffinityTopologyVersion> waitFut = this.cctx.shared().exchange().affinityReadyFuture(this.topVer.nextMinorVersion());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remap on new topology: " + waitFut);
        }
        if (waitFut == null) {
            this.requestSnapshot(this.cctx.shared().exchange().readyAffinityVersion(), lsnr);
        } else {
            waitFut.listen(new IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    try {
                        MvccQueryTrackerImpl.this.requestSnapshot(fut.get(), lsnr);
                    }
                    catch (IgniteCheckedException e) {
                        lsnr.onError(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onResponse0(@NotNull MvccSnapshot res, MvccSnapshotResponseListener lsnr) {
        boolean needRemap = false;
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            assert (this.snapshot() == null) : "[this=" + this + ", rcvdVer=" + res + "]";
            if (this.crdVer != 0L) {
                this.snapshot = res;
            } else {
                needRemap = true;
            }
        }
        if (needRemap) {
            this.tryRemap(lsnr);
            return false;
        }
        this.cctx.shared().coordinators().addQueryTracker(this);
        return true;
    }

    private boolean onError0(IgniteCheckedException e, MvccSnapshotResponseListener lsnr) {
        if (e instanceof ClusterTopologyCheckedException && this.canRemap) {
            if (e instanceof ClusterTopologyServerNotFoundException) {
                return true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mvcc coordinator failed, need remap: " + e);
            }
            this.tryRemap(lsnr);
            return false;
        }
        return true;
    }

    private synchronized boolean checkDone() {
        if (!this.done) {
            this.done = true;
            return true;
        }
        return false;
    }

    public String toString() {
        return S.toString(MvccQueryTrackerImpl.class, this);
    }

    private final class ListenerDecorator
    implements MvccSnapshotResponseListener {
        private final MvccSnapshotResponseListener lsnr;

        private ListenerDecorator(MvccSnapshotResponseListener lsnr) {
            this.lsnr = lsnr;
        }

        @Override
        public void onResponse(MvccSnapshot res) {
            if (MvccQueryTrackerImpl.this.onResponse0(res, this)) {
                this.lsnr.onResponse(res);
            }
        }

        @Override
        public void onError(IgniteCheckedException e) {
            if (MvccQueryTrackerImpl.this.onError0(e, this)) {
                this.lsnr.onError(e);
            }
        }
    }
}

