/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

class MvccPreviousCoordinatorQueries {
    private volatile boolean prevQueriesDone;
    private final ConcurrentHashMap<UUID, Set<Long>> activeQueries = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Set<Long>> rcvdAcks = new ConcurrentHashMap();
    private Set<UUID> rcvd;
    private Set<UUID> waitNodes;
    private boolean initDone;

    MvccPreviousCoordinatorQueries() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Map<UUID, GridLongList> nodeQueries, Collection<ClusterNode> nodes, GridDiscoveryManager mgr) {
        MvccPreviousCoordinatorQueries mvccPreviousCoordinatorQueries = this;
        synchronized (mvccPreviousCoordinatorQueries) {
            assert (!this.initDone);
            assert (this.waitNodes == null);
            this.waitNodes = new HashSet<UUID>();
            for (ClusterNode clusterNode : nodes) {
                if (nodeQueries != null && nodeQueries.containsKey(clusterNode.id()) || !mgr.alive(clusterNode) || F.contains(this.rcvd, clusterNode.id())) continue;
                this.waitNodes.add(clusterNode.id());
            }
            this.initDone = this.waitNodes.isEmpty();
            if (nodeQueries != null) {
                for (Map.Entry entry : nodeQueries.entrySet()) {
                    this.mergeToActiveQueries((UUID)entry.getKey(), (GridLongList)entry.getValue());
                }
            }
            if (this.initDone && !this.prevQueriesDone) {
                this.prevQueriesDone = this.activeQueries.isEmpty() && this.rcvdAcks.isEmpty();
            }
        }
    }

    boolean previousQueriesDone() {
        return this.prevQueriesDone;
    }

    private void mergeToActiveQueries(UUID nodeId, GridLongList nodeTrackers) {
        if (nodeTrackers == null || nodeTrackers.isEmpty() || this.prevQueriesDone) {
            return;
        }
        Set<Long> currTrackers = this.activeQueries.get(nodeId);
        if (currTrackers == null) {
            currTrackers = this.addAll(nodeTrackers, null);
            this.activeQueries.put(nodeId, currTrackers);
        } else {
            this.addAll(nodeTrackers, currTrackers);
        }
        Set<Long> currAcks = this.rcvdAcks.get(nodeId);
        if (!currTrackers.isEmpty() && currAcks != null && !currAcks.isEmpty()) {
            HashSet<Long> intersection = new HashSet<Long>(currAcks);
            intersection.retainAll(currTrackers);
            currAcks.removeAll(intersection);
            currTrackers.removeAll(intersection);
            if (currTrackers.isEmpty()) {
                this.activeQueries.remove(nodeId);
            }
            if (currAcks.isEmpty()) {
                this.rcvdAcks.remove(nodeId);
            }
        }
        if (this.initDone && !this.prevQueriesDone) {
            this.prevQueriesDone = this.activeQueries.isEmpty() && this.rcvdAcks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNodeActiveQueries(UUID nodeId, @Nullable GridLongList nodeTrackers) {
        MvccPreviousCoordinatorQueries mvccPreviousCoordinatorQueries = this;
        synchronized (mvccPreviousCoordinatorQueries) {
            if (this.initDone) {
                return;
            }
            if (this.waitNodes == null) {
                if (this.rcvd == null) {
                    this.rcvd = new HashSet<UUID>();
                }
                this.rcvd.add(nodeId);
            } else {
                this.waitNodes.remove(nodeId);
                this.initDone = this.waitNodes.isEmpty();
            }
            this.mergeToActiveQueries(nodeId, nodeTrackers);
            if (this.initDone && !this.prevQueriesDone) {
                this.prevQueriesDone = this.activeQueries.isEmpty() && this.rcvdAcks.isEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeFailed(UUID nodeId) {
        MvccPreviousCoordinatorQueries mvccPreviousCoordinatorQueries = this;
        synchronized (mvccPreviousCoordinatorQueries) {
            if (this.waitNodes != null) {
                this.waitNodes.remove(nodeId);
                this.initDone = this.waitNodes.isEmpty();
            }
            if (this.initDone && !this.prevQueriesDone && this.activeQueries.remove(nodeId) != null) {
                this.prevQueriesDone = this.activeQueries.isEmpty() && this.rcvdAcks.isEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQueryDone(UUID nodeId, long qryTrackerId) {
        if (qryTrackerId == -1L) {
            return;
        }
        MvccPreviousCoordinatorQueries mvccPreviousCoordinatorQueries = this;
        synchronized (mvccPreviousCoordinatorQueries) {
            Set<Long> nodeTrackers = this.activeQueries.get(nodeId);
            if (nodeTrackers == null || !nodeTrackers.remove(qryTrackerId)) {
                Set<Long> nodeAcks = this.rcvdAcks.get(nodeId);
                if (nodeAcks == null) {
                    nodeAcks = new HashSet<Long>();
                    this.rcvdAcks.put(nodeId, nodeAcks);
                }
                nodeAcks.add(qryTrackerId);
            }
            if (nodeTrackers != null && nodeTrackers.isEmpty()) {
                this.activeQueries.remove(nodeId);
            }
            if (this.initDone && !this.prevQueriesDone) {
                this.prevQueriesDone = this.activeQueries.isEmpty() && this.rcvdAcks.isEmpty();
            }
        }
    }

    private Set<Long> addAll(GridLongList from, Set<Long> to) {
        assert (from != null);
        if (to == null) {
            to = new HashSet<Long>(from.size());
        }
        for (int i = 0; i < from.size(); ++i) {
            to.add(from.get(i));
        }
        return to;
    }
}

