/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridNearTxQueryResultsEnlistRequest
extends GridCacheIdMessage {
    private static final long serialVersionUID = 0L;
    private long threadId;
    private IgniteUuid futId;
    private boolean clientFirst;
    private int miniId;
    private UUID subjId;
    private AffinityTopologyVersion topVer;
    private GridCacheVersion lockVer;
    private MvccSnapshot mvccSnapshot;
    private long timeout;
    private long txTimeout;
    private int taskNameHash;
    @GridDirectTransient
    private Collection<Object> rows;
    @GridToStringExclude
    private KeyCacheObject[] keys;
    @GridToStringExclude
    private CacheObject[] values;
    private EnlistOperation op;

    public GridNearTxQueryResultsEnlistRequest() {
    }

    GridNearTxQueryResultsEnlistRequest(int cacheId, long threadId, IgniteUuid futId, int miniId, UUID subjId, AffinityTopologyVersion topVer, GridCacheVersion lockVer, MvccSnapshot mvccSnapshot, boolean clientFirst, long timeout, long txTimeout, int taskNameHash, Collection<Object> rows, EnlistOperation op) {
        this.txTimeout = txTimeout;
        this.cacheId = cacheId;
        this.threadId = threadId;
        this.futId = futId;
        this.miniId = miniId;
        this.subjId = subjId;
        this.topVer = topVer;
        this.lockVer = lockVer;
        this.mvccSnapshot = mvccSnapshot;
        this.clientFirst = clientFirst;
        this.timeout = timeout;
        this.taskNameHash = taskNameHash;
        this.rows = rows;
        this.op = op;
    }

    public long threadId() {
        return this.threadId;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public int miniId() {
        return this.miniId;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public GridCacheVersion version() {
        return this.lockVer;
    }

    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public long timeout() {
        return this.timeout;
    }

    public long txTimeout() {
        return this.txTimeout;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public boolean firstClientRequest() {
        return this.clientFirst;
    }

    public Collection<Object> rows() {
        return this.rows;
    }

    public EnlistOperation operation() {
        return this.op;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        CacheObjectContext objCtx = cctx.cacheObjectContext();
        if (this.rows != null && this.keys == null) {
            this.keys = new KeyCacheObject[this.rows.size()];
            int i = 0;
            boolean keysOnly = this.op.isDeleteOrLock();
            this.values = keysOnly ? null : new CacheObject[this.keys.length];
            for (Object row : this.rows) {
                Object key;
                Object val = null;
                if (keysOnly) {
                    key = row;
                } else {
                    key = ((IgniteBiTuple)row).getKey();
                    val = ((IgniteBiTuple)row).getValue();
                }
                assert (key != null && (keysOnly || val != null)) : "key=" + key + ", val=" + val;
                KeyCacheObject key0 = cctx.toCacheKeyObject(key);
                assert (key0 != null);
                key0.prepareMarshal(objCtx);
                this.keys[i] = key0;
                if (!keysOnly) {
                    CacheObject val0 = cctx.toCacheObject(val);
                    assert (val0 != null);
                    val0.prepareMarshal(objCtx);
                    this.values[i] = val0;
                }
                ++i;
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.keys != null) {
            this.rows = new ArrayList<Object>(this.keys.length);
            CacheObjectContext objCtx = ctx.cacheContext(this.cacheId).cacheObjectContext();
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i].finishUnmarshal(objCtx, ldr);
                if (this.op.isDeleteOrLock()) {
                    this.rows.add(this.keys[i]);
                    continue;
                }
                if (this.values[i] != null) {
                    this.values[i].finishUnmarshal(objCtx, ldr);
                }
                this.rows.add(new IgniteBiTuple<KeyCacheObject, CacheObject>(this.keys[i], this.values[i]));
            }
            this.keys = null;
            this.values = null;
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeBoolean("clientFirst", this.clientFirst)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeObjectArray("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("lockVer", this.lockVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeLong("txTimeout", this.txTimeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeObjectArray("values", this.values, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.clientFirst = reader.readBoolean("clientFirst");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.keys = reader.readObjectArray("keys", MessageCollectionItemType.MSG, KeyCacheObject.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.lockVer = (GridCacheVersion)reader.readMessage("lockVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = EnlistOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 10: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.txTimeout = reader.readLong("txTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.values = reader.readObjectArray("values", MessageCollectionItemType.MSG, CacheObject.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxQueryResultsEnlistRequest.class);
    }

    @Override
    public byte fieldsCount() {
        return 17;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public short directType() {
        return 153;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxQueryResultsEnlistRequest.class, this);
    }
}

