/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch.Latch;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch.LatchAckMessage;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class ExchangeLatchManager {
    private static final IgniteProductVersion VERSION_SINCE = IgniteProductVersion.fromString("2.5.0");
    public static final IgniteProductVersion PROTOCOL_V2_VERSION_SINCE = IgniteProductVersion.fromString("2.7.0");
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    @GridToStringExclude
    private final GridDiscoveryManager discovery;
    @GridToStringExclude
    private final GridIoManager io;
    @GridToStringExclude
    private volatile ClusterNode crd;
    private final ConcurrentMap<CompletableLatchUid, Set<UUID>> pendingAcks = new ConcurrentHashMap<CompletableLatchUid, Set<UUID>>();
    @GridToStringInclude
    private final ConcurrentMap<CompletableLatchUid, ServerLatch> serverLatches = new ConcurrentHashMap<CompletableLatchUid, ServerLatch>();
    @GridToStringInclude
    private final ConcurrentMap<CompletableLatchUid, ClientLatch> clientLatches = new ConcurrentHashMap<CompletableLatchUid, ClientLatch>();
    @GridToStringExclude
    private final ConcurrentMap<AffinityTopologyVersion, ClusterNode> joinedNodes = new ConcurrentHashMap<AffinityTopologyVersion, ClusterNode>();
    private final ReentrantLock lock = new ReentrantLock();

    public ExchangeLatchManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.discovery = ctx.discovery();
        this.io = ctx.io();
        if (!ctx.clientNode() && !ctx.isDaemon()) {
            ctx.io().addMessageListener(GridTopic.TOPIC_EXCHANGE, (nodeId, msg, plc) -> {
                if (msg instanceof LatchAckMessage) {
                    this.processAck(nodeId, (LatchAckMessage)msg);
                }
            });
            ctx.discovery().localJoinFuture().listen(f -> {
                if (f.error() == null) {
                    this.crd = this.getLatchCoordinator(AffinityTopologyVersion.NONE);
                }
            });
            ctx.event().addDiscoveryEventListener((e, cache) -> {
                assert (e != null);
                assert (e.type() == 11 || e.type() == 12) : this;
                ctx.closure().runLocalSafe(() -> this.processNodeLeft(cache.version(), e.eventNode()));
            }, 11, 12);
            ctx.event().addDiscoveryEventListener((e, cache) -> {
                assert (e != null);
                assert (e.type() == 10);
                this.joinedNodes.put(cache.version(), e.eventNode());
            }, 10, new int[0]);
        }
    }

    private Latch createServerLatch(CompletableLatchUid latchUid, Collection<ClusterNode> participants) {
        assert (!this.serverLatches.containsKey(latchUid));
        ServerLatch latch = new ServerLatch(latchUid, participants);
        this.serverLatches.put(latchUid, latch);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Server latch is created [latch=" + latchUid + ", participantsSize=" + participants.size() + "]");
        }
        if (this.pendingAcks.containsKey(latchUid)) {
            Set acks = (Set)this.pendingAcks.get(latchUid);
            for (UUID node : acks) {
                if (!latch.hasParticipant(node) || latch.hasAck(node)) continue;
                latch.ack(node);
            }
            this.pendingAcks.remove(latchUid);
        }
        return latch;
    }

    private Latch createClientLatch(CompletableLatchUid latchUid, ClusterNode coordinator, Collection<ClusterNode> participants) {
        assert (!this.serverLatches.containsKey(latchUid));
        assert (!this.clientLatches.containsKey(latchUid));
        ClientLatch latch = new ClientLatch(latchUid, coordinator, participants);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client latch is created [latch=" + latchUid + ", crd=" + coordinator + ", participantsSize=" + participants.size() + "]");
        }
        this.clientLatches.put(latchUid, latch);
        return latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Latch getOrCreate(String id, AffinityTopologyVersion topVer) {
        this.lock.lock();
        try {
            CompletableLatch latch;
            CompletableLatchUid latchUid = new CompletableLatchUid(id, topVer);
            CompletableLatch completableLatch = latch = this.clientLatches.containsKey(latchUid) ? (CompletableLatch)this.clientLatches.get(latchUid) : (CompletableLatch)this.serverLatches.get(latchUid);
            if (latch != null) {
                CompletableLatch completableLatch2 = latch;
                return completableLatch2;
            }
            ClusterNode coordinator = this.getLatchCoordinator(topVer);
            if (coordinator == null) {
                Latch latch2 = null;
                return latch2;
            }
            Collection<ClusterNode> participants = this.getLatchParticipants(topVer);
            Latch latch3 = coordinator.isLocal() ? this.createServerLatch(latchUid, participants) : this.createClientLatch(latchUid, coordinator, participants);
            return latch3;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Collection<ClusterNode> aliveNodesForTopologyVer(AffinityTopologyVersion topVer) {
        if (topVer == AffinityTopologyVersion.NONE) {
            return this.discovery.aliveServerNodes();
        }
        Collection<ClusterNode> histNodes = this.discovery.topology(topVer.topologyVersion());
        if (histNodes != null) {
            return histNodes.stream().filter(n -> !n.isClient() && !n.isDaemon() && this.discovery.alive((ClusterNode)n)).collect(Collectors.toList());
        }
        throw new IgniteException("Topology " + topVer + " not found in discovery history ; consider increasing IGNITE_DISCOVERY_HISTORY_SIZE property. Current value is " + IgniteSystemProperties.getInteger("IGNITE_DISCOVERY_HISTORY_SIZE", -1));
    }

    private Collection<ClusterNode> getLatchParticipants(AffinityTopologyVersion topVer) {
        Collection<ClusterNode> aliveNodes = this.aliveNodesForTopologyVer(topVer);
        List<ClusterNode> participantNodes = aliveNodes.stream().filter(node -> node.version().compareTo(VERSION_SINCE) >= 0).collect(Collectors.toList());
        if (this.canSkipJoiningNodes(topVer)) {
            return this.excludeJoinedNodes(participantNodes, topVer);
        }
        return participantNodes;
    }

    private List<ClusterNode> excludeJoinedNodes(List<ClusterNode> participantNodes, AffinityTopologyVersion topVer) {
        ClusterNode joinedNode = (ClusterNode)this.joinedNodes.get(topVer);
        if (joinedNode != null) {
            participantNodes.remove(joinedNode);
        }
        return participantNodes;
    }

    @Nullable
    private ClusterNode getLatchCoordinator(AffinityTopologyVersion topVer) {
        Collection<ClusterNode> aliveNodes = this.aliveNodesForTopologyVer(topVer);
        List<ClusterNode> applicableNodes = aliveNodes.stream().filter(node -> node.version().compareTo(VERSION_SINCE) >= 0).sorted(Comparator.comparing(ClusterNode::order)).collect(Collectors.toList());
        if (applicableNodes.isEmpty()) {
            return null;
        }
        if (this.canSkipJoiningNodes(topVer)) {
            applicableNodes = this.excludeJoinedNodes(applicableNodes, topVer);
        }
        return (ClusterNode)applicableNodes.get(0);
    }

    public boolean canSkipJoiningNodes(AffinityTopologyVersion topVer) {
        Collection<ClusterNode> applicableNodes = topVer.equals(AffinityTopologyVersion.NONE) ? this.discovery.aliveServerNodes() : this.discovery.topology(topVer.topologyVersion());
        return applicableNodes.stream().allMatch(node -> node.version().compareTo(PROTOCOL_V2_VERSION_SINCE) >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAck(UUID from, LatchAckMessage message) {
        this.lock.lock();
        try {
            ClusterNode coordinator = this.getLatchCoordinator(message.topVer());
            if (coordinator == null) {
                return;
            }
            CompletableLatchUid latchUid = new CompletableLatchUid(message.latchId(), message.topVer());
            if (message.isFinal()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Process final ack [latch=" + latchUid + ", from=" + from + "]");
                }
                assert (this.serverLatches.containsKey(latchUid) || this.clientLatches.containsKey(latchUid));
                if (this.clientLatches.containsKey(latchUid)) {
                    ClientLatch latch = (ClientLatch)this.clientLatches.remove(latchUid);
                    latch.complete();
                }
                this.serverLatches.remove(latchUid);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Process ack [latch=" + latchUid + ", from=" + from + "]");
                }
                if (this.serverLatches.containsKey(latchUid)) {
                    ServerLatch latch = (ServerLatch)this.serverLatches.get(latchUid);
                    if (latch.hasParticipant(from) && !latch.hasAck(from)) {
                        latch.ack(from);
                    }
                } else {
                    this.pendingAcks.computeIfAbsent(latchUid, id -> new GridConcurrentHashSet()).add(from);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void becomeNewCoordinator() {
        if (this.log.isInfoEnabled()) {
            this.log.info("Become new coordinator " + this.crd.id());
        }
        HashSet latchesToRestore = new HashSet();
        latchesToRestore.addAll(this.pendingAcks.keySet());
        latchesToRestore.addAll(this.clientLatches.keySet());
        for (CompletableLatchUid latchUid : latchesToRestore) {
            AffinityTopologyVersion topVer = latchUid.topVer;
            Collection<ClusterNode> participants = this.getLatchParticipants(topVer);
            if (participants.isEmpty()) continue;
            this.createServerLatch(latchUid, participants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNodeLeft(AffinityTopologyVersion topVer, ClusterNode left) {
        assert (this.crd != null) : "Coordinator is not initialized";
        this.lock.lock();
        try {
            CompletableLatch latch;
            ClusterNode coordinator;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Process node left " + left.id());
            }
            if ((coordinator = this.getLatchCoordinator(topVer)) == null) {
                return;
            }
            this.joinedNodes.entrySet().stream().filter(e -> ((ClusterNode)e.getValue()).equals(left)).map(e -> (AffinityTopologyVersion)e.getKey()).forEach(this.joinedNodes::remove);
            for (Map.Entry ackEntry : this.pendingAcks.entrySet()) {
                if (!((Set)ackEntry.getValue()).contains(left.id())) continue;
                ((Set)this.pendingAcks.get(ackEntry.getKey())).remove(left.id());
            }
            for (Map.Entry latchEntry : this.clientLatches.entrySet()) {
                latch = (ClientLatch)latchEntry.getValue();
                if (!((ClientLatch)latch).hasCoordinator(left.id())) continue;
                if (latch.hasParticipant(coordinator.id())) {
                    ((ClientLatch)latch).newCoordinator(coordinator);
                    continue;
                }
                AffinityTopologyVersion latchTopVer = ((CompletableLatchUid)latchEntry.getKey()).topVer;
                assert (this.getLatchParticipants(latchTopVer).isEmpty());
                latch.complete(new IgniteCheckedException("All latch participants are left from topology."));
                this.clientLatches.remove(latchEntry.getKey());
            }
            for (Map.Entry latchEntry : this.serverLatches.entrySet()) {
                latch = (ServerLatch)latchEntry.getValue();
                if (!latch.hasParticipant(left.id()) || ((ServerLatch)latch).hasAck(left.id())) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Process node left [latch=" + latchEntry.getKey() + ", left=" + left.id() + "]");
                }
                ((ServerLatch)latch).ack(left.id());
            }
            if (coordinator.isLocal() && this.crd.id() != coordinator.id()) {
                this.crd = coordinator;
                this.becomeNewCoordinator();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return S.toString(ExchangeLatchManager.class, this);
    }

    private static class CompletableLatchUid {
        private String id;
        private AffinityTopologyVersion topVer;

        private CompletableLatchUid(String id, AffinityTopologyVersion topVer) {
            this.id = id;
            this.topVer = topVer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletableLatchUid uid = (CompletableLatchUid)o;
            return Objects.equals(this.id, uid.id) && Objects.equals(this.topVer, uid.topVer);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.topVer);
        }

        public String toString() {
            return "CompletableLatchUid{id='" + this.id + '\'' + ", topVer=" + this.topVer + '}';
        }
    }

    private static abstract class CompletableLatch
    implements Latch {
        @GridToStringInclude
        protected final String id;
        @GridToStringInclude
        protected final AffinityTopologyVersion topVer;
        @GridToStringExclude
        protected final Set<UUID> participants;
        @GridToStringExclude
        protected final GridFutureAdapter<?> complete = new GridFutureAdapter();

        CompletableLatch(CompletableLatchUid latchUid, Collection<ClusterNode> participants) {
            this.id = latchUid.id;
            this.topVer = latchUid.topVer;
            this.participants = participants.stream().map(ClusterNode::id).collect(Collectors.toSet());
        }

        @Override
        public void await() throws IgniteCheckedException {
            this.complete.get();
        }

        @Override
        public void await(long timeout, TimeUnit timeUnit) throws IgniteCheckedException {
            this.complete.get(timeout, timeUnit);
        }

        boolean hasParticipant(UUID node) {
            return this.participants.contains(node);
        }

        boolean isCompleted() {
            return this.complete.isDone();
        }

        void complete() {
            this.complete.onDone();
        }

        void complete(Throwable error) {
            this.complete.onDone(error);
        }

        String latchId() {
            return this.id + "-" + this.topVer;
        }

        public String toString() {
            return S.toString(CompletableLatch.class, this);
        }
    }

    class ClientLatch
    extends CompletableLatch {
        private volatile ClusterNode coordinator;
        private boolean ackSent;

        ClientLatch(CompletableLatchUid latchUid, ClusterNode coordinator, Collection<ClusterNode> participants) {
            super(latchUid, participants);
            this.coordinator = coordinator;
        }

        private boolean hasCoordinator(UUID node) {
            return this.coordinator.id().equals(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newCoordinator(ClusterNode coordinator) {
            if (ExchangeLatchManager.this.log.isDebugEnabled()) {
                ExchangeLatchManager.this.log.debug("Coordinator is changed [latch=" + this.latchId() + ", newCrd=" + coordinator.id() + "]");
            }
            ClientLatch clientLatch = this;
            synchronized (clientLatch) {
                this.coordinator = coordinator;
                if (this.ackSent) {
                    this.sendAck();
                }
            }
        }

        private void sendAck() {
            block3: {
                try {
                    this.ackSent = true;
                    ExchangeLatchManager.this.io.sendToGridTopic(this.coordinator, GridTopic.TOPIC_EXCHANGE, (Message)new LatchAckMessage(this.id, this.topVer, false), (byte)2);
                    if (ExchangeLatchManager.this.log.isDebugEnabled()) {
                        ExchangeLatchManager.this.log.debug("Ack has sent [latch=" + this.latchId() + ", to=" + this.coordinator.id() + "]");
                    }
                }
                catch (IgniteCheckedException e) {
                    if (!ExchangeLatchManager.this.log.isDebugEnabled()) break block3;
                    ExchangeLatchManager.this.log.debug("Failed to send ack [latch=" + this.latchId() + ", to=" + this.coordinator.id() + "]: " + e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void countDown() {
            if (this.isCompleted()) {
                return;
            }
            ClientLatch clientLatch = this;
            synchronized (clientLatch) {
                this.sendAck();
            }
        }

        @Override
        public String toString() {
            return S.toString(ClientLatch.class, this, "super", super.toString());
        }
    }

    class ServerLatch
    extends CompletableLatch {
        private final AtomicInteger permits;
        private final Set<UUID> acks;

        ServerLatch(CompletableLatchUid latchUid, Collection<ClusterNode> participants) {
            super(latchUid, participants);
            this.acks = new GridConcurrentHashSet<UUID>();
            this.permits = new AtomicInteger(participants.size());
            this.complete.listen(f -> {
                for (ClusterNode node : participants) {
                    try {
                        if (!ExchangeLatchManager.this.discovery.alive(node)) continue;
                        ExchangeLatchManager.this.io.sendToGridTopic(node, GridTopic.TOPIC_EXCHANGE, (Message)new LatchAckMessage(this.id, this.topVer, true), (byte)2);
                        if (!ExchangeLatchManager.this.log.isDebugEnabled()) continue;
                        ExchangeLatchManager.this.log.debug("Final ack has sent [latch=" + this.latchId() + ", to=" + node.id() + "]");
                    }
                    catch (IgniteCheckedException e) {
                        if (!ExchangeLatchManager.this.log.isDebugEnabled()) continue;
                        ExchangeLatchManager.this.log.debug("Failed to send final ack [latch=" + this.latchId() + ", to=" + node.id() + "]: " + e.getMessage());
                    }
                }
            });
        }

        private boolean hasAck(UUID from) {
            return this.acks.contains(from);
        }

        private void ack(UUID from) {
            if (ExchangeLatchManager.this.log.isDebugEnabled()) {
                ExchangeLatchManager.this.log.debug("Ack is accepted [latch=" + this.latchId() + ", from=" + from + "]");
            }
            this.countDown0(from);
        }

        private void countDown0(UUID node) {
            if (this.isCompleted() || this.acks.contains(node)) {
                return;
            }
            this.acks.add(node);
            int remaining = this.permits.decrementAndGet();
            if (ExchangeLatchManager.this.log.isDebugEnabled()) {
                ExchangeLatchManager.this.log.debug("Count down [latch=" + this.latchId() + ", remaining=" + remaining + "]");
            }
            if (remaining == 0) {
                this.complete();
            }
        }

        @Override
        public void countDown() {
            this.countDown0(ExchangeLatchManager.this.ctx.localNodeId());
        }

        @Override
        public String toString() {
            Set pendingAcks = this.participants.stream().filter(ack -> !this.acks.contains(ack)).collect(Collectors.toSet());
            return S.toString(ServerLatch.class, this, "pendingAcks", pendingAcks, "super", super.toString());
        }
    }
}

