/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheFutureAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtGetSingleFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.CacheVersionedValue;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetResponse;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedSingleGetFuture
extends GridCacheFutureAdapter<Object>
implements GridCacheFuture<Object>,
CacheGetFuture,
IgniteDiagnosticAware {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private AffinityTopologyVersion topVer;
    private final GridCacheContext cctx;
    private final KeyCacheObject key;
    private final boolean readThrough;
    private final boolean forcePrimary;
    private final IgniteUuid futId;
    private boolean trackable;
    private final UUID subjId;
    private final String taskName;
    private boolean deserializeBinary;
    private boolean skipVals;
    private IgniteCacheExpiryPolicy expiryPlc;
    private final boolean canRemap;
    private final boolean needVer;
    private final boolean keepCacheObjects;
    private boolean recovery;
    @GridToStringInclude
    private ClusterNode node;
    protected final MvccSnapshot mvccSnapshot;
    private volatile GridCacheUtils.BackupPostProcessingClosure postProcessingClos;

    public GridPartitionedSingleGetFuture(GridCacheContext cctx, KeyCacheObject key, AffinityTopologyVersion topVer, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, boolean recovery, @Nullable MvccSnapshot mvccSnapshot) {
        assert (key != null);
        assert (mvccSnapshot == null || cctx.mvccEnabled());
        AffinityTopologyVersion lockedTopVer = cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            topVer = lockedTopVer;
            this.canRemap = false;
        } else {
            this.canRemap = true;
        }
        this.cctx = cctx;
        this.key = key;
        this.readThrough = readThrough;
        this.forcePrimary = forcePrimary;
        this.subjId = subjId;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
        this.recovery = recovery;
        this.topVer = topVer;
        this.mvccSnapshot = mvccSnapshot;
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridPartitionedSingleGetFuture.class);
        }
    }

    public void init() {
        Throwable err;
        AffinityTopologyVersion topVer = this.topVer.topologyVersion() > 0L ? this.topVer : (this.canRemap ? this.cctx.affinity().affinityTopologyVersion() : this.cctx.shared().exchange().readyAffinityVersion());
        GridDhtTopologyFuture topFut = this.cctx.shared().exchange().lastFinishedFuture();
        Throwable throwable = err = topFut != null ? topFut.validateCache(this.cctx, this.recovery, true, this.key, null) : null;
        if (err != null) {
            this.onDone(err);
            return;
        }
        this.map(topVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map(AffinityTopologyVersion topVer) {
        ClusterNode node = this.mapKeyToNode(topVer);
        if (node == null) {
            assert (this.isDone()) : this;
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (node.isLocal()) {
            GridDhtGetSingleFuture fut = this.cctx.dht().getDhtSingleAsync(node.id(), -1L, this.key, false, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, this.mvccSnapshot);
            Collection<Integer> invalidParts = fut.invalidPartitions();
            if (!F.isEmpty(invalidParts)) {
                AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                assert (updTopVer.compareTo(topVer) > 0) : "Got invalid partitions for local node but topology version did not change [topVer=" + topVer + ", updTopVer=" + updTopVer + ", invalidParts=" + invalidParts + ']';
                this.map(updTopVer);
            } else {
                fut.listen(new CI1<IgniteInternalFuture<GridCacheEntryInfo>>(){

                    @Override
                    public void apply(IgniteInternalFuture<GridCacheEntryInfo> fut) {
                        try {
                            GridCacheEntryInfo info = fut.get();
                            GridPartitionedSingleGetFuture.this.setResult(info);
                        }
                        catch (Exception e) {
                            U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                            GridPartitionedSingleGetFuture.this.onDone(e);
                        }
                    }
                });
            }
        } else {
            GridPartitionedSingleGetFuture fut = this;
            synchronized (fut) {
                assert (this.node == null);
                this.topVer = topVer;
                this.node = node;
            }
            if (!this.trackable) {
                this.trackable = true;
                this.cctx.mvcc().addFuture(this, this.futId);
            }
            boolean needVer = this.needVer;
            GridCacheUtils.BackupPostProcessingClosure postClos = CU.createBackupPostProcessingClosure(topVer, log, this.cctx, this.key, this.expiryPlc, this.readThrough, this.skipVals);
            if (postClos != null) {
                needVer = true;
                this.postProcessingClos = postClos;
            }
            GridNearSingleGetRequest req = new GridNearSingleGetRequest(this.cctx.cacheId(), this.futId.localId(), this.key, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, this.skipVals, false, needVer, this.cctx.deploymentEnabled(), this.recovery, this.mvccSnapshot);
            try {
                this.cctx.io().send(node, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    this.onNodeLeft(node.id());
                }
                this.onDone(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ClusterNode mapKeyToNode(AffinityTopologyVersion topVer) {
        ClusterNode affNode;
        boolean fastLocGet;
        int part = this.cctx.affinity().partition(this.key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(topVer));
            return null;
        }
        boolean bl = fastLocGet = !this.cctx.mvccEnabled() && (!this.forcePrimary || affNodes.get(0).isLocal()) && this.cctx.reserveForFastLocalGet(part, topVer);
        if (fastLocGet) {
            try {
                if (this.localGet(topVer, part)) {
                    ClusterNode clusterNode = null;
                    return clusterNode;
                }
            }
            finally {
                this.cctx.releaseForFastLocalGet(part, topVer);
            }
        }
        if ((affNode = this.cctx.selectAffinityNodeBalanced(affNodes, this.canRemap)) == null) {
            this.onDone(this.serverNotFoundError(topVer));
            return null;
        }
        return affNode;
    }

    private boolean localGet(AffinityTopologyVersion topVer, int part) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter colocated = this.cctx.dht();
        boolean readNoEntry = this.cctx.readNoEntry(this.expiryPlc, false);
        boolean evt = !this.skipVals;
        while (true) {
            try {
                boolean topStable;
                GridCacheEntryEx entry;
                CacheObject v = null;
                GridCacheVersion ver = null;
                boolean skipEntry = readNoEntry;
                if (readNoEntry) {
                    CacheDataRow row;
                    CacheDataRow cacheDataRow = row = this.mvccSnapshot != null ? this.cctx.offheap().mvccRead(this.cctx, this.key, this.mvccSnapshot) : this.cctx.offheap().read(this.cctx, this.key);
                    if (row != null) {
                        long expireTime = row.expireTime();
                        if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                            v = row.value();
                            if (this.needVer) {
                                ver = row.version();
                            }
                            if (evt) {
                                this.cctx.events().readEvent(this.key, null, row.value(), this.subjId, this.taskName, !this.deserializeBinary);
                            }
                        } else {
                            skipEntry = false;
                        }
                    }
                }
                if (!skipEntry && (entry = colocated.entryEx(this.key)) != null) {
                    boolean isNew = entry.isNewLocked();
                    if (this.needVer) {
                        EntryGetResult res = entry.innerGetVersioned(null, null, false, evt, this.subjId, null, this.taskName, this.expiryPlc, true, this.mvccSnapshot, null);
                        if (res != null) {
                            v = (CacheObject)res.value();
                            ver = res.version();
                        }
                    } else {
                        v = entry.innerGet(null, null, false, false, evt, this.subjId, null, this.taskName, this.expiryPlc, true, this.mvccSnapshot);
                    }
                    entry.touch(topVer);
                    if (v == null && isNew && entry.markObsoleteIfEmpty(ver)) {
                        colocated.removeEntry(entry);
                    }
                }
                if (v != null) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        this.cctx.cache().metrics0().onRead(true);
                    }
                    if (!this.skipVals) {
                        this.setResult(v, ver);
                    } else {
                        this.setSkipValueResult(true, ver);
                    }
                    return true;
                }
                boolean bl = topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        colocated.metrics0().onRead(false);
                    }
                    if (this.skipVals) {
                        this.setSkipValueResult(false, null);
                    } else {
                        this.setResult(null, null);
                    }
                    return true;
                }
                return false;
            }
            catch (GridCacheEntryRemovedException v) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                return false;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                return true;
            }
            break;
        }
    }

    public void onResult(UUID nodeId, GridNearSingleGetResponse res) {
        if (!this.processResponse(nodeId) || !this.checkError(res.error(), res.invalidPartitions(), res.topologyVersion(), nodeId)) {
            return;
        }
        Message res0 = res.result();
        if (this.needVer) {
            CacheVersionedValue verVal = (CacheVersionedValue)res0;
            if (verVal != null) {
                if (this.skipVals) {
                    this.setSkipValueResult(true, verVal.version());
                } else {
                    this.setResult(verVal.value(), verVal.version());
                }
            } else if (this.skipVals) {
                this.setSkipValueResult(false, null);
            } else {
                this.setResult(null, null);
            }
        } else if (this.skipVals) {
            this.setSkipValueResult(res.containsValue(), null);
        } else if (this.readThrough && res0 instanceof CacheVersionedValue) {
            CacheVersionedValue verVal = (CacheVersionedValue)res0;
            this.setResult(verVal.value(), verVal.version());
        } else {
            this.setResult((CacheObject)res0, null);
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        if (!this.processResponse(nodeId) || !this.checkError(res.error(), !F.isEmpty(res.invalidPartitions()), res.topologyVersion(), nodeId)) {
            return;
        }
        Collection<GridCacheEntryInfo> infos = res.entries();
        assert (F.isEmpty(infos) || infos.size() == 1) : infos;
        this.setResult(F.first(infos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processResponse(UUID nodeId) {
        GridPartitionedSingleGetFuture gridPartitionedSingleGetFuture = this;
        synchronized (gridPartitionedSingleGetFuture) {
            if (this.node != null && this.node.id().equals(nodeId)) {
                this.node = null;
                return true;
            }
        }
        return false;
    }

    private boolean checkError(@Nullable IgniteCheckedException err, boolean invalidParts, AffinityTopologyVersion rmtTopVer, UUID nodeId) {
        if (err != null) {
            this.onDone(err);
            return false;
        }
        if (invalidParts) {
            assert (!rmtTopVer.equals(AffinityTopologyVersion.ZERO));
            if (rmtTopVer.compareTo(this.topVer) <= 0) {
                this.onDone(new IgniteCheckedException("Failed to process invalid partitions response (remote node reported invalid partitions but remote topology version does not differ from local) [topVer=" + this.topVer + ", rmtTopVer=" + rmtTopVer + ", part=" + this.cctx.affinity().partition(this.key) + ", nodeId=" + nodeId + ']'));
                return false;
            }
            if (this.canRemap) {
                IgniteInternalFuture<AffinityTopologyVersion> topFut = this.cctx.shared().exchange().affinityReadyFuture(rmtTopVer);
                topFut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CIX1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            AffinityTopologyVersion topVer = fut.get();
                            GridPartitionedSingleGetFuture.this.remap(topVer);
                        }
                        catch (IgniteCheckedException e) {
                            GridPartitionedSingleGetFuture.this.onDone(e);
                        }
                    }
                });
            } else {
                this.map(this.topVer);
            }
            return false;
        }
        return true;
    }

    private void setResult(@Nullable GridCacheEntryInfo info) {
        assert (info == null || this.skipVals == (info.value() == null));
        if (this.skipVals) {
            if (info != null) {
                this.setSkipValueResult(true, info.version());
            } else {
                this.setSkipValueResult(false, null);
            }
        } else if (info != null) {
            this.setResult(info.value(), info.version());
        } else {
            this.setResult(null, null);
        }
    }

    private void setSkipValueResult(boolean res, @Nullable GridCacheVersion ver) {
        assert (this.skipVals);
        if (this.needVer) {
            assert (ver != null || !res);
            this.onDone(new EntryGetResult(res, ver));
        } else {
            this.onDone(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(@Nullable CacheObject val, @Nullable GridCacheVersion ver) {
        this.cctx.shared().database().checkpointReadLock();
        try {
            assert (!this.skipVals);
            if (val != null) {
                if (this.postProcessingClos != null) {
                    this.postProcessingClos.apply(val, ver);
                }
                if (!this.keepCacheObjects) {
                    Object res = this.cctx.unwrapBinaryIfNeeded(val, !this.deserializeBinary);
                    this.onDone(this.needVer ? new EntryGetResult(res, ver) : res);
                } else {
                    this.onDone(this.needVer ? new EntryGetResult(val, ver) : val);
                }
            } else {
                this.onDone(null);
            }
        }
        catch (Exception e) {
            this.onDone(e);
        }
        finally {
            this.cctx.shared().database().checkpointReadUnlock();
        }
    }

    private boolean partitionOwned(int part) {
        return this.cctx.topology().partitionState(this.cctx.localNodeId(), part) == GridDhtPartitionState.OWNING;
    }

    private ClusterTopologyServerNotFoundException serverNotFoundError(AffinityTopologyVersion topVer) {
        return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.cctx.name() + ']');
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        if (!this.processResponse(nodeId)) {
            return false;
        }
        if (this.canRemap) {
            AffinityTopologyVersion updTopVer = new AffinityTopologyVersion(Math.max(this.topVer.topologyVersion() + 1L, this.cctx.discovery().topologyVersion()));
            this.cctx.shared().exchange().affinityReadyFuture(updTopVer).listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    try {
                        GridPartitionedSingleGetFuture.this.remap(fut.get());
                    }
                    catch (IgniteCheckedException e) {
                        GridPartitionedSingleGetFuture.this.onDone(e);
                    }
                }
            });
        } else {
            this.remap(this.topVer);
        }
        return true;
    }

    private void remap(final AffinityTopologyVersion topVer) {
        this.cctx.closures().runLocalSafe(new Runnable(){

            @Override
            public void run() {
                GridPartitionedSingleGetFuture.this.map(topVer);
            }
        });
    }

    @Override
    public boolean onDone(Object res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            if (!(err instanceof NodeStoppingException)) {
                this.cctx.dht().sendTtlUpdateRequest(this.expiryPlc);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext ctx) {
        if (!this.isDone()) {
            AffinityTopologyVersion topVer;
            UUID nodeId;
            GridPartitionedSingleGetFuture gridPartitionedSingleGetFuture = this;
            synchronized (gridPartitionedSingleGetFuture) {
                nodeId = this.node != null ? this.node.id() : null;
                topVer = this.topVer;
            }
            if (nodeId != null) {
                ctx.basicInfo(nodeId, "GridPartitionedSingleGetFuture waiting for response [node=" + nodeId + ", key=" + this.key + ", futId=" + this.futId + ", topVer=" + topVer + ']');
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(GridPartitionedSingleGetFuture.class, this);
    }
}

