/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridInvokeValue;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxQueryEnlistRequest
extends GridCacheIdMessage {
    private static final long serialVersionUID = 5103887309729425173L;
    private IgniteUuid dhtFutId;
    private int batchId;
    private GridCacheVersion lockVer;
    private EnlistOperation op;
    private int mvccOpCnt;
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridDirectCollection(value=Message.class)
    private List<Message> vals;

    public GridDhtTxQueryEnlistRequest() {
    }

    GridDhtTxQueryEnlistRequest(int cacheId, IgniteUuid dhtFutId, GridCacheVersion lockVer, EnlistOperation op, int batchId, int mvccOpCnt, List<KeyCacheObject> keys, List<Message> vals) {
        this.cacheId = cacheId;
        this.dhtFutId = dhtFutId;
        this.lockVer = lockVer;
        this.op = op;
        this.batchId = batchId;
        this.mvccOpCnt = mvccOpCnt;
        this.keys = keys;
        this.vals = vals;
    }

    public int batchSize() {
        return this.keys == null ? 0 : this.keys.size();
    }

    public IgniteUuid dhtFutureId() {
        return this.dhtFutId;
    }

    public GridCacheVersion version() {
        return this.lockVer;
    }

    public int operationCounter() {
        return this.mvccOpCnt;
    }

    public EnlistOperation op() {
        return this.op;
    }

    public List<KeyCacheObject> keys() {
        return this.keys;
    }

    public List<Message> values() {
        return this.vals;
    }

    public int batchId() {
        return this.batchId;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public short directType() {
        return 155;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        CacheObjectContext objCtx = cctx.cacheObjectContext();
        if (this.keys != null) {
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).prepareMarshal(objCtx);
                if (this.vals == null) continue;
                Message val = this.vals.get(i);
                if (val instanceof CacheObject) {
                    ((CacheObject)val).prepareMarshal(objCtx);
                    continue;
                }
                if (val instanceof CacheEntryInfoCollection) {
                    for (GridCacheEntryInfo entry : ((CacheEntryInfoCollection)val).infos()) {
                        CacheObject entryVal = entry.value();
                        if (entryVal == null) continue;
                        entryVal.prepareMarshal(objCtx);
                    }
                    continue;
                }
                if (!(val instanceof GridInvokeValue)) continue;
                ((GridInvokeValue)val).prepareMarshal(cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        CacheObjectContext objCtx = ctx.cacheContext(this.cacheId).cacheObjectContext();
        if (this.keys != null) {
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).finishUnmarshal(objCtx, ldr);
                if (this.vals == null) continue;
                Message val = this.vals.get(i);
                if (val instanceof CacheObject) {
                    ((CacheObject)val).finishUnmarshal(objCtx, ldr);
                    continue;
                }
                if (val instanceof CacheEntryInfoCollection) {
                    for (GridCacheEntryInfo entry : ((CacheEntryInfoCollection)val).infos()) {
                        CacheObject entryVal = entry.value();
                        if (entryVal == null) continue;
                        entryVal.finishUnmarshal(objCtx, ldr);
                    }
                    continue;
                }
                if (!(val instanceof GridInvokeValue)) continue;
                ((GridInvokeValue)val).finishUnmarshal(ctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeInt("batchId", this.batchId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeIgniteUuid("dhtFutId", this.dhtFutId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("lockVer", this.lockVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeInt("mvccOpCnt", this.mvccOpCnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("vals", this.vals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.batchId = reader.readInt("batchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.dhtFutId = reader.readIgniteUuid("dhtFutId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.lockVer = (GridCacheVersion)reader.readMessage("lockVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.mvccOpCnt = reader.readInt("mvccOpCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = EnlistOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 9: {
                this.vals = (List)reader.readCollection("vals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxQueryEnlistRequest.class);
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxQueryEnlistRequest.class, this);
    }
}

