/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.ReaderArguments;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridDhtGetSingleFuture<K, V>
extends GridFutureAdapter<GridCacheEntryInfo>
implements GridDhtFuture<GridCacheEntryInfo> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private long msgId;
    private UUID reader;
    private boolean readThrough;
    private GridCacheContext<K, V> cctx;
    private KeyCacheObject key;
    private final boolean addRdr;
    private int part = -1;
    private IgniteUuid futId;
    private GridCacheVersion ver;
    private AffinityTopologyVersion topVer;
    private Integer retry;
    private UUID subjId;
    private int taskNameHash;
    private IgniteCacheExpiryPolicy expiryPlc;
    private boolean skipVals;
    private final boolean recovery;
    private final MvccSnapshot mvccSnapshot;

    public GridDhtGetSingleFuture(GridCacheContext<K, V> cctx, long msgId, UUID reader, KeyCacheObject key, boolean addRdr, boolean readThrough, @NotNull AffinityTopologyVersion topVer, @Nullable UUID subjId, int taskNameHash, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean recovery, @Nullable MvccSnapshot mvccSnapshot) {
        assert (reader != null);
        assert (key != null);
        this.reader = reader;
        this.cctx = cctx;
        this.msgId = msgId;
        this.key = key;
        this.addRdr = addRdr;
        this.readThrough = readThrough;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.recovery = recovery;
        this.mvccSnapshot = mvccSnapshot;
        this.futId = IgniteUuid.randomUuid();
        this.ver = cctx.versions().next();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridDhtGetSingleFuture.class);
        }
    }

    void init() {
        this.map();
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    @Override
    public boolean onDone(GridCacheEntryInfo res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.part != -1) {
                this.cctx.topology().releasePartitions(this.part);
            }
            return true;
        }
        return false;
    }

    private void map() {
        GridDhtFuture<Object> fut;
        if (this.cctx.group().preloader().needForceKeys() && (fut = this.cctx.group().preloader().request(this.cctx, Collections.singleton(this.key), this.topVer)) != null) {
            if (!F.isEmpty(fut.invalidPartitions())) {
                assert (fut.invalidPartitions().size() == 1) : fut.invalidPartitions();
                this.retry = F.first(fut.invalidPartitions());
                this.onDone((GridCacheEntryInfo)null);
                return;
            }
            fut.listen(new IgniteInClosure<IgniteInternalFuture<Object>>(){

                @Override
                public void apply(IgniteInternalFuture<Object> fut) {
                    Throwable e = fut.error();
                    if (e != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to request keys from preloader [keys=" + GridDhtGetSingleFuture.this.key + ", err=" + e + ']');
                        }
                        if (e instanceof NodeStoppingException) {
                            return;
                        }
                        GridDhtGetSingleFuture.this.onDone(e);
                    } else {
                        GridDhtGetSingleFuture.this.map0();
                    }
                }
            });
            return;
        }
        this.map0();
    }

    private void map0() {
        assert (this.retry == null) : this.retry;
        if (!this.map(this.key)) {
            this.retry = this.cctx.affinity().partition(this.key);
            this.onDone((GridCacheEntryInfo)null);
            return;
        }
        this.getAsync();
    }

    @Override
    public Collection<Integer> invalidPartitions() {
        return this.retry == null ? Collections.emptyList() : Collections.singletonList(this.retry);
    }

    private boolean map(KeyCacheObject key) {
        try {
            GridDhtLocalPartition part;
            int keyPart = this.cctx.affinity().partition(key);
            GridDhtLocalPartition gridDhtLocalPartition = part = this.topVer.topologyVersion() > 0L ? this.cache().topology().localPartition(keyPart, this.topVer, true) : this.cache().topology().localPartition(keyPart);
            if (part == null) {
                return false;
            }
            assert (this.part == -1);
            if (part.reserve()) {
                this.part = part.id();
                return true;
            }
            return false;
        }
        catch (GridDhtInvalidPartitionException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAsync() {
        assert (this.part != -1);
        String taskName0 = this.cctx.kernalContext().job().currentTaskName();
        if (taskName0 == null) {
            taskName0 = this.cctx.kernalContext().task().resolveTaskName(this.taskNameHash);
        }
        final String taskName = taskName0;
        IgniteInternalFuture rdrFut = null;
        ReaderArguments readerArgs = null;
        if (this.addRdr && !this.skipVals && !this.cctx.localNodeId().equals(this.reader)) {
            while (true) {
                GridDhtCacheEntry e = this.cache().entryExx(this.key, this.topVer);
                try {
                    boolean addReader;
                    if (e.obsolete()) continue;
                    boolean bl = addReader = !e.deleted();
                    if (addReader) {
                        e.unswap(false);
                        if (readerArgs == null) {
                            readerArgs = new ReaderArguments(this.reader, this.msgId, this.topVer);
                        }
                    }
                    rdrFut = addReader ? e.addReader(this.reader, this.msgId, this.topVer) : null;
                }
                catch (IgniteCheckedException err) {
                    this.onDone(err);
                    return;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Got removed entry when getting a DHT value: " + e);
                    continue;
                }
                finally {
                    e.touch(this.topVer);
                    continue;
                }
                break;
            }
        }
        if (rdrFut != null && !rdrFut.isDone()) {
            final ReaderArguments args = readerArgs;
            rdrFut.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    Throwable e = fut.error();
                    if (e != null) {
                        GridDhtGetSingleFuture.this.onDone(e);
                        return;
                    }
                    IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> fut0 = GridDhtGetSingleFuture.this.cache().getDhtAllAsync(Collections.singleton(GridDhtGetSingleFuture.this.key), args, GridDhtGetSingleFuture.this.readThrough, GridDhtGetSingleFuture.this.subjId, taskName, GridDhtGetSingleFuture.this.expiryPlc, GridDhtGetSingleFuture.this.skipVals, GridDhtGetSingleFuture.this.recovery, GridDhtGetSingleFuture.this.mvccSnapshot);
                    fut0.listen(GridDhtGetSingleFuture.this.createGetFutureListener());
                }
            });
            return;
        }
        IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> fut = this.cache().getDhtAllAsync(Collections.singleton(this.key), readerArgs, this.readThrough, this.subjId, taskName, this.expiryPlc, this.skipVals, this.recovery, this.mvccSnapshot);
        if (fut.isDone()) {
            this.onResult(fut);
        } else {
            fut.listen(this.createGetFutureListener());
        }
    }

    @NotNull
    private IgniteInClosure<IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>>> createGetFutureListener() {
        return new IgniteInClosure<IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>>>(){

            @Override
            public void apply(IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> fut) {
                GridDhtGetSingleFuture.this.onResult(fut);
            }
        };
    }

    private void onResult(IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> fut) {
        block5: {
            assert (fut.isDone());
            if (fut.error() != null) {
                this.onDone(fut.error());
            } else {
                try {
                    this.onDone(this.toEntryInfo(fut.get()));
                }
                catch (IgniteCheckedException ignored) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
    }

    private GridCacheEntryInfo toEntryInfo(Map<KeyCacheObject, EntryGetResult> map) {
        if (map.isEmpty()) {
            return null;
        }
        EntryGetResult val = map.get(this.key);
        assert (val != null);
        GridCacheEntryInfo info = new GridCacheEntryInfo();
        info.cacheId(this.cctx.cacheId());
        info.key(this.key);
        info.value(this.skipVals ? null : (CacheObject)val.value());
        info.version(val.version());
        info.expireTime(val.expireTime());
        info.ttl(val.ttl());
        return info;
    }

    private GridDhtCacheAdapter<K, V> cache() {
        return (GridDhtCacheAdapter)this.cctx.cache();
    }
}

