/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentResponse;
import org.apache.ignite.internal.util.GridBoundedLinkedHashSet;
import org.apache.ignite.internal.util.GridByteArrayList;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

class GridDeploymentClassLoader
extends ClassLoader
implements GridDeploymentInfo {
    private final IgniteUuid id;
    private final boolean singleNode;
    @GridToStringExclude
    private final GridKernalContext ctx;
    @GridToStringExclude
    private final IgniteLogger log;
    @GridToStringExclude
    private LinkedList<UUID> nodeList;
    @GridToStringInclude
    private Map<UUID, IgniteUuid> nodeLdrMap;
    @GridToStringExclude
    private final GridDeploymentCommunication comm;
    private final String[] p2pExclude;
    private final long p2pTimeout;
    @GridToStringExclude
    private final GridBoundedLinkedHashSet<String> missedRsrcs;
    @GridToStringExclude
    private final ConcurrentMap<String, byte[]> byteMap;
    private final String usrVer;
    private final DeploymentMode depMode;
    private boolean quiet;
    private final Object mux = new Object();

    GridDeploymentClassLoader(IgniteUuid id, String usrVer, DeploymentMode depMode, boolean singleNode, GridKernalContext ctx, ClassLoader parent, IgniteUuid clsLdrId, UUID nodeId, GridDeploymentCommunication comm, long p2pTimeout, IgniteLogger log, String[] p2pExclude, int missedResourcesCacheSize, boolean clsBytesCacheEnabled, boolean quiet) throws SecurityException {
        super(parent);
        assert (id != null);
        assert (depMode != null);
        assert (ctx != null);
        assert (comm != null);
        assert (p2pTimeout > 0L);
        assert (log != null);
        assert (clsLdrId != null);
        assert (nodeId.equals(clsLdrId.globalId()));
        this.id = id;
        this.usrVer = usrVer;
        this.depMode = depMode;
        this.singleNode = singleNode;
        this.ctx = ctx;
        this.comm = comm;
        this.p2pTimeout = p2pTimeout;
        this.log = log;
        this.p2pExclude = p2pExclude;
        this.nodeList = new LinkedList();
        this.nodeList.add(nodeId);
        HashMap<UUID, IgniteUuid> map = U.newHashMap(1);
        map.put(nodeId, clsLdrId);
        this.nodeLdrMap = singleNode ? Collections.unmodifiableMap(map) : map;
        this.missedRsrcs = missedResourcesCacheSize > 0 ? new GridBoundedLinkedHashSet(missedResourcesCacheSize) : null;
        this.byteMap = clsBytesCacheEnabled ? new ConcurrentHashMap() : null;
        this.quiet = quiet;
    }

    GridDeploymentClassLoader(IgniteUuid id, String usrVer, DeploymentMode depMode, boolean singleNode, GridKernalContext ctx, ClassLoader parent, Map<UUID, IgniteUuid> participants, GridDeploymentCommunication comm, long p2pTimeout, IgniteLogger log, String[] p2pExclude, int missedResourcesCacheSize, boolean clsBytesCacheEnabled, boolean quiet) throws SecurityException {
        super(parent);
        assert (id != null);
        assert (depMode != null);
        assert (ctx != null);
        assert (comm != null);
        assert (p2pTimeout > 0L);
        assert (log != null);
        assert (participants != null);
        this.id = id;
        this.usrVer = usrVer;
        this.depMode = depMode;
        this.singleNode = singleNode;
        this.ctx = ctx;
        this.comm = comm;
        this.p2pTimeout = p2pTimeout;
        this.log = log;
        this.p2pExclude = p2pExclude;
        this.nodeList = new LinkedList<UUID>(participants.keySet());
        this.nodeLdrMap = new HashMap<UUID, IgniteUuid>(participants);
        this.missedRsrcs = missedResourcesCacheSize > 0 ? new GridBoundedLinkedHashSet(missedResourcesCacheSize) : null;
        this.byteMap = clsBytesCacheEnabled ? new ConcurrentHashMap() : null;
        this.quiet = quiet;
    }

    @Override
    public IgniteUuid classLoaderId() {
        return this.id;
    }

    @Override
    public DeploymentMode deployMode() {
        return this.depMode;
    }

    @Override
    public String userVersion() {
        return this.usrVer;
    }

    @Override
    public boolean localDeploymentOwner() {
        return false;
    }

    @Override
    public long sequenceNumber() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, IgniteUuid> participants() {
        Object object = this.mux;
        synchronized (object) {
            return new HashMap<UUID, IgniteUuid>(this.nodeLdrMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(UUID nodeId, IgniteUuid ldrId) {
        assert (nodeId != null);
        assert (ldrId != null);
        assert (nodeId.equals(ldrId.globalId()));
        assert (!this.singleNode);
        Object object = this.mux;
        synchronized (object) {
            if (this.missedRsrcs != null) {
                this.missedRsrcs.clear();
            }
            this.nodeList.remove(nodeId);
            this.nodeList.addFirst(nodeId);
            this.nodeLdrMap.put(nodeId, ldrId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IgniteUuid unregister(UUID nodeId) {
        assert (nodeId != null);
        Object object = this.mux;
        synchronized (object) {
            this.nodeList.remove(nodeId);
            return this.nodeLdrMap.remove(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<UUID> registeredNodeIds() {
        Object object = this.mux;
        synchronized (object) {
            return new ArrayList<UUID>(this.nodeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<IgniteUuid> registeredClassLoaderIds() {
        LinkedList<IgniteUuid> ldrIds = new LinkedList<IgniteUuid>();
        Object object = this.mux;
        synchronized (object) {
            for (IgniteUuid ldrId : this.nodeLdrMap.values()) {
                ldrIds.add(ldrId);
            }
        }
        return ldrIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgniteUuid registeredClassLoaderId(UUID nodeId) {
        Object object = this.mux;
        synchronized (object) {
            return this.nodeLdrMap.get(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRegisteredNode(UUID nodeId, IgniteUuid ldrId) {
        IgniteUuid ldrId0;
        assert (nodeId != null);
        assert (ldrId != null);
        Object object = this.mux;
        synchronized (object) {
            ldrId0 = this.nodeLdrMap.get(nodeId);
        }
        return ldrId0 != null && ldrId0.equals(ldrId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRegisteredNodes() {
        Object object = this.mux;
        synchronized (object) {
            return !this.nodeList.isEmpty();
        }
    }

    private boolean isLocallyExcluded(String name) {
        if (this.p2pExclude != null) {
            for (String path : this.p2pExclude) {
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!name.startsWith(path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        assert (!Thread.holdsLock(this.mux));
        Class<?> cls = null;
        try {
            if (!"org.apache.ignite.compute.ComputeJob".equals(name) && this.isLocallyExcluded(name)) {
                cls = this.p2pLoadClass(name, true);
            }
            if (cls == null) {
                cls = this.loadClass(name, true);
            }
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Failed to load class due to unexpected error: " + name, e);
        }
        return cls;
    }

    @Nullable
    private Class<?> p2pLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        assert (!Thread.holdsLock(this.mux));
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            cls = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        GridDeployment dep;
        assert (!Thread.holdsLock(this.mux));
        if (!this.isLocallyExcluded(name) && (dep = this.ctx.deploy().getLocalDeployment(name)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found class in local deployment [cls=" + name + ", dep=" + dep + ']');
            }
            return dep.deployedClass(name, new String[0]);
        }
        String path = U.classNameToResourceName(name);
        GridByteArrayList byteSrc = this.sendClassRequest(name, path);
        GridDeploymentClassLoader gridDeploymentClassLoader = this;
        synchronized (gridDeploymentClassLoader) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                String pkgName;
                if (this.byteMap != null) {
                    this.byteMap.put(path, byteSrc.array());
                }
                cls = this.defineClass(name, byteSrc.internalArray(), 0, byteSrc.size());
                int i = name.lastIndexOf(46);
                if (i != -1 && this.getPackage(pkgName = name.substring(0, i)) == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loaded class [cls=" + name + ", ldr=" + this + ']');
            }
            return cls;
        }
    }

    private long computeEndTime(long timeout) {
        long endTime = U.currentTimeMillis() + timeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        return endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridByteArrayList sendClassRequest(String name, String path) throws ClassNotFoundException {
        HashMap<UUID, IgniteUuid> nodeLdrMapCp;
        LinkedList<UUID> nodeListCp;
        assert (!Thread.holdsLock(this.mux));
        long endTime = this.computeEndTime(this.p2pTimeout);
        Object object = this.mux;
        synchronized (object) {
            if (this.missedRsrcs != null && this.missedRsrcs.contains(path)) {
                throw new ClassNotFoundException("Failed to peer load class [class=" + name + ", nodeClsLdrIds=" + this.nodeLdrMap + ", parentClsLoader=" + this.getParent() + ']');
            }
            nodeListCp = this.singleNode ? this.nodeList : new LinkedList<UUID>(this.nodeList);
            nodeLdrMapCp = this.singleNode ? this.nodeLdrMap : new HashMap<UUID, IgniteUuid>(this.nodeLdrMap);
        }
        IgniteCheckedException err = null;
        for (UUID nodeId : nodeListCp) {
            if (nodeId.equals(this.ctx.discovery().localNode().id())) continue;
            IgniteUuid ldrId = (IgniteUuid)nodeLdrMapCp.get(nodeId);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Found inactive node in class loader (will skip): " + nodeId);
                continue;
            }
            try {
                GridDeploymentResponse res = this.comm.sendResourceRequest(path, ldrId, node, endTime);
                if (res == null) {
                    String msg = "Failed to send class-loading request to node (is node alive?) [node=" + node.id() + ", clsName=" + name + ", clsPath=" + path + ", clsLdrId=" + ldrId + ", parentClsLdr=" + this.getParent() + ']';
                    if (!this.quiet) {
                        U.warn(this.log, msg);
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug(msg);
                    }
                    err = new IgniteCheckedException(msg);
                    continue;
                }
                if (res.success()) {
                    return res.byteSource();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to find class on remote node [class=" + name + ", nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", reason=" + res.errorMessage() + ']');
                }
                Object object2 = this.mux;
                synchronized (object2) {
                    if (this.missedRsrcs != null) {
                        this.missedRsrcs.add(path);
                    }
                }
                throw new ClassNotFoundException("Failed to peer load class [class=" + name + ", nodeClsLdrs=" + nodeLdrMapCp + ", parentClsLoader=" + this.getParent() + ", reason=" + res.errorMessage() + ']');
            }
            catch (IgniteCheckedException e) {
                if (Thread.currentThread().isInterrupted()) {
                    if (!this.quiet) {
                        U.error(this.log, "Failed to find class probably due to task/job cancellation: " + name, e);
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to find class probably due to task/job cancellation [name=" + name + ", err=" + e + ']');
                    continue;
                }
                if (!this.quiet) {
                    U.warn(this.log, "Failed to send class-loading request to node (is node alive?) [node=" + node.id() + ", clsName=" + name + ", clsPath=" + path + ", clsLdrId=" + ldrId + ", parentClsLdr=" + this.getParent() + ", err=" + e + ']');
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send class-loading request to node (is node alive?) [node=" + node.id() + ", clsName=" + name + ", clsPath=" + path + ", clsLdrId=" + ldrId + ", parentClsLdr=" + this.getParent() + ", err=" + e + ']');
                }
                err = e;
            }
        }
        throw new ClassNotFoundException("Failed to peer load class [class=" + name + ", nodeClsLdrs=" + nodeLdrMapCp + ", parentClsLoader=" + this.getParent() + ']', err);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        byte[] bytes;
        assert (!Thread.holdsLock(this.mux));
        if (this.byteMap != null && name.endsWith(".class") && (bytes = (byte[])this.byteMap.get(name)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got class definition from byte code cache: " + name);
            }
            return new ByteArrayInputStream(bytes);
        }
        InputStream in = ClassLoader.getSystemResourceAsStream(name);
        if (in == null) {
            in = super.getResourceAsStream(name);
        }
        if ("META-INF/services/org.apache.commons.logging.LogFactory".equalsIgnoreCase(name)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Denied sending remote request for META-INF/services/org.apache.commons.logging.LogFactory.");
            }
            return null;
        }
        if (in == null) {
            in = this.sendResourceRequest(name);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private InputStream sendResourceRequest(String name) {
        HashMap<UUID, IgniteUuid> nodeLdrMapCp;
        LinkedList<UUID> nodeListCp;
        assert (!Thread.holdsLock(this.mux));
        long endTime = this.computeEndTime(this.p2pTimeout);
        Iterator iterator = this.mux;
        synchronized (iterator) {
            if (this.missedRsrcs != null && this.missedRsrcs.contains(name)) {
                return null;
            }
            nodeListCp = this.singleNode ? this.nodeList : new LinkedList<UUID>(this.nodeList);
            nodeLdrMapCp = this.singleNode ? this.nodeLdrMap : new HashMap<UUID, IgniteUuid>(this.nodeLdrMap);
        }
        for (UUID nodeId : nodeListCp) {
            if (nodeId.equals(this.ctx.discovery().localNode().id())) continue;
            IgniteUuid ldrId = (IgniteUuid)nodeLdrMapCp.get(nodeId);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Found inactive node in class loader (will skip): " + nodeId);
                continue;
            }
            try {
                GridDeploymentResponse res = this.comm.sendResourceRequest(name, ldrId, node, endTime);
                if (res == null) {
                    U.warn(this.log, "Failed to get resource from node (is node alive?) [nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", resName=" + name + ", parentClsLdr=" + this.getParent() + ']');
                    continue;
                }
                if (!res.success()) {
                    Object object = this.mux;
                    synchronized (object) {
                        if (this.missedRsrcs != null) {
                            this.missedRsrcs.add(name);
                        }
                    }
                    if (!this.quiet) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Failed to get resource from node [nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", resName=" + name + ", parentClsLdr=" + this.getParent() + ", msg=" + res.errorMessage() + ']');
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to get resource from node [nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", resName=" + name + ", parentClsLdr=" + this.getParent() + ", msg=" + res.errorMessage() + ']');
                    }
                    return null;
                }
                return new ByteArrayInputStream(res.byteSource().internalArray(), 0, res.byteSource().size());
            }
            catch (IgniteCheckedException e) {
                if (Thread.currentThread().isInterrupted()) {
                    if (!this.quiet) {
                        U.error(this.log, "Failed to get resource probably due to task/job cancellation: " + name, e);
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to get resource probably due to task/job cancellation: " + name);
                    continue;
                }
                if (!this.quiet) {
                    U.warn(this.log, "Failed to get resource from node (is node alive?) [nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", resName=" + name + ", parentClsLdr=" + this.getParent() + ", err=" + e + ']');
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to get resource from node (is node alive?) [nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", resName=" + name + ", parentClsLdr=" + this.getParent() + ", err=" + e + ']');
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mux;
        synchronized (object) {
            return S.toString(GridDeploymentClassLoader.class, this);
        }
    }
}

