/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheKeyConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String typeName;
    private String affKeyFieldName;

    public CacheKeyConfiguration() {
    }

    public CacheKeyConfiguration(Class keyCls) {
        this.typeName = keyCls.getName();
        while (keyCls != Object.class && keyCls != null) {
            for (Field f : keyCls.getDeclaredFields()) {
                if (f.getAnnotation(AffinityKeyMapped.class) == null) continue;
                this.affKeyFieldName = f.getName();
                return;
            }
            keyCls = keyCls.getSuperclass();
        }
    }

    public CacheKeyConfiguration(String typeName, String affKeyFieldName) {
        this.typeName = typeName;
        this.affKeyFieldName = affKeyFieldName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public CacheKeyConfiguration setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getAffinityKeyFieldName() {
        return this.affKeyFieldName;
    }

    public CacheKeyConfiguration setAffinityKeyFieldName(String affKeyFieldName) {
        this.affKeyFieldName = affKeyFieldName;
        return this;
    }

    public String toString() {
        return S.toString(CacheKeyConfiguration.class, this);
    }
}

