/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;

public class GridRedisProtocolParser {
    private static final byte SIMPLE_STRING = 43;
    private static final byte BULK_STRING = 36;
    private static final byte INTEGER = 58;
    static final byte ARRAY = 42;
    private static final byte ERROR = 45;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] ERR_GENERIC = "ERR ".getBytes();
    private static final byte[] ERR_TYPE = "WRONGTYPE ".getBytes();
    private static final byte[] ERR_AUTH = "NOAUTH ".getBytes();
    private static final byte[] NIL = "$-1\r\n".getBytes();
    private static final byte[] OK = "OK".getBytes();

    public static GridRedisMessage readArray(ByteBuffer buf) throws IgniteCheckedException {
        byte b = buf.get();
        if (b != 42) {
            throw new IgniteCheckedException("Invalid request byte! " + b);
        }
        int arrLen = GridRedisProtocolParser.elCnt(buf);
        GridRedisMessage msg = new GridRedisMessage(arrLen);
        for (int i = 0; i < arrLen; ++i) {
            msg.append(GridRedisProtocolParser.readBulkStr(buf));
        }
        return msg;
    }

    public static String readBulkStr(ByteBuffer buf) throws IgniteCheckedException {
        byte b = buf.get();
        if (b != 36) {
            throw new IgniteCheckedException("Invalid bulk string prefix! " + b);
        }
        int len = GridRedisProtocolParser.elCnt(buf);
        byte[] bulkStr = new byte[len];
        buf.get(bulkStr, 0, len);
        if (buf.get() != 13 || buf.get() != 10) {
            throw new IgniteCheckedException("Invalid request syntax!");
        }
        return new String(bulkStr);
    }

    private static int elCnt(ByteBuffer buf) throws IgniteCheckedException {
        byte[] arrLen = new byte[9];
        int idx = 0;
        byte b = buf.get();
        while (b != 13) {
            arrLen[idx++] = b;
            b = buf.get();
        }
        if (buf.get() != 10) {
            throw new IgniteCheckedException("Invalid request syntax!");
        }
        return Integer.parseInt(new String(arrLen, 0, idx));
    }

    public static ByteBuffer toSimpleString(String val) {
        byte[] b = val.getBytes();
        return GridRedisProtocolParser.toSimpleString(b);
    }

    public static ByteBuffer toSimpleString(byte[] b) {
        ByteBuffer buf = ByteBuffer.allocate(b.length + 3);
        buf.put((byte)43);
        buf.put(b);
        buf.put(CRLF);
        buf.flip();
        return buf;
    }

    public static ByteBuffer oKString() {
        return GridRedisProtocolParser.toSimpleString(OK);
    }

    public static ByteBuffer toGenericError(String errMsg) {
        return GridRedisProtocolParser.toError(errMsg, ERR_GENERIC);
    }

    public static ByteBuffer toTypeError(String errMsg) {
        return GridRedisProtocolParser.toError(errMsg, ERR_TYPE);
    }

    private static ByteBuffer toError(String errMsg, byte[] errPrefix) {
        byte[] b = errMsg.getBytes();
        ByteBuffer buf = ByteBuffer.allocate(b.length + errPrefix.length + 3);
        buf.put((byte)45);
        buf.put(errPrefix);
        buf.put(b);
        buf.put(CRLF);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toInteger(String integer) {
        byte[] b = integer.getBytes();
        ByteBuffer buf = ByteBuffer.allocate(b.length + 3);
        buf.put((byte)58);
        buf.put(b);
        buf.put(CRLF);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toInteger(int integer) {
        return GridRedisProtocolParser.toInteger(String.valueOf(integer));
    }

    public static ByteBuffer nil() {
        ByteBuffer buf = ByteBuffer.allocate(NIL.length);
        buf.put(NIL);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toBulkString(Object val) {
        assert (val != null);
        byte[] b = String.valueOf(val).getBytes();
        byte[] l = String.valueOf(b.length).getBytes();
        ByteBuffer buf = ByteBuffer.allocate(b.length + l.length + 5);
        buf.put((byte)36);
        buf.put(l);
        buf.put(CRLF);
        buf.put(b);
        buf.put(CRLF);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toArray(Map<Object, Object> vals) {
        return GridRedisProtocolParser.toArray(vals.values());
    }

    public static ByteBuffer toOrderedArray(Map<Object, Object> vals, List<?> origin) {
        assert (vals != null) : "The resulting map is null.";
        assert (origin != null) : "The origin list is null.";
        int capacity = 0;
        ArrayList<ByteBuffer> res = new ArrayList<ByteBuffer>();
        for (Object o2 : origin) {
            Object val = vals.get(o2);
            if (val == null) continue;
            ByteBuffer b = GridRedisProtocolParser.toBulkString(val);
            res.add(b);
            capacity += b.limit();
        }
        byte[] arrSize = String.valueOf(res.size()).getBytes();
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity + arrSize.length + 1 + CRLF.length);
        buf.put((byte)42);
        buf.put(arrSize);
        buf.put(CRLF);
        res.forEach(o -> buf.put((ByteBuffer)o));
        buf.flip();
        return buf;
    }

    public static ByteBuffer toArray(Collection<Object> vals) {
        assert (vals != null);
        byte[] arrSize = String.valueOf(vals.size()).getBytes();
        ByteBuffer buf = ByteBuffer.allocateDirect(0x100000);
        buf.put((byte)42);
        buf.put(arrSize);
        buf.put(CRLF);
        for (Object val : vals) {
            buf.put(GridRedisProtocolParser.toBulkString(val));
        }
        buf.flip();
        return buf;
    }
}

