/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.processors.continuous.GridContinuousProcessor;
import org.apache.ignite.internal.util.IgniteUtils;

public class ContinuousQueryView {
    private final GridContinuousProcessor.RoutineInfo qry;
    private final GridContinuousHandler hnd;
    private final UUID routineId;

    public ContinuousQueryView(UUID routineId, GridContinuousProcessor.RoutineInfo qry) {
        this.qry = qry;
        this.hnd = qry.handler();
        this.routineId = routineId;
    }

    public UUID routineId() {
        return this.routineId;
    }

    public UUID nodeId() {
        return this.qry.nodeId();
    }

    @Order
    public String cacheName() {
        return this.hnd.cacheName();
    }

    public String topic() {
        return IgniteUtils.toStringSafe(this.hnd.orderedTopic());
    }

    public int bufferSize() {
        return this.qry.bufferSize();
    }

    public long interval() {
        return this.qry.interval();
    }

    public boolean autoUnsubscribe() {
        return this.qry.autoUnsubscribe();
    }

    public boolean isEvents() {
        return this.hnd.isEvents();
    }

    public boolean isMessaging() {
        return this.hnd.isMessaging();
    }

    public boolean isQuery() {
        return this.hnd.isQuery();
    }

    public boolean keepBinary() {
        return this.hnd.keepBinary();
    }

    public boolean notifyExisting() {
        CacheContinuousQueryHandler hnd0 = this.cacheHandler();
        return hnd0 != null && hnd0.notifyExisting();
    }

    public boolean oldValueRequired() {
        CacheContinuousQueryHandler hnd0 = this.cacheHandler();
        return hnd0 != null && hnd0.oldValueRequired();
    }

    @Order(value=5)
    public long lastSendTime() {
        return this.qry.lastSendTime();
    }

    public boolean delayedRegister() {
        return this.qry.delayedRegister();
    }

    @Order(value=1)
    public String localListener() {
        CacheContinuousQueryHandler hnd0 = this.cacheHandler();
        if (hnd0 == null || hnd0.localListener() == null) {
            return null;
        }
        return IgniteUtils.toStringSafe(hnd0.localListener());
    }

    @Order(value=2)
    public String remoteFilter() {
        CacheContinuousQueryHandler hnd0 = this.cacheHandler();
        try {
            if (hnd0 == null || hnd0.getEventFilter() == null) {
                return null;
            }
            return IgniteUtils.toStringSafe(hnd0.getEventFilter());
        }
        catch (IgniteCheckedException e) {
            return null;
        }
    }

    @Order(value=3)
    public String remoteTransformer() {
        CacheContinuousQueryHandler hnd0 = this.cacheHandler();
        if (hnd0 == null || hnd0.getTransformer() == null) {
            return null;
        }
        return IgniteUtils.toStringSafe(hnd0.getTransformer());
    }

    @Order(value=4)
    public String localTransformedListener() {
        CacheContinuousQueryHandler hnd0 = this.cacheHandler();
        if (hnd0 == null || hnd0.localTransformedEventListener() == null) {
            return null;
        }
        return IgniteUtils.toStringSafe(hnd0.localTransformedEventListener());
    }

    private CacheContinuousQueryHandler cacheHandler() {
        if (!(this.hnd instanceof CacheContinuousQueryHandler)) {
            return null;
        }
        return (CacheContinuousQueryHandler)this.hnd;
    }
}

