/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.io.GridDataOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridUnsafeDataOutput
extends OutputStream
implements GridDataOutput {
    private static final int MAX_BYTE_ARRAY_SIZE = 0x7FFFFFF7;
    private static final long CHECK_FREQ = Long.getLong("IGNITE_MARSHAL_BUFFERS_RECHECK", 10000L);
    private static final int CHAR_BUF_SIZE = 256;
    private final char[] cbuf = new char[256];
    private byte[] bytes;
    private int off;
    private OutputStream out;
    private int maxOff;
    private long lastCheck = U.currentTimeMillis();

    public GridUnsafeDataOutput() {
    }

    public GridUnsafeDataOutput(int size) {
        this.bytes = new byte[size];
    }

    public void bytes(byte[] bytes, int off) {
        this.bytes = bytes;
        this.off = off;
    }

    @Override
    public void outputStream(OutputStream out) {
        this.out = out;
        this.off = 0;
    }

    @Override
    public byte[] array() {
        byte[] bytes0 = new byte[this.off];
        System.arraycopy(this.bytes, 0, bytes0, 0, this.off);
        return bytes0;
    }

    @Override
    public byte[] internalArray() {
        return this.bytes;
    }

    @Override
    public int offset() {
        return this.off;
    }

    @Override
    public void offset(int off) {
        this.off = off;
    }

    private void requestFreeSize(int size) throws IOException {
        if (!this.canBeAllocated(this.off + size)) {
            throw new IOException("Failed to allocate required memory (byte array size overflow detected) [length=" + size + ", offset=" + this.off + ']');
        }
        size = this.off + size;
        this.maxOff = Math.max(this.maxOff, size);
        long now = U.currentTimeMillis();
        if (size > this.bytes.length) {
            int newSize = size << 1;
            if (!this.canBeAllocated(newSize)) {
                newSize = 0x7FFFFFF7;
            }
            this.bytes = Arrays.copyOf(this.bytes, newSize);
        } else if (now - this.lastCheck > CHECK_FREQ) {
            int halfSize = this.bytes.length >> 1;
            if (this.maxOff < halfSize) {
                this.bytes = Arrays.copyOf(this.bytes, halfSize);
            }
            this.maxOff = 0;
            this.lastCheck = now;
        }
    }

    private boolean canBeAllocated(long size) {
        return 0L <= size && size <= 0x7FFFFFF7L;
    }

    private void onWrite(int size) throws IOException {
        if (this.out != null) {
            this.out.write(this.bytes, 0, size);
        } else {
            this.off += size;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.requestFreeSize(b.length);
        System.arraycopy(b, 0, this.bytes, this.off, b.length);
        this.onWrite(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.requestFreeSize(len);
        System.arraycopy(b, off, this.bytes, this.off, len);
        this.onWrite(len);
    }

    @Override
    public void writeDoubleArray(double[] arr) throws IOException {
        this.writeInt(arr.length);
        this.checkArrayAllocationOverflow(8, arr.length, "double");
        int bytesToCp = arr.length << 3;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (double val : arr) {
                GridUnsafe.putDoubleLE(this.bytes, off, val);
                off += 8L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.DOUBLE_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeBooleanArray(boolean[] arr) throws IOException {
        this.writeInt(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            this.writeBoolean(arr[i]);
        }
    }

    @Override
    public void writeCharArray(char[] arr) throws IOException {
        this.writeInt(arr.length);
        this.checkArrayAllocationOverflow(2, arr.length, "char");
        int bytesToCp = arr.length << 1;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (char val : arr) {
                GridUnsafe.putCharLE(this.bytes, off, val);
                off += 2L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.CHAR_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeLongArray(long[] arr) throws IOException {
        this.writeInt(arr.length);
        this.checkArrayAllocationOverflow(8, arr.length, "long");
        int bytesToCp = arr.length << 3;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (long val : arr) {
                GridUnsafe.putLongLE(this.bytes, off, val);
                off += 8L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.LONG_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeFloatArray(float[] arr) throws IOException {
        this.writeInt(arr.length);
        this.checkArrayAllocationOverflow(4, arr.length, "float");
        int bytesToCp = arr.length << 2;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (float val : arr) {
                GridUnsafe.putFloatLE(this.bytes, off, val);
                off += 4L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.FLOAT_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void reset() {
        this.off = 0;
        this.out = null;
    }

    @Override
    public void writeByteArray(byte[] arr) throws IOException {
        this.writeInt(arr.length);
        this.requestFreeSize(arr.length);
        System.arraycopy(arr, 0, this.bytes, this.off, arr.length);
        this.onWrite(arr.length);
    }

    @Override
    public void writeShortArray(short[] arr) throws IOException {
        this.writeInt(arr.length);
        this.checkArrayAllocationOverflow(2, arr.length, "short");
        int bytesToCp = arr.length << 1;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (short val : arr) {
                GridUnsafe.putShortLE(this.bytes, off, val);
                off += 2L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.SHORT_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeIntArray(int[] arr) throws IOException {
        this.writeInt(arr.length);
        this.checkArrayAllocationOverflow(4, arr.length, "int");
        int bytesToCp = arr.length << 2;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (int val : arr) {
                GridUnsafe.putIntLE(this.bytes, off, val);
                off += 4L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.INT_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.requestFreeSize(1);
        GridUnsafe.putBoolean(this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, v);
        this.onWrite(1);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.requestFreeSize(1);
        GridUnsafe.putByte(this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, (byte)v);
        this.onWrite(1);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.requestFreeSize(2);
        short val = (short)v;
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(this.bytes, off, val);
        } else {
            GridUnsafe.putShort(this.bytes, off, val);
        }
        this.onWrite(2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.requestFreeSize(2);
        char val = (char)v;
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putCharLE(this.bytes, off, val);
        } else {
            GridUnsafe.putChar(this.bytes, off, val);
        }
        this.onWrite(2);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.requestFreeSize(4);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(this.bytes, off, v);
        } else {
            GridUnsafe.putInt(this.bytes, off, v);
        }
        this.onWrite(4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.requestFreeSize(8);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putLongLE(this.bytes, off, v);
        } else {
            GridUnsafe.putLong(this.bytes, off, v);
        }
        this.onWrite(8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int val = Float.floatToIntBits(v);
        this.writeInt(val);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long val = Double.doubleToLongBits(v);
        this.writeLong(val);
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.writeUTF(s, this.utfLength(s));
    }

    private void checkArrayAllocationOverflow(int bytes, int arrLen, String type) throws IOException {
        long bytesToAlloc = (long)arrLen * (long)bytes;
        if (!this.canBeAllocated(bytesToAlloc)) {
            throw new IOException("Failed to allocate required memory for " + type + " array (byte array size overflow detected) [length=" + arrLen + ']');
        }
    }

    private int utfLength(String s) {
        int size;
        int len = s.length();
        int utfLen = 0;
        for (int off = 0; off < len; off += size) {
            size = Math.min(len - off, 256);
            s.getChars(off, off + size, this.cbuf, 0);
            for (int pos = 0; pos < size; ++pos) {
                char c = this.cbuf[pos];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utfLen;
                    continue;
                }
                utfLen += c > '\u07ff' ? 3 : 2;
            }
        }
        return utfLen;
    }

    private void writeUTF(String s, int utfLen) throws IOException {
        if (utfLen == s.length()) {
            this.writeBytes(s);
        } else {
            this.writeInt(utfLen);
            this.writeUTFBody(s);
        }
    }

    private void writeUTFBody(String s) throws IOException {
        int csize;
        int len = s.length();
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, 256);
            s.getChars(off, off + csize, this.cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = this.cbuf[cpos];
                if (c <= '\u007f' && c != '\u0000') {
                    this.write(c);
                    continue;
                }
                if (c > '\u07ff') {
                    this.write(0xE0 | c >> 12 & 0xF);
                    this.write(0x80 | c >> 6 & 0x3F);
                    this.write(0x80 | c & 0x3F);
                    continue;
                }
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c & 0x3F);
            }
        }
    }

    public String toString() {
        return S.toString(GridUnsafeDataOutput.class, this);
    }
}

