/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearAtomicAbstractUpdateRequest
extends GridCacheIdMessage
implements GridCacheDeployable {
    public static final int CACHE_MSG_IDX = GridNearAtomicAbstractUpdateRequest.nextIndexId();
    private static final int NEED_PRIMARY_RES_FLAG_MASK = 1;
    private static final int TOP_LOCKED_FLAG_MASK = 2;
    private static final int SKIP_STORE_FLAG_MASK = 4;
    private static final int KEEP_BINARY_FLAG_MASK = 8;
    private static final int RET_VAL_FLAG_MASK = 16;
    private static final int RECOVERY_FLAG_MASK = 32;
    private static final int NEAR_CACHE_FLAG_MASK = 64;
    private static final int AFFINITY_MAPPING_FLAG_MASK = 128;
    @GridDirectTransient
    protected UUID nodeId;
    protected long futId;
    protected AffinityTopologyVersion topVer;
    protected CacheWriteSynchronizationMode syncMode;
    protected GridCacheOperation op;
    protected UUID subjId;
    protected int taskNameHash;
    @GridToStringExclude
    protected byte flags;
    @GridDirectTransient
    private GridNearAtomicUpdateResponse res;

    public GridNearAtomicAbstractUpdateRequest() {
    }

    protected GridNearAtomicAbstractUpdateRequest(int cacheId, UUID nodeId, long futId, @NotNull AffinityTopologyVersion topVer, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, @Nullable UUID subjId, int taskNameHash, byte flags, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.futId = futId;
        this.topVer = topVer;
        this.syncMode = syncMode;
        this.op = op;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.flags = flags;
        this.addDepInfo = addDepInfo;
    }

    static byte flags(boolean nearCache, boolean topLocked, boolean retval, boolean affMapping, boolean needPrimaryRes, boolean skipStore, boolean keepBinary, boolean recovery) {
        byte flags = 0;
        if (nearCache) {
            flags = (byte)(flags | 0x40);
        }
        if (topLocked) {
            flags = (byte)(flags | 2);
        }
        if (retval) {
            flags = (byte)(flags | 0x10);
        }
        if (affMapping) {
            flags = (byte)(flags | 0x80);
        }
        if (needPrimaryRes) {
            flags = (byte)(flags | 1);
        }
        if (skipStore) {
            flags = (byte)(flags | 4);
        }
        if (keepBinary) {
            flags = (byte)(flags | 8);
        }
        if (recovery) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    boolean affinityMapping() {
        return this.isFlag(128);
    }

    public boolean nearCache() {
        return this.isFlag(64);
    }

    @Override
    public final AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public final int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    @Override
    public final boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public final IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    boolean initMappingLocally() {
        return !this.needPrimaryResponse() && this.fullSync();
    }

    boolean needPrimaryResponse() {
        return this.isFlag(1);
    }

    void needPrimaryResponse(boolean needRes) {
        this.setFlag(needRes, 1);
    }

    boolean fullSync() {
        assert (this.syncMode != null);
        return this.syncMode == CacheWriteSynchronizationMode.FULL_SYNC;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public GridCacheOperation operation() {
        return this.op;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long futureId() {
        return this.futId;
    }

    public final CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.syncMode;
    }

    public boolean onResponse(GridNearAtomicUpdateResponse res) {
        if (this.res == null) {
            this.res = res;
            return true;
        }
        return false;
    }

    void resetResponse() {
        this.res = null;
    }

    @Nullable
    public GridNearAtomicUpdateResponse response() {
        return this.res;
    }

    boolean nodeFailedResponse() {
        return this.res != null && this.res.nodeLeftResponse();
    }

    final boolean topologyLocked() {
        return this.isFlag(2);
    }

    private void topologyLocked(boolean val) {
        this.setFlag(val, 2);
    }

    public final boolean returnValue() {
        return this.isFlag(16);
    }

    public final void returnValue(boolean val) {
        this.setFlag(val, 16);
    }

    public final boolean skipStore() {
        return this.isFlag(4);
    }

    public void skipStore(boolean val) {
        this.setFlag(val, 4);
    }

    public final boolean keepBinary() {
        return this.isFlag(8);
    }

    public void keepBinary(boolean val) {
        this.setFlag(val, 8);
    }

    public final boolean recovery() {
        return this.isFlag(32);
    }

    public void recovery(boolean val) {
        this.setFlag(val, 32);
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public abstract ExpiryPolicy expiry();

    @Nullable
    public abstract CacheEntryPredicate[] filter();

    @Nullable
    public abstract Object[] invokeArguments();

    abstract void addUpdateEntry(KeyCacheObject var1, @Nullable Object var2, long var3, long var5, @Nullable GridCacheVersion var7);

    public abstract List<KeyCacheObject> keys();

    public abstract List<?> values();

    public abstract CacheObject value(int var1);

    public abstract EntryProcessor<Object, Object, Object> entryProcessor(int var1);

    public abstract CacheObject writeValue(int var1);

    @Nullable
    public abstract List<GridCacheVersion> conflictVersions();

    @Nullable
    public abstract GridCacheVersion conflictVersion(int var1);

    public abstract long conflictTtl(int var1);

    public abstract long conflictExpireTime(int var1);

    public abstract void cleanup(boolean var1);

    public abstract int size();

    public abstract KeyCacheObject key(int var1);

    @Override
    public byte fieldsCount() {
        return 11;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = GridCacheOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 7: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 9: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicAbstractUpdateRequest.class);
    }

    @Override
    public String toString() {
        StringBuilder flags = new StringBuilder();
        if (this.needPrimaryResponse()) {
            this.appendFlag(flags, "needRes");
        }
        if (this.topologyLocked()) {
            this.appendFlag(flags, "topLock");
        }
        if (this.skipStore()) {
            this.appendFlag(flags, "skipStore");
        }
        if (this.keepBinary()) {
            this.appendFlag(flags, "keepBinary");
        }
        if (this.returnValue()) {
            this.appendFlag(flags, "retVal");
        }
        return S.toString(GridNearAtomicAbstractUpdateRequest.class, this, "flags", (Object)flags.toString());
    }
}

