/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.configuration;

import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.commandline.configuration.VisorTracingConfigurationTaskArg;
import org.apache.ignite.internal.commandline.configuration.VisorTracingConfigurationTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorTracingConfigurationTask
extends VisorOneNodeTask<VisorTracingConfigurationTaskArg, VisorTracingConfigurationTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorTracingConfigurationJob job(VisorTracingConfigurationTaskArg arg) {
        return new VisorTracingConfigurationJob(arg, this.debug);
    }

    private static class VisorTracingConfigurationJob
    extends VisorJob<VisorTracingConfigurationTaskArg, VisorTracingConfigurationTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorTracingConfigurationJob(VisorTracingConfigurationTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        @NotNull
        protected VisorTracingConfigurationTaskResult run(VisorTracingConfigurationTaskArg arg) throws IgniteException {
            switch (arg.operation()) {
                case GET_ALL: {
                    return this.getAll(arg.scope());
                }
                case GET: {
                    return this.get(arg.scope(), arg.label());
                }
                case RESET: {
                    return this.reset(arg.scope(), arg.label());
                }
                case RESET_ALL: {
                    return this.resetAll(arg.scope());
                }
                case SET: {
                    return this.set(arg.scope(), arg.label(), arg.samplingRate(), arg.includedScopes());
                }
            }
            assert (false) : "Unexpected tracing configuration argument [arg= " + arg + ']';
            return this.getAll(null);
        }

        @NotNull
        private VisorTracingConfigurationTaskResult getAll(@Nullable Scope scope) {
            Map<TracingConfigurationCoordinates, TracingConfigurationParameters> cfg = this.ignite.tracingConfiguration().getAll(scope);
            VisorTracingConfigurationTaskResult res = new VisorTracingConfigurationTaskResult();
            for (Map.Entry<TracingConfigurationCoordinates, TracingConfigurationParameters> entry : cfg.entrySet()) {
                res.add(entry.getKey(), entry.getValue());
            }
            return res;
        }

        @NotNull
        private VisorTracingConfigurationTaskResult get(@NotNull Scope scope, @Nullable String lb) {
            TracingConfigurationCoordinates coordinates = new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build();
            TracingConfigurationParameters updatedParameters = this.ignite.tracingConfiguration().get(new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build());
            VisorTracingConfigurationTaskResult res = new VisorTracingConfigurationTaskResult();
            res.add(coordinates, updatedParameters);
            return res;
        }

        @NotNull
        private VisorTracingConfigurationTaskResult reset(@NotNull Scope scope, @Nullable String lb) {
            this.ignite.tracingConfiguration().reset(new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build());
            return this.getAll(scope);
        }

        @NotNull
        private VisorTracingConfigurationTaskResult resetAll(@Nullable Scope scope) {
            this.ignite.tracingConfiguration().resetAll(scope);
            return this.getAll(scope);
        }

        @NotNull
        private VisorTracingConfigurationTaskResult set(@NotNull Scope scope, @Nullable String lb, @Nullable Double samplingRate, @Nullable Set<Scope> includedScopes) {
            TracingConfigurationCoordinates coordinates = new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build();
            TracingConfigurationParameters.Builder parametersBuilder = new TracingConfigurationParameters.Builder();
            if (samplingRate != null) {
                parametersBuilder.withSamplingRate(samplingRate);
            }
            if (includedScopes != null) {
                parametersBuilder.withIncludedScopes(includedScopes);
            }
            this.ignite.tracingConfiguration().set(coordinates, parametersBuilder.build());
            return this.getAll(scope);
        }

        public String toString() {
            return S.toString(VisorTracingConfigurationJob.class, this);
        }
    }
}

