/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteExceptionRegistry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.node.VisorNodeSuppressedErrors;
import org.apache.ignite.internal.visor.node.VisorNodeSuppressedErrorsTaskArg;
import org.apache.ignite.internal.visor.node.VisorSuppressedError;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodeSuppressedErrorsTask
extends VisorMultiNodeTask<VisorNodeSuppressedErrorsTaskArg, Map<UUID, VisorNodeSuppressedErrors>, VisorNodeSuppressedErrors> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeSuppressedErrorsJob job(VisorNodeSuppressedErrorsTaskArg arg) {
        return new VisorNodeSuppressedErrorsJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, VisorNodeSuppressedErrors> reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, VisorNodeSuppressedErrors> taskRes = new HashMap<UUID, VisorNodeSuppressedErrors>(results.size());
        for (ComputeJobResult res : results) {
            VisorNodeSuppressedErrors jobRes = (VisorNodeSuppressedErrors)res.getData();
            taskRes.put(res.getNode().id(), jobRes);
        }
        return taskRes;
    }

    private static class VisorNodeSuppressedErrorsJob
    extends VisorJob<VisorNodeSuppressedErrorsTaskArg, VisorNodeSuppressedErrors> {
        private static final long serialVersionUID = 0L;

        private VisorNodeSuppressedErrorsJob(VisorNodeSuppressedErrorsTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorNodeSuppressedErrors run(VisorNodeSuppressedErrorsTaskArg arg) {
            Long lastOrder = arg.getOrders().get(this.ignite.localNode().id());
            long order = lastOrder != null ? lastOrder : 0L;
            List<IgniteExceptionRegistry.ExceptionInfo> errors = this.ignite.context().exceptionRegistry().getErrors(order);
            ArrayList<VisorSuppressedError> wrapped = new ArrayList<VisorSuppressedError>(errors.size());
            for (IgniteExceptionRegistry.ExceptionInfo error : errors) {
                if (error.order() > order) {
                    order = error.order();
                }
                wrapped.add(new VisorSuppressedError(error.order(), new VisorExceptionWrapper(error.error()), error.message(), error.threadId(), error.threadName(), error.time()));
            }
            return new VisorNodeSuppressedErrors(order, wrapped);
        }

        public String toString() {
            return S.toString(VisorNodeSuppressedErrorsJob.class, this);
        }
    }
}

