/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;

public class FlatIterator<T>
extends GridIteratorAdapter<T> {
    private static final long serialVersionUID = 0L;
    private Iterator<?> iter;
    private Iterator<T> next;
    private boolean moved;
    private boolean more;

    public FlatIterator(Iterable<?> iterable) {
        this.iter = iterable.iterator();
        this.moved = true;
    }

    @Override
    public boolean hasNextX() {
        if (!this.moved) {
            return this.more;
        }
        this.moved = false;
        if (this.next != null && this.next.hasNext()) {
            this.more = true;
            return true;
        }
        while (this.iter.hasNext()) {
            Object obj = this.iter.next();
            if (obj instanceof Iterable) {
                this.next = ((Iterable)obj).iterator();
            } else if (obj instanceof Iterator) {
                this.next = (Iterator)obj;
            } else assert (false) : "Iterable or Iterator are expected";
            if (!this.next.hasNext()) continue;
            this.more = true;
            return true;
        }
        this.more = false;
        return false;
    }

    @Override
    public T nextX() {
        if (this.hasNext()) {
            this.moved = true;
            return this.next.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void removeX() {
        assert (this.next != null);
        this.next.remove();
    }

    public String toString() {
        return S.toString(FlatIterator.class, this);
    }
}

