/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.util.IgniteStopwatch;
import org.jetbrains.annotations.NotNull;

public class TimeBag {
    private final CompositeStage INITIAL_STAGE = new CompositeStage("", 0L, new HashMap<String, List<Stage>>());
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final IgniteStopwatch globalStopwatch = IgniteStopwatch.createStarted();
    private final TimeUnit measurementUnit;
    private final List<CompositeStage> stages;
    private Map<String, List<Stage>> localStages;
    private final ThreadLocal<CompositeStage> tlLastSeenStage = ThreadLocal.withInitial(() -> this.INITIAL_STAGE);
    private final ThreadLocal<IgniteStopwatch> tlStopwatch = ThreadLocal.withInitial(IgniteStopwatch::createUnstarted);

    public TimeBag() {
        this(TimeUnit.MILLISECONDS);
    }

    public TimeBag(TimeUnit measurementUnit) {
        this.stages = new ArrayList<CompositeStage>();
        this.localStages = new ConcurrentHashMap<String, List<Stage>>();
        this.measurementUnit = measurementUnit;
        this.stages.add(this.INITIAL_STAGE);
    }

    private CompositeStage lastCompletedGlobalStage() {
        assert (!this.stages.isEmpty()) : "No stages :(";
        return this.stages.get(this.stages.size() - 1);
    }

    public void finishGlobalStage(String description) {
        this.lock.writeLock().lock();
        try {
            this.stages.add(new CompositeStage(description, this.globalStopwatch.elapsed(this.measurementUnit), Collections.unmodifiableMap(this.localStages)));
            this.localStages = new ConcurrentHashMap<String, List<Stage>>();
            this.globalStopwatch.reset().start();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLocalStage(String description) {
        this.lock.readLock().lock();
        try {
            Stage stage;
            CompositeStage lastSeen = this.tlLastSeenStage.get();
            CompositeStage lastCompleted = this.lastCompletedGlobalStage();
            IgniteStopwatch localStopWatch = this.tlStopwatch.get();
            if (lastSeen != lastCompleted) {
                stage = new Stage(description, this.globalStopwatch.elapsed(this.measurementUnit));
                this.tlLastSeenStage.set(lastCompleted);
            } else {
                stage = new Stage(description, localStopWatch.elapsed(this.measurementUnit));
            }
            localStopWatch.reset().start();
            String threadName = Thread.currentThread().getName();
            this.localStages.computeIfAbsent(threadName, t -> new ArrayList()).add(stage);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String measurementUnitShort() {
        switch (this.measurementUnit) {
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "mcs";
            }
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "min";
            }
            case DAYS: {
                return "days";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> stagesTimings() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> timings = new ArrayList<String>();
            long totalTime = 0L;
            for (int i = 1; i < this.stages.size(); ++i) {
                CompositeStage stage = this.stages.get(i);
                totalTime += stage.time();
                timings.add(stage.toString());
            }
            timings.add(new Stage("Total time", totalTime).toString());
            ArrayList<String> arrayList = timings;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> longestLocalStagesTimings(int maxPerCompositeStage) {
        this.lock.readLock().lock();
        try {
            ArrayList<String> timings = new ArrayList<String>();
            for (int i = 1; i < this.stages.size(); ++i) {
                CompositeStage stage = this.stages.get(i);
                if (stage.localStages.isEmpty()) continue;
                PriorityQueue<Stage> stagesByTime = new PriorityQueue<Stage>();
                for (Map.Entry threadAndStages : stage.localStages.entrySet()) {
                    for (Stage locStage : (List)threadAndStages.getValue()) {
                        stagesByTime.add(locStage);
                    }
                }
                for (int stageCount = 0; !stagesByTime.isEmpty() && stageCount < maxPerCompositeStage; ++stageCount) {
                    Stage locStage = (Stage)stagesByTime.poll();
                    timings.add(locStage.toString() + " (parent=" + stage.description() + ")");
                }
            }
            ArrayList<String> arrayList = timings;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private class Stage
    implements Comparable<Stage> {
        private final String description;
        private final long time;

        public Stage(String description, long time) {
            this.description = description;
            this.time = time;
        }

        public String description() {
            return this.description;
        }

        public long time() {
            return this.time;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("stage=").append('\"').append(this.description()).append('\"');
            sb.append(' ').append('(').append(this.time()).append(' ').append(TimeBag.this.measurementUnitShort()).append(')');
            return sb.toString();
        }

        @Override
        public int compareTo(@NotNull Stage o) {
            if (o.time < this.time) {
                return -1;
            }
            if (o.time > this.time) {
                return 1;
            }
            return o.description.compareTo(this.description);
        }
    }

    private class CompositeStage
    extends Stage {
        private final Map<String, List<Stage>> localStages;

        public CompositeStage(String description, long time, Map<String, List<Stage>> localStages) {
            super(description, time);
            this.localStages = localStages;
        }

        public Map<String, List<Stage>> localStages() {
            return this.localStages;
        }
    }
}

