/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.IgniteTicker;
import org.apache.ignite.internal.util.lang.IgniteThrowableRunner;
import org.jetbrains.annotations.NotNull;

public final class IgniteStopwatch {
    private final IgniteTicker ticker;
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;

    public static IgniteStopwatch createUnstarted() {
        return new IgniteStopwatch();
    }

    public static IgniteStopwatch createUnstarted(IgniteTicker ticker) {
        return new IgniteStopwatch(ticker);
    }

    public static IgniteStopwatch createStarted() {
        return new IgniteStopwatch().start();
    }

    public static IgniteStopwatch createStarted(IgniteTicker ticker) {
        return new IgniteStopwatch(ticker).start();
    }

    public static void logTime(IgniteLogger log, String operationName, IgniteThrowableRunner operation) throws IgniteCheckedException {
        long start = System.currentTimeMillis();
        log.info("Operation was started: operation = " + operationName);
        try {
            operation.run();
        }
        catch (Throwable ex) {
            log.info("Operation was failed: operation = " + operationName + ", elapsedTime = " + (System.currentTimeMillis() - start) + " ms");
            throw ex;
        }
        log.info("Operation was success: operation = " + operationName + ", elapsedTime = " + (System.currentTimeMillis() - start) + " ms");
    }

    IgniteStopwatch() {
        this.ticker = IgniteTicker.systemTicker();
    }

    IgniteStopwatch(@NotNull IgniteTicker ticker) {
        this.ticker = ticker;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public IgniteStopwatch start() {
        assert (!this.isRunning) : "This stopwatch is already running.";
        this.isRunning = true;
        this.startTick = this.ticker.read();
        return this;
    }

    public IgniteStopwatch stop() {
        long tick = this.ticker.read();
        assert (!this.isRunning) : "This stopwatch is already running.";
        this.isRunning = false;
        this.elapsedNanos += tick - this.startTick;
        return this;
    }

    public IgniteStopwatch reset() {
        this.elapsedNanos = 0L;
        this.isRunning = false;
        return this;
    }

    private long elapsedNanos() {
        return this.isRunning ? this.ticker.read() - this.startTick + this.elapsedNanos : this.elapsedNanos;
    }

    public long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }
}

