/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop.shuffle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.message.HadoopMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

@IgniteCodeGeneratingFail
public class HadoopDirectShuffleMessage
implements Message,
HadoopMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private HadoopJobId jobId;
    @GridToStringInclude
    private int reducer;
    private int cnt;
    private byte[] buf;
    @GridDirectTransient
    private transient int bufLen;
    private int dataLen;

    public HadoopDirectShuffleMessage() {
    }

    public HadoopDirectShuffleMessage(HadoopJobId jobId, int reducer, int cnt, byte[] buf, int bufLen, int dataLen) {
        assert (jobId != null);
        this.jobId = jobId;
        this.reducer = reducer;
        this.cnt = cnt;
        this.buf = buf;
        this.bufLen = bufLen;
        this.dataLen = dataLen;
    }

    public HadoopJobId jobId() {
        return this.jobId;
    }

    public int reducer() {
        return this.reducer;
    }

    public int count() {
        return this.cnt;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public int dataLength() {
        return this.dataLen;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("buf", this.buf)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("cnt", this.cnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("dataLen", this.dataLen)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeMessage("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeInt("reducer", this.reducer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.buf = reader.readByteArray("buf");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.cnt = reader.readInt("cnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.dataLen = reader.readInt("dataLen");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.jobId = (HadoopJobId)reader.readMessage("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.reducer = reader.readInt("reducer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HadoopDirectShuffleMessage.class);
    }

    @Override
    public short directType() {
        return -42;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.jobId.writeExternal(out);
        out.writeInt(this.reducer);
        out.writeInt(this.cnt);
        U.writeByteArray(out, this.buf);
        out.writeInt(this.dataLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = new HadoopJobId();
        this.jobId.readExternal(in);
        this.reducer = in.readInt();
        this.cnt = in.readInt();
        this.buf = U.readByteArray(in);
        this.bufLen = this.buf != null ? this.buf.length : 0;
        this.dataLen = in.readInt();
    }

    public String toString() {
        return S.toString(HadoopDirectShuffleMessage.class, this);
    }
}

