/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheMvccObsoleteTtlEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheMvcc mvcc;
    private GridCacheVersion obsoleteVer;
    private long ttl;
    private long expireTime;

    GridCacheMvccObsoleteTtlEntryExtras(GridCacheMvcc mvcc, GridCacheVersion obsoleteVer, long ttl, long expireTime) {
        assert (mvcc != null);
        assert (obsoleteVer != null);
        assert (expireTime != 0L);
        this.mvcc = mvcc;
        this.obsoleteVer = obsoleteVer;
        this.ttl = ttl;
        this.expireTime = expireTime;
    }

    @Override
    public GridCacheMvcc mvcc() {
        return this.mvcc;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        if (mvcc != null) {
            this.mvcc = mvcc;
            return this;
        }
        return new GridCacheObsoleteTtlEntryExtras(this.obsoleteVer, this.ttl, this.expireTime);
    }

    @Override
    public GridCacheVersion obsoleteVersion() {
        return this.obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        if (obsoleteVer != null) {
            this.obsoleteVer = obsoleteVer;
            return this;
        }
        return new GridCacheMvccTtlEntryExtras(this.mvcc, this.ttl, this.expireTime);
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        if (expireTime != 0L) {
            this.ttl = ttl;
            this.expireTime = expireTime;
            return this;
        }
        return new GridCacheMvccObsoleteEntryExtras(this.mvcc, this.obsoleteVer);
    }

    @Override
    public int size() {
        return 32;
    }

    public String toString() {
        return S.toString(GridCacheMvccObsoleteTtlEntryExtras.class, this);
    }
}

