/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.client.util.GridClientUtils;

public class GridClientStripedLock {
    private final Lock[] locks;

    public GridClientStripedLock(int concurrencyLevel) {
        this.locks = new Lock[concurrencyLevel];
        for (int i = 0; i < concurrencyLevel; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public int concurrencyLevel() {
        return this.locks.length;
    }

    public Lock getLock(int key) {
        return this.locks[GridClientUtils.safeAbs(key) % this.locks.length];
    }

    public Lock getLock(long key) {
        return this.locks[GridClientUtils.safeAbs((int)(key % (long)this.locks.length))];
    }

    public Lock getLock(Object o) {
        return o == null ? this.locks[0] : this.getLock(o.hashCode());
    }

    public void lock(int key) {
        this.getLock(key).lock();
    }

    public void unlock(int key) {
        this.getLock(key).unlock();
    }

    public void lock(long key) {
        this.getLock(key).lock();
    }

    public void unlock(long key) {
        this.getLock(key).unlock();
    }

    public void lock(Object o) {
        this.getLock(o).lock();
    }

    public void unlock(Object o) {
        this.getLock(o).unlock();
    }
}

