/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.io.Serializable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;

class DistributedMetaStorageUtil {
    static final String COMMON_KEY_PREFIX = "\u0000";
    private static final String KEY_PREFIX = "k-";
    private static final String VER_KEY = "ver";
    private static final String HISTORY_ITEM_KEY_PREFIX = "h-";
    private static final String CLEANUP_GUARD_KEY = "clean";

    DistributedMetaStorageUtil() {
    }

    public static byte[] marshal(JdkMarshaller marshaller, Serializable val) throws IgniteCheckedException {
        return val == null ? null : marshaller.marshal(val);
    }

    public static Serializable unmarshal(JdkMarshaller marshaller, byte[] valBytes) throws IgniteCheckedException {
        return valBytes == null ? null : (Serializable)marshaller.unmarshal(valBytes, U.gridClassLoader());
    }

    public static String localKey(String globalKey) {
        return DistributedMetaStorageUtil.localKeyPrefix() + globalKey;
    }

    public static String globalKey(String locKey) {
        assert (locKey.startsWith(DistributedMetaStorageUtil.localKeyPrefix())) : locKey;
        return locKey.substring(DistributedMetaStorageUtil.localKeyPrefix().length());
    }

    public static String localKeyPrefix() {
        return "\u0000k-";
    }

    public static String historyItemKey(long ver) {
        return DistributedMetaStorageUtil.historyItemPrefix() + Long.toString(ver + 0x1000000000000000L, 16).substring(1);
    }

    public static long historyItemVer(String histItemKey) {
        assert (histItemKey.startsWith(DistributedMetaStorageUtil.historyItemPrefix()));
        return Long.parseLong(histItemKey.substring(DistributedMetaStorageUtil.historyItemPrefix().length()), 16);
    }

    public static String historyItemPrefix() {
        return "\u0000h-";
    }

    public static String versionKey() {
        return "\u0000ver";
    }

    public static String cleanupGuardKey() {
        return "\u0000clean";
    }
}

