/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cache.binary.MetadataRequestMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateResult;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

final class ClientMetadataRequestFuture
extends GridFutureAdapter<MetadataUpdateResult> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private final GridIoManager ioMgr;
    private final GridDiscoveryManager discoMgr;
    private final int typeId;
    private final Map<Integer, ClientMetadataRequestFuture> syncMap;
    private final Queue<ClusterNode> aliveSrvNodes;
    private ClusterNode pendingNode;

    ClientMetadataRequestFuture(GridKernalContext ctx, int typeId, Map<Integer, ClientMetadataRequestFuture> syncMap) {
        this.ioMgr = ctx.io();
        this.discoMgr = ctx.discovery();
        this.aliveSrvNodes = new LinkedList<ClusterNode>(this.discoMgr.aliveServerNodes());
        this.typeId = typeId;
        this.syncMap = syncMap;
        if (log == null) {
            log = U.logger(ctx, logRef, ClientMetadataRequestFuture.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestMetadata() {
        boolean noSrvsInCluster;
        ClientMetadataRequestFuture clientMetadataRequestFuture = this;
        synchronized (clientMetadataRequestFuture) {
            while (!this.aliveSrvNodes.isEmpty()) {
                ClusterNode srvNode = this.aliveSrvNodes.poll();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Requesting metadata for typeId " + this.typeId + " from node " + srvNode.id());
                    }
                    this.ioMgr.sendToGridTopic(srvNode, GridTopic.TOPIC_METADATA_REQ, (Message)new MetadataRequestMessage(this.typeId), (byte)2);
                    if (this.discoMgr.node(srvNode.id()) == null) continue;
                    this.pendingNode = srvNode;
                    break;
                }
                catch (IgniteCheckedException ignored) {
                    U.warn(log, "Failed to request marshaller mapping from remote node (proceeding with the next one): " + srvNode);
                }
            }
            noSrvsInCluster = this.pendingNode == null;
        }
        if (noSrvsInCluster) {
            this.onDone(MetadataUpdateResult.createFailureResult(new BinaryObjectException("All server nodes have left grid, cannot request metadata [typeId: " + this.typeId + "]")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeLeft(UUID leftNodeId) {
        boolean reqAgain = false;
        ClientMetadataRequestFuture clientMetadataRequestFuture = this;
        synchronized (clientMetadataRequestFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(leftNodeId)) {
                this.aliveSrvNodes.remove(this.pendingNode);
                this.pendingNode = null;
                reqAgain = true;
            }
        }
        if (reqAgain) {
            this.requestMetadata();
        }
    }

    @Override
    public boolean onDone(@Nullable MetadataUpdateResult res, @Nullable Throwable err) {
        assert (res != null);
        boolean done = super.onDone(res, err);
        if (done) {
            this.syncMap.remove(this.typeId);
        }
        return done;
    }
}

