/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataLeafIO;

public final class MvccCacheIdAwareDataLeafIO
extends AbstractDataLeafIO {
    public static final IOVersions<MvccCacheIdAwareDataLeafIO> VERSIONS = new IOVersions((PageIO[])new MvccCacheIdAwareDataLeafIO[]{new MvccCacheIdAwareDataLeafIO(1)});

    private MvccCacheIdAwareDataLeafIO(int ver) {
        super(27, ver, 52);
    }

    @Override
    protected boolean storeCacheId() {
        return true;
    }

    @Override
    protected boolean storeMvccVersion() {
        return true;
    }

    @Override
    public int getCacheId(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 12);
    }

    @Override
    public long getMvccCoordinatorVersion(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 16);
    }

    @Override
    public long getMvccCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 24);
    }

    @Override
    public int getMvccOperationCounter(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 32);
    }

    @Override
    public long getMvccLockCoordinatorVersion(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 36);
    }

    @Override
    public long getMvccLockCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 44);
    }

    @Override
    public void setMvccLockCoordinatorVersion(long pageAddr, int idx, long lockCrd) {
        PageUtils.putLong(pageAddr, this.offset(idx) + 36, lockCrd);
    }

    @Override
    public void setMvccLockCounter(long pageAddr, int idx, long lockCntr) {
        PageUtils.putLong(pageAddr, this.offset(idx) + 44, lockCntr);
    }
}

