/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.util.Collection;
import org.apache.ignite.binary.BinaryRawWriter;

public class ClientConnectableNodePartitions {
    private final int port;
    private final Collection<String> addrs;
    private final int[] parts;

    public ClientConnectableNodePartitions(int port, Collection<String> addrs, int[] parts) {
        this.port = port;
        this.addrs = addrs;
        this.parts = parts;
    }

    public int getPort() {
        return this.port;
    }

    public Collection<String> getAddress() {
        return this.addrs;
    }

    public int[] getPartitions() {
        return this.parts;
    }

    public void write(BinaryRawWriter writer) {
        writer.writeInt(this.port);
        writer.writeInt(this.addrs.size());
        for (String addr : this.addrs) {
            writer.writeString(addr);
        }
        writer.writeInt(this.parts.length);
        for (Object part : (Object)this.parts) {
            writer.writeInt((int)part);
        }
    }
}

