/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgfsNodePredicate
implements IgnitePredicate<ClusterNode>,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private String igfsName;

    public IgfsNodePredicate() {
    }

    public IgfsNodePredicate(@Nullable String igfsName) {
        this.igfsName = igfsName;
    }

    @Override
    public boolean apply(ClusterNode node) {
        return IgfsUtils.isIgfsNode(node, this.igfsName);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeString(this.igfsName);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        this.igfsName = rawReader.readString();
    }

    public String toString() {
        return S.toString(IgfsNodePredicate.class, this);
    }
}

