/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageMvccMarkUpdatedRecord
extends PageDeltaRecord {
    private int itemId;
    private long newMvccCrd;
    private long newMvccCntr;
    private int newMvccOpCntr;

    public DataPageMvccMarkUpdatedRecord(int grpId, long pageId, int itemId, long newMvccCrd, long newMvccCntr, int newMvccOpCntr) {
        super(grpId, pageId);
        this.itemId = itemId;
        this.newMvccCrd = newMvccCrd;
        this.newMvccCntr = newMvccCntr;
        this.newMvccOpCntr = newMvccOpCntr;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        DataPageIO io = (DataPageIO)PageIO.getPageIO(pageAddr);
        io.updateNewVersion(pageAddr, this.itemId, pageMem.realPageSize(this.groupId()), this.newMvccCrd, this.newMvccCntr, this.newMvccOpCntr);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.MVCC_DATA_PAGE_MARK_UPDATED_RECORD;
    }

    public int itemId() {
        return this.itemId;
    }

    public long newMvccCrd() {
        return this.newMvccCrd;
    }

    public long newMvccCntr() {
        return this.newMvccCntr;
    }

    public int newMvccOpCntr() {
        return this.newMvccOpCntr;
    }

    @Override
    public String toString() {
        return S.toString(DataPageMvccMarkUpdatedRecord.class, this, "super", super.toString());
    }
}

