/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.marshaller.optimized.OptimizedClassDescriptor;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerIdMapper;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectInputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectStreamRegistry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.AbstractNodeNameAwareMarshaller;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class OptimizedMarshaller
extends AbstractNodeNameAwareMarshaller {
    public static final boolean USE_DFLT_SUID = IgniteSystemProperties.getBoolean("IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID", false);
    private final ClassLoader dfltClsLdr = this.getClass().getClassLoader();
    private boolean requireSer = true;
    private OptimizedMarshallerIdMapper mapper;
    private final ConcurrentMap<Class, OptimizedClassDescriptor> clsMap = new ConcurrentHashMap<Class, OptimizedClassDescriptor>();

    public OptimizedMarshaller() {
        if (!OptimizedMarshaller.available()) {
            throw new IgniteException("Using OptimizedMarshaller on unsupported JVM version (some of JVM-private APIs required for the marshaller to work are missing).");
        }
    }

    public OptimizedMarshaller(boolean requireSer) {
        this.requireSer = requireSer;
    }

    public OptimizedMarshaller setRequireSerializable(boolean requireSer) {
        this.requireSer = requireSer;
        return this;
    }

    public OptimizedMarshaller setIdMapper(OptimizedMarshallerIdMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public OptimizedMarshaller setPoolSize(int poolSize) {
        OptimizedObjectStreamRegistry.poolSize(poolSize);
        return this;
    }

    @Override
    protected void marshal0(@Nullable Object obj, OutputStream out) throws IgniteCheckedException {
        assert (out != null);
        OptimizedObjectOutputStream objOut = null;
        try {
            objOut = OptimizedObjectStreamRegistry.out();
            objOut.context(this.clsMap, this.ctx, this.mapper, this.requireSer);
            objOut.out().outputStream(out);
            objOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to serialize object: " + obj, e);
        }
        finally {
            OptimizedObjectStreamRegistry.closeOut(objOut);
        }
    }

    @Override
    protected byte[] marshal0(@Nullable Object obj) throws IgniteCheckedException {
        OptimizedObjectOutputStream objOut = null;
        try {
            objOut = OptimizedObjectStreamRegistry.out();
            objOut.context(this.clsMap, this.ctx, this.mapper, this.requireSer);
            objOut.writeObject(obj);
            byte[] byArray = objOut.out().array();
            return byArray;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to serialize object: " + obj, e);
        }
        finally {
            OptimizedObjectStreamRegistry.closeOut(objOut);
        }
    }

    @Override
    protected <T> T unmarshal0(InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (in != null);
        OptimizedObjectInputStream objIn = null;
        try {
            objIn = OptimizedObjectStreamRegistry.in();
            objIn.context(this.clsMap, this.ctx, this.mapper, clsLdr != null ? clsLdr : this.dfltClsLdr);
            objIn.in().inputStream(in);
            Object object = objIn.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IgniteCheckedException("Failed to find class with given class loader for unmarshalling (make sure same versions of all classes are available on all nodes or enable peer-class-loading) [clsLdr=" + clsLdr + ", cls=" + e.getMessage() + "]", e);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to deserialize object with given class loader: [clsLdr=" + clsLdr + ", err=" + e.getMessage() + "]", e);
        }
        finally {
            OptimizedObjectStreamRegistry.closeIn(objIn);
        }
    }

    @Override
    protected <T> T unmarshal0(byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (arr != null);
        OptimizedObjectInputStream objIn = null;
        try {
            objIn = OptimizedObjectStreamRegistry.in();
            objIn.context(this.clsMap, this.ctx, this.mapper, clsLdr != null ? clsLdr : this.dfltClsLdr);
            objIn.in().bytes(arr, arr.length);
            Object object = objIn.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IgniteCheckedException("Failed to find class with given class loader for unmarshalling (make sure same version of all classes are available on all nodes or enable peer-class-loading) [clsLdr=" + clsLdr + ", cls=" + e.getMessage() + "]", e);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to deserialize object with given class loader: " + clsLdr, e);
        }
        finally {
            OptimizedObjectStreamRegistry.closeIn(objIn);
        }
    }

    public static boolean available() {
        try {
            Class<Unsafe> unsafeCls = Unsafe.class;
            unsafeCls.getMethod("allocateInstance", Class.class);
            unsafeCls.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    @Override
    public void onUndeploy(ClassLoader ldr) {
        for (Class cls : this.clsMap.keySet()) {
            if (!ldr.equals(cls.getClassLoader())) continue;
            this.clsMap.remove(cls);
        }
        U.clearClassCache(ldr);
    }

    public String toString() {
        return S.toString(OptimizedMarshaller.class, this);
    }
}

