/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.GridNodePredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class F0 {
    public static <T> IgnitePredicate<T> not(final IgnitePredicate<? super T> ... p) {
        return F.isAlwaysFalse(p) ? F.alwaysTrue() : (F.isAlwaysTrue(p) ? F.alwaysFalse() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !F.isAll(t, p);
            }
        });
    }

    public static <T> IgnitePredicate<T> notEqualTo(final @Nullable T target) {
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !F.eq(t, target);
            }
        };
    }

    public static <T> IgnitePredicate<T> notIn(final @Nullable Collection<? extends T> c) {
        return F.isEmpty(c) ? GridFunc.alwaysTrue() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !c.contains(t);
            }
        };
    }

    public static <T> IgnitePredicate<T> equalTo(final @Nullable T target) {
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                return F.eq(t, target);
            }
        };
    }

    public static <T> IgnitePredicate<T> and(final @Nullable IgnitePredicate<? super T>[] p1, final IgnitePredicate<? super T> ... p2) {
        if (F.isAlwaysFalse(p1) || F.isAlwaysFalse(p2)) {
            return F.alwaysFalse();
        }
        if (F.isAlwaysTrue(p1) && F.isAlwaysTrue(p2)) {
            return F.alwaysTrue();
        }
        final boolean e1 = F.isEmpty(p1);
        final boolean e2 = F.isEmpty(p2);
        if (e1 && e2) {
            return F.alwaysTrue();
        }
        if (e1 && p2.length == 1) {
            return p2[0];
        }
        if (!e1 && e2 && p1.length == 1) {
            return p1[0];
        }
        if ((e1 || F0.isAllNodePredicates(p1)) && (e2 || F0.isAllNodePredicates(p2))) {
            GridLeanSet<UUID> ids = new GridLeanSet<UUID>();
            if (!e1) {
                for (IgnitePredicate<? super T> p : p1) {
                    ids.addAll(((GridNodePredicate)p).nodeIds());
                }
            }
            if (!e2) {
                for (IgnitePredicate<? super T> p : p2) {
                    ids.addAll(((GridNodePredicate)p).nodeIds());
                }
            }
            return new GridNodePredicate((Set<UUID>)ids);
        }
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                if (!e1) {
                    for (IgnitePredicate p : p1) {
                        if (p == null || p.apply(t)) continue;
                        return false;
                    }
                }
                if (!e2) {
                    for (IgnitePredicate p : p2) {
                        if (p == null || p.apply(t)) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static <T> IgnitePredicate<T> and(final @Nullable IgnitePredicate<? super T> p, final IgnitePredicate<? super T> ... ps) {
        if (p == null && F.isEmptyOrNulls(ps)) {
            return F.alwaysTrue();
        }
        if (F.isAlwaysFalse(p) && F.isAlwaysFalse(ps)) {
            return F.alwaysFalse();
        }
        if (F.isAlwaysTrue(p) && F.isAlwaysTrue(ps)) {
            return F.alwaysTrue();
        }
        if (F0.isAllNodePredicates(p) && F0.isAllNodePredicates(ps)) {
            assert (ps != null);
            GridLeanSet<UUID> ids = new GridLeanSet<UUID>();
            for (IgnitePredicate<? super T> p0 : ps) {
                Set<UUID> list = ((GridNodePredicate)p0).nodeIds();
                if (ids.isEmpty()) {
                    ids.addAll(list);
                    continue;
                }
                ids.retainAll(list);
            }
            Set<UUID> list = ((GridNodePredicate)p).nodeIds();
            if (ids.isEmpty()) {
                ids.addAll(list);
            } else {
                ids.retainAll(list);
            }
            return new GridNodePredicate((Set<UUID>)ids);
        }
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                assert (ps != null);
                if (p != null && !p.apply(t)) {
                    return false;
                }
                for (IgnitePredicate p2 : ps) {
                    if (p2 == null || p2.apply(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> IgnitePredicate<T> in(final @Nullable Collection<? extends T> c) {
        return F.isEmpty(c) ? GridFunc.alwaysFalse() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return c.contains(t);
            }
        };
    }

    public static <T> IgnitePredicate<T> contains(final @Nullable Collection<T> c) {
        return c == null || c.isEmpty() ? GridFunc.alwaysFalse() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return c.contains(t);
            }
        };
    }

    public static <T> IgnitePredicate<T> notContains(final @Nullable Collection<T> c) {
        return c == null || c.isEmpty() ? GridFunc.alwaysTrue() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !c.contains(t);
            }
        };
    }

    public static boolean isAllNodePredicates(IgnitePredicate<?> ... ps) {
        if (F.isEmpty(ps)) {
            return false;
        }
        for (IgnitePredicate<?> p : ps) {
            if (p instanceof GridNodePredicate) continue;
            return false;
        }
        return true;
    }

    public static <K, V> Map<K, V> asMap(K key, V val) {
        A.notNull(val, "val");
        return F.asMap(key, val);
    }
}

