/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster.baseline.autoadjust;

class BaselineAutoAdjustData {
    public static final BaselineAutoAdjustData NULL_BASELINE_DATA = BaselineAutoAdjustData.nullValue();
    private final long targetTopologyVersion;
    private volatile boolean invalidated = false;
    private volatile boolean adjusted = false;

    BaselineAutoAdjustData(long targetTopologyVersion) {
        this.targetTopologyVersion = targetTopologyVersion;
    }

    private static BaselineAutoAdjustData nullValue() {
        BaselineAutoAdjustData data = new BaselineAutoAdjustData(-1L);
        data.onInvalidate();
        data.onAdjust();
        return data;
    }

    private void onInvalidate() {
        this.invalidated = true;
    }

    public void onAdjust() {
        this.adjusted = true;
    }

    public long getTargetTopologyVersion() {
        return this.targetTopologyVersion;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean isAdjusted() {
        return this.adjusted;
    }

    public BaselineAutoAdjustData next(long targetTopologyVersion) {
        this.onInvalidate();
        return new BaselineAutoAdjustData(targetTopologyVersion);
    }
}

